/*//////////////////////////////////////////////////////////////////////////

	flaXen's De-Sharpen Filter for VirtualDub
	(c) Copyright 2001 Dan Flower (flaXen)

	Attempt to reduce or eliminate halo's caused by over-sharpening

*//////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <stdio.h>

#include "resource.h"
#include "filter.h"
#include "ScriptInterpreter.h"
#include "ScriptError.h"
#include "ScriptValue.h"

typedef struct MyFilterData {
	Pixel32	*TmpBuff, *TmpBuff2;
	long	*ytab, *itab, *qtab;
	long	*rtab, *gtab, *btab;
	long	*cytf, *eiScale;
	int		dsAmt, dsRad, dsDbg;
	int		YIQin, YIQout, YUVtog;
} MyFilterData;

///////////////////////////////////////////////////////////////////////////

int		fxAWSRunProc(const FilterActivation *fa, const FilterFunctions *ff);
void	fxAWS_RGB2YIQ(Pixel32 *, Pixel32 *, long, long, long, MyFilterData *);
void	fxAWS_YIQ2RGB(Pixel32 *, Pixel32 *, long, long, long, MyFilterData *);
void	fxAWS_DeSharpen(Pixel32 *, Pixel32 *, long, long, long, MyFilterData *);
int		fxAWSStartProc(FilterActivation *fa, const FilterFunctions *ff);
int		fxAWSEndProc(FilterActivation *fa, const FilterFunctions *ff); 
int		fxAWSInitProc(FilterActivation *fa, const FilterFunctions *ff);
int		fxAWSConfigProc(FilterActivation *fa, const FilterFunctions *ff, HWND hwnd);
void	fxAWSStringProc(const FilterActivation *fa, const FilterFunctions *ff, char *buf);
void	fxAWSScriptConfig(IScriptInterpreter *isi, void *lpVoid, CScriptValue *argv, int argc);
bool	fxAWSFssProc(FilterActivation *fa, const FilterFunctions *ff, char *buf, int buflen);

///////////////////////////////////////////////////////////////////////////

ScriptFunctionDef fxAWS_func_defs[]={
    { (ScriptFunctionPtr)fxAWSScriptConfig, "Config", "0iiiii" },
    { NULL },
};

CScriptObject fxAWSobj={
    NULL, fxAWS_func_defs
};

struct FilterDefinition filterDef_fxAWS = {
	NULL, NULL, NULL,		// next, prev, module

	"De-Sharpen",	// name
	"flaXen's De-Sharpen (Prototype)",	// desc
	"flaXen",				// maker

	NULL,					// private_data
	sizeof(MyFilterData),	// inst_data_size
	fxAWSInitProc,			// initProc
	NULL,					// deinitProc
	fxAWSRunProc,			// runProc
	NULL,					// paramProc
	fxAWSConfigProc,		// configProc
	fxAWSStringProc,		// stringProc
	fxAWSStartProc,			// startProc
	fxAWSEndProc,			// endProc
	&fxAWSobj,				// script_obj
	fxAWSFssProc,			// fssProc
};

///////////////////////////////////////////////////////////////////////////

extern "C" int __declspec(dllexport) __cdecl VirtualdubFilterModuleInit2(FilterModule *fm, const FilterFunctions *ff, int& vdfd_ver, int& vdfd_compat);
extern "C" void __declspec(dllexport) __cdecl VirtualdubFilterModuleDeinit(FilterModule *fm, const FilterFunctions *ff);

static FilterDefinition *fd_fxAWS;

int __declspec(dllexport) __cdecl VirtualdubFilterModuleInit2(FilterModule *fm, const FilterFunctions *ff, int& vdfd_ver, int& vdfd_compat) {
	if (!(fd_fxAWS = ff->addFilter(fm, &filterDef_fxAWS, sizeof(FilterDefinition))))
		return 1;

	vdfd_ver    = VIRTUALDUB_FILTERDEF_VERSION;
	vdfd_compat = VIRTUALDUB_FILTERDEF_COMPATIBLE;
	return 0;
}

void __declspec(dllexport) __cdecl VirtualdubFilterModuleDeinit(FilterModule *fm, const FilterFunctions *ff) {
	ff->removeFilter(fd_fxAWS);
}

///////////////////////////////////////////////////////////////////////////

int fxAWSRunProc(const FilterActivation *fa, const FilterFunctions *ff) {
	MyFilterData	*mfd = (MyFilterData *)fa->filter_data;
	Pixel32	*isrc, *idst, *itmp, *itm2;
	const long	swid = fa->src.w, shei = fa->src.h;
	const long	spit = fa->src.pitch >> 2;
	const long	ssize = fa->src.pitch * fa->src.h;

	isrc = (Pixel32 *)fa->src.data;
	idst = (Pixel32 *)fa->dst.data;
	itmp = (Pixel32 *)mfd->TmpBuff;
	itm2 = (Pixel32 *)mfd->TmpBuff2;

	if (mfd->YIQin == BST_CHECKED) {
		// YUV/YIQ colorspace input
		if (mfd->YIQout == BST_UNCHECKED) {
			// RGB colorspace output
			//memcpy(itmp, isrc, ssize);
			//fxAWS_Interp(isrc, itmp, swid, shei, spit, mfd);
			fxAWS_DeSharpen(isrc, itmp, swid, shei, spit, mfd);
			fxAWS_YIQ2RGB(itmp, idst, swid, shei, spit, mfd);
		} else {
			// YIQ/YUV colorspace output
			//memcpy(idst, isrc, ssize);
			//fxAWS_Interp(isrc, idst, swid, shei, spit, mfd);
			fxAWS_DeSharpen(isrc, idst, swid, shei, spit, mfd);
		}
	} else {
		// RGB colorspace input
		if (mfd->YIQout == BST_UNCHECKED) {
			// RGB colorspace output
			fxAWS_RGB2YIQ(isrc, itmp, swid, shei, spit, mfd);
			//fxAWS_Interp(itmp, itmp, swid, shei, spit, mfd);
			fxAWS_DeSharpen(itmp, itm2, swid, shei, spit, mfd);
			fxAWS_YIQ2RGB(itm2, idst, swid, shei, spit, mfd);
			
			//fxAWS_Sharpen(isrc, idst, 1, swid, shei, spit, mfd);
			//fxAWS_Sharpen(isrc, idst, 2, swid, shei, spit, mfd);
		} else {
			// YIQ colorspace output
			fxAWS_RGB2YIQ(isrc, itmp, swid, shei, spit, mfd);
			//fxAWS_Interp(itmp, itmp, swid, shei, spit, mfd);
			fxAWS_DeSharpen(itmp, idst, swid, shei, spit, mfd);
			//memcpy(idst, itmp, ssize);
		}
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////

void	fxAWS_DeSharpen(Pixel32 *isrc, Pixel32 *idst, long swid, long shei, long spit, MyFilterData *mfd) {
	Pixel32	*src, *dst, *smp;
	long	x, y, xx, yy, c, cs, i, d, r;

	r = mfd->dsRad;
	if (r == 0) r = 1;
	d = (r * 2) * (r * 2) - 1;
	for (y = r; y < shei - r; y++) {
		src = isrc + y * spit + r;
		dst = idst + y * spit + r;
		for (x = r; x < swid - r; x++) {
			c = (*src & 0x00FF0000L) >> 16;
			/*cs = (*(src - 1) & 0x00FF0000L) + (*(src + 1) & 0x00FF0000L);
			cs+= (*(src - spit - 1) & 0x00FF0000L) + (*(src - spit) & 0x00FF0000L) + (*(src - spit + 1) & 0x00FF0000L);
			cs+= (*(src + spit - 1) & 0x00FF0000L) + (*(src + spit) & 0x00FF0000L) + (*(src + spit + 1) & 0x00FF0000L);
			cs >>= 19;	// 16 for offset plus 3 for divide by 8
			*/
			cs = 0;// d = 0;
			for (yy = y - r; yy < y + r; yy++) {
				smp = isrc + yy * spit + x - r;
				for (xx = x - r; xx < x + r; xx++)
					if (xx - x | yy - y) cs += (*smp++) & 0x00FF0000L;
			}
			cs = (cs / d) >> 16;
			
			i = c - cs;

			//if (i > 10 && i < 20)
			if (i < 0) i = 0;
			c = c - mfd->eiScale[i];
			if (c < 0) c = 0;
			c = (*src & 0xFF00FFFF) | (c << 16);

			//c = (*src & 0xFF00FFFF) | (cs << 16);

			//c = mfd->drDbg == BST_UNCHECKED ? *src : 0; //((*src & 0x00F0F0F0L) >> 4) | 0x00707070L;

			*src++;
			*dst++ = c;
		}
	}
}

///////////////////////////////////////////////////////////////////////////

void	fxAWS_RGB2YIQ(Pixel32 *isrc, Pixel32 *idst, long swid, long shei, long spit, MyFilterData *mfd) {
	Pixel32	*src, *dst;
	long	y, c;
	long	*ytab = (long *)mfd->ytab;
	long	*itab = (long *)mfd->itab;
	long	*qtab = (long *)mfd->qtab;

	if (mfd->YUVtog == BST_CHECKED) {
		// Convert RGB -> YIQ
		for (y = 0; y < shei; y++) {
			src = isrc + y * spit;
			dst = idst + y * spit;
			__asm {
				push	esi
				push	edi
				mov		ecx, [swid]

cty10:			mov		esi, [src]
				add		[src], 4
				mov		edx, [esi]
				mov		ebx, edx
				shr		ebx, 6
				and		ebx, 0x0003FCL
				mov		eax, edx
				shr		eax, 14
				and		eax, 0x0003FCL
				shl		edx, 2
				and		edx, 0x0003FCL
				add		ebx, 1024
				add		edx, 2048

				mov		esi, [ytab]
				mov		edi, [esi + eax]
				add		edi, [esi + ebx]
				add		edi, [esi + edx]
				and		edi, 0xFFFF0000L
				js		cty20
				test	edi, 0xFF000000L
				jz		cty21
				mov		edi, 0x00FF0000L
				jmp		cty21
cty20:			xor		edi, edi
cty21:			mov		[c], edi

				mov		esi, [itab]
				mov		edi, [esi + eax]
				add		edi, [esi + ebx]
				add		edi, [esi + edx]
				and		edi, 0xFFFF0000L
				js		cty30
				test	edi, 0xFF000000L
				jz		cty31
				mov		edi, 0x00FF0000L
				jmp		cty31
cty30:			xor		edi, edi
cty31:			shr		edi, 8
				or		[c], edi

				mov		esi, [qtab]
				mov		edi, [esi + eax]
				add		edi, [esi + ebx]
				add		edi, [esi + edx]
				and		edi, 0xFFFF0000L
				js		cty40
				test	edi, 0xFF000000L
				jz		cty41
				mov		edi, 0x00FF0000L
cty40:			xor		edi, edi
cty41:			shr		edi, 16
				or		[c], edi

				mov		edi, [dst]
				add		[dst], 4
				mov		eax, [c]
				mov		[edi], eax

				dec		ecx
				jnz		cty10
				pop		edi
				pop		esi
			}
		}
	} else {
		// Convert RGB -> YUV
		for (y = 0; y < shei; y++) {
			src = isrc + y * spit;
			dst = idst + y * spit;
			__asm {
				push	esi
				push	edi
				mov		ecx, [swid]

ctu10:			mov		esi, [src]
				add		[src], 4
				mov		edx, [esi]
				mov		ebx, edx
				shr		ebx, 6
				and		ebx, 0x0003FCL
				mov		eax, edx
				shr		eax, 14
				and		eax, 0x0003FCL
				shl		edx, 2
				and		edx, 0x0003FCL
				add		ebx, 1024
				add		edx, 2048

				mov		esi, [ytab]
				mov		edi, [esi + eax]
				add		edi, [esi + ebx]
				add		edi, [esi + edx]
				and		edi, 0xFFFF0000L
				js		ctu20
				test	edi, 0xFF000000L
				jz		ctu21
				mov		edi, 0x00FF0000L
				jmp		ctu21
ctu20:			xor		edi, edi
ctu21:			mov		[c], edi

				mov		esi, [itab]
				mov		edi, [esi + eax]
				add		edi, [esi + ebx]
				add		edi, [esi + edx]
				and		edi, 0xFFFF0000L
				js		ctu30
				test	edi, 0xFF000000L
				jz		ctu31
				mov		edi, 0x00FF0000L
				jmp		ctu31
ctu30:			xor		edi, edi
ctu31:			shr		edi, 8
				or		[c], edi

				mov		esi, [qtab]
				mov		edi, [esi + eax]
				add		edi, [esi + ebx]
				add		edi, [esi + edx]
				and		edi, 0xFFFF0000L
				js		ctu40
				test	edi, 0xFF000000L
				jz		ctu41
				mov		edi, 0x00FF0000L
				jmp		ctu41
ctu40:			xor		edi, edi
ctu41:			shr		edi, 16
				or		[c], edi

				mov		edi, [dst]
				add		[dst], 4
				mov		eax, [c]
				mov		[edi], eax

				dec		ecx
				jnz		ctu10
				pop		edi
				pop		esi
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////

void	fxAWS_YIQ2RGB(Pixel32 *isrc, Pixel32 *idst, long swid, long shei, long spit, MyFilterData *mfd) {
	Pixel32	*src, *dst;
	long	y, c;
	long	*rtab = (long *)mfd->rtab;
	long	*gtab = (long *)mfd->gtab;
	long	*btab = (long *)mfd->btab;
	long	*cytf = (long *)mfd->cytf;

	if (mfd->YUVtog == BST_CHECKED) {
		for (y = 0; y < shei; y++) {
			src = isrc + y * spit;
			dst = idst + y * spit;
			__asm {
				push	esi
				push	edi
				mov		ecx, [swid]

cfy10:			mov		esi, [src]
				add		[src], 4
				mov		edx, [esi]
				mov		ebx, edx
				shr		ebx, 6
				and		ebx, 0x0003FCL
				mov		eax, edx
				and		eax, 0x00FF0000L
				shl		edx, 2
				and		edx, 0x0003FCL
				add		edx, 1024

				mov		edi, eax
				mov		esi, [rtab]
				add		edi, [esi + ebx]
				add		edi, [esi + edx]
				and		edi, 0xFFFF0000L
				js		cfy20
				test	edi, 0xFF000000L
				jz		cfy21
				mov		edi, 0x00FF0000L
				jmp		cfy21
cfy20:			xor		edi, edi
cfy21:			mov		[c], edi

				mov		edi, eax
				mov		esi, [gtab]
				add		edi, [esi + ebx]
				add		edi, [esi + edx]
				and		edi, 0xFFFF0000L
				js		cfy30
				test	edi, 0xFF000000L
				jz		cfy31
				mov		edi, 0x00FF0000L
				jmp		cfy31
cfy30:			xor		edi, edi
cfy31:			shr		edi, 8
				or		[c], edi

				mov		edi, eax
				mov		esi, [btab]
				add		edi, [esi + ebx]
				add		edi, [esi + edx]
				and		edi, 0xFFFF0000L
				js		cfy40
				test	edi, 0xFF000000L
				jz		cfy41
				mov		edi, 0x00FF0000L
				jmp		cfy41
cfy40:			xor		edi, edi
cfy41:			shr		edi, 16
				or		[c], edi

				mov		edi, [dst]
				add		[dst], 4
				mov		eax, [c]
				mov		[edi], eax

				dec		ecx
				jnz		cfy10
				pop		edi
				pop		esi
			}
		}
	} else {
		for (y = 0; y < shei; y++) {
			src = isrc + y * spit;
			dst = idst + y * spit;
			__asm {
				push	esi
				push	edi
				mov		ecx, [swid]

cfu10:			mov		esi, [src]
				add		[src], 4
				mov		edx, [esi]
				mov		ebx, edx
				shr		ebx, 6
				and		ebx, 0x0003FCL
				mov		eax, edx
				shr		eax, 14
				and		eax, 0x0003FCL
				shl		edx, 2
				and		edx, 0x0003FCL
				add		edx, 1024

				mov		esi, [cytf]
				mov		eax, [esi + eax]

				mov		edi, eax
				mov		esi, [rtab]
				add		edi, [esi + ebx]
				and		edi, 0xFFFF0000L
				js		cfu20
				test	edi, 0xFF000000L
				jz		cfu21
				mov		edi, 0x00FF0000L
				jmp		cfu21
cfu20:			xor		edi, edi
cfu21:			mov		[c], edi

				mov		edi, eax
				mov		esi, [gtab]
				add		edi, [esi + ebx]
				add		edi, [esi + edx]
				and		edi, 0xFFFF0000L
				js		cfu30
				test	edi, 0xFF000000L
				jz		cfu31
				mov		edi, 0x00FF0000L
				jmp		cfu31
cfu30:			xor		edi, edi
cfu31:			shr		edi, 8
				or		[c], edi

				mov		edi, eax
				mov		esi, [btab]
				add		edi, [esi + edx]
				and		edi, 0xFFFF0000L
				js		cfu40
				test	edi, 0xFF000000L
				jz		cfu41
				mov		edi, 0x00FF0000L
				jmp		cfu41
cfu40:			xor		edi, edi
cfu41:			shr		edi, 16
				or		[c], edi

				mov		edi, [dst]
				add		[dst], 4
				mov		eax, [c]
				mov		[edi], eax

				dec		ecx
				jnz		cfu10
				pop		edi
				pop		esi
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////

int fxAWSStartProc(FilterActivation *fa, const FilterFunctions *ff) {
	MyFilterData *mfd = (MyFilterData *)fa->filter_data;
	long	d;

	if (!(mfd->eiScale = new long[256])) return 1;
	for (d = 0; d < 256; d++) {
		mfd->eiScale[d] = (long)(double)((double)mfd->dsAmt / 255.0 * (double)d + 0.5);
	}

	// Temporary frame buffer
	d = fa->src.pitch * fa->src.h;
	if (!(mfd->TmpBuff = new Pixel32[d])) return 1;
	if (!(mfd->TmpBuff2 = new Pixel32[d])) return 1;

	// Y transform for YUV -> RGB conversion
	if (!(mfd->cytf = new long[256])) return 1;

	// RGB -> Ycc conversion tables
	if (!(mfd->ytab = new long[768])) return 1;
	if (!(mfd->itab = new long[768])) return 1;
	if (!(mfd->qtab = new long[768])) return 1;

	// Ycc -> RGB conversion tables
	if (!(mfd->rtab = new long[512])) return 1;
	if (!(mfd->gtab = new long[512])) return 1;
	if (!(mfd->btab = new long[512])) return 1;

	// Calculate data for RGB -> Ycc conversion tables
	for (d = 0; d < 256; d++) {
		if (mfd->YUVtog == BST_CHECKED) {
			// RGB -> YIQ transformation matrix
			mfd->ytab[d      ] = (long)(+0.299 * d * 65536 + 0.5);
			mfd->ytab[d + 256] = (long)(+0.587 * d * 65536 + 0.5);
			mfd->ytab[d + 512] = (long)(+0.114 * d * 65536 + 0.5);
			mfd->itab[d      ] = (long)(+0.596 * d * 65536 + 0.5) + 8388608;
			mfd->itab[d + 256] = (long)(-0.275 * d * 65536 + 0.5);
			mfd->itab[d + 512] = (long)(-0.321 * d * 65536 + 0.5);
			mfd->qtab[d      ] = (long)(+0.212 * d * 65536 + 0.5) + 8388608;
			mfd->qtab[d + 256] = (long)(-0.523 * d * 65536 + 0.5);
			mfd->qtab[d + 512] = (long)(+0.311 * d * 65536 + 0.5);
			// YIQ -> RGB transformation matrix
			mfd->rtab[d      ] = (long)(+0.956 * (d-128) * 65536 + 0.5);
			mfd->rtab[d + 256] = (long)(+0.621 * (d-128) * 65536 + 0.5);
			mfd->gtab[d      ] = (long)(-0.272 * (d-128) * 65536 + 0.5);
			mfd->gtab[d + 256] = (long)(-0.647 * (d-128) * 65536 + 0.5);
			mfd->btab[d      ] = (long)(-1.105 * (d-128) * 65536 + 0.5);
			mfd->btab[d + 256] = (long)(+1.702 * (d-128) * 65536 + 0.5);
		} else {
			// RGB -> YUV transformation matrix
			mfd->ytab[d      ] = (long)(+0.257 * d * 65536 + 0.5) + 1048576;
			mfd->ytab[d + 256] = (long)(+0.504 * d * 65536 + 0.5);
			mfd->ytab[d + 512] = (long)(+0.098 * d * 65536 + 0.5);
			mfd->itab[d      ] = (long)(+0.439 * d * 65536 + 0.5) + 8388608;
			mfd->itab[d + 256] = (long)(-0.368 * d * 65536 + 0.5);
			mfd->itab[d + 512] = (long)(-0.071 * d * 65536 + 0.5);
			mfd->qtab[d      ] = (long)(-0.148 * d * 65536 + 0.5) + 8388608;
			mfd->qtab[d + 256] = (long)(-0.291 * d * 65536 + 0.5);
			mfd->qtab[d + 512] = (long)(+0.439 * d * 65536 + 0.5);
			// YUV -> RGB transformation matrix
			mfd->rtab[d      ] = (long)(+1.596 * (d-128) * 65536 + 0.5);
			mfd->rtab[d + 256] = 0;
			mfd->gtab[d      ] = (long)(-0.813 * (d-128) * 65536 + 0.5);
			mfd->gtab[d + 256] = (long)(-0.391 * (d-128) * 65536 + 0.5);
			mfd->btab[d      ] = 0;
			mfd->btab[d + 256] = (long)(+2.018 * (d-128) * 65536 + 0.5);
			mfd->cytf[d] = (long)(((d - 16) * 1.164) * 65536.0 + 0.5);	// Y transform
		}
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////

int fxAWSEndProc(FilterActivation *fa, const FilterFunctions *ff) {
	MyFilterData *mfd = (MyFilterData *)fa->filter_data;

	// Delete temporary frame buffer
	delete[] mfd->TmpBuff; mfd->TmpBuff = NULL;
	delete[] mfd->TmpBuff2; mfd->TmpBuff2 = NULL;

	// Delete the Y transformation table
	delete[] mfd->cytf; mfd->cytf = NULL;

	delete[] mfd->eiScale; mfd->eiScale = NULL;

	// Delete RGB -> YIQ/YUV conversion tables
	delete[] mfd->ytab; mfd->ytab = NULL;
	delete[] mfd->itab; mfd->itab = NULL;
	delete[] mfd->qtab; mfd->qtab = NULL;
	
	delete[] mfd->rtab; mfd->rtab = NULL;
	delete[] mfd->gtab; mfd->gtab = NULL;
	delete[] mfd->btab; mfd->btab = NULL;

	return 0;
}

///////////////////////////////////////////////////////////////////////////

int fxAWSInitProc(FilterActivation *fa, const FilterFunctions *ff) {
	MyFilterData *mfd = (MyFilterData *)fa->filter_data;

	mfd->dsAmt	= 128;
	mfd->dsRad	= 3;
	mfd->dsDbg	= BST_UNCHECKED;
	mfd->YIQin	= BST_UNCHECKED;
	mfd->YIQout	= BST_UNCHECKED;
	mfd->YUVtog	= BST_CHECKED;

	return 0;
}

///////////////////////////////////////////////////////////////////////////

BOOL CALLBACK fxAWSConfigDlgProc(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam) {
	MyFilterData *mfd = (MyFilterData *)GetWindowLong(hdlg, DWL_USER);

	switch(msg) {
	case WM_INITDIALOG:
		SetWindowLong(hdlg, DWL_USER, lParam);
		mfd = (MyFilterData *)lParam;
		SetDlgItemInt(hdlg, IDC_DSAMT, mfd->dsAmt, FALSE);
		SetDlgItemInt(hdlg, IDC_DSRAD, mfd->dsRad, FALSE);
		CheckDlgButton(hdlg, IDC_DSDBG, mfd->dsDbg ? BST_CHECKED : BST_UNCHECKED);
		CheckDlgButton(hdlg, IDC_YIQIN, mfd->YIQin ? BST_CHECKED : BST_UNCHECKED);
		CheckDlgButton(hdlg, IDC_YIQOUT, mfd->YIQout ? BST_CHECKED : BST_UNCHECKED);
		CheckDlgButton(hdlg, IDC_YUVTOG, mfd->YUVtog ? BST_CHECKED : BST_UNCHECKED);
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam)) {
		case IDOK:
			mfd->dsAmt = GetDlgItemInt(hdlg, IDC_DSAMT, &mfd->dsAmt, FALSE);
			mfd->dsRad = GetDlgItemInt(hdlg, IDC_DSRAD, &mfd->dsRad, FALSE);
			mfd->dsDbg= !!IsDlgButtonChecked(hdlg, IDC_DSDBG);
			mfd->YIQin = !!IsDlgButtonChecked(hdlg, IDC_YIQIN);
			mfd->YIQout = !!IsDlgButtonChecked(hdlg, IDC_YIQOUT);
			mfd->YUVtog = !!IsDlgButtonChecked(hdlg, IDC_YUVTOG);

			if (mfd->dsAmt > 255) mfd->dsAmt = 255;
			if (mfd->dsRad == 0) mfd->dsRad = 1;
			if (mfd->dsRad > 10) mfd->dsRad = 10;

			EndDialog(hdlg, 0);

			return TRUE;
		case IDCANCEL:
			EndDialog(hdlg, 1);
			return FALSE;
		}
		break;
	}

	return FALSE;
}

///////////////////////////////////////////////////////////////////////////

int fxAWSConfigProc(FilterActivation *fa, const FilterFunctions *ff, HWND hwnd) {
	return DialogBoxParam(fa->filter->module->hInstModule,
	       MAKEINTRESOURCE(IDD_FXAWS_CONFIG), hwnd,
		   fxAWSConfigDlgProc, (LPARAM)fa->filter_data);
}

///////////////////////////////////////////////////////////////////////////

void fxAWSStringProc(const FilterActivation *fa, const FilterFunctions *ff, char *str) {
	MyFilterData *mfd = (MyFilterData *)fa->filter_data;
	char	fstr[10];

	if (mfd->YUVtog == BST_CHECKED)
		sprintf(fstr, "YIQ");
	else
		sprintf(fstr, "YUV");


	sprintf(str, "  Ammount:%d Radius:%d (%s -> %s)", mfd->dsAmt, mfd->dsRad, mfd->YIQin == BST_CHECKED ? fstr : "RGB", mfd->YIQout == BST_CHECKED ? fstr : "RGB");
}

///////////////////////////////////////////////////////////////////////////

void fxAWSScriptConfig(IScriptInterpreter *isi, void *lpVoid, CScriptValue *argv, int argc) {
    FilterActivation *fa = (FilterActivation *)lpVoid;
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;

	mfd->dsAmt = argv[0].asInt();
	mfd->dsRad = argv[1].asInt();
	mfd->YIQin = argv[2].asInt() == 1 ? BST_CHECKED : BST_UNCHECKED;
	mfd->YIQout = argv[3].asInt() == 1 ? BST_CHECKED : BST_UNCHECKED;
	mfd->YUVtog = argv[4].asInt() == 1 ? BST_CHECKED : BST_UNCHECKED;
}

///////////////////////////////////////////////////////////////////////////

bool fxAWSFssProc(FilterActivation *fa, const FilterFunctions *ff, char *buf, int buflen) {
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;

    _snprintf(buf, buflen, "Config(%d,%d,%d,%d,%d)", mfd->dsAmt, mfd->dsRad, mfd->YIQin == BST_CHECKED ? 1 : 0, mfd->YIQout == BST_CHECKED ? 1 : 0, mfd->YUVtog == BST_CHECKED ? 1 : 0);

    return true;
}