#ifndef __FILTER_AVIUTL_H__
#define __FILTER_AVIUTL_H__
/*
#pragma pack(push)
#pragma pack(1)
*/
typedef	struct {short y, cb, cr;} PIXEL_YC;
typedef	struct {unsigned char b, g, r;} PIXEL;

typedef struct 
{
	int			flag;			
	PIXEL_YC	*ycp_edit;		
	PIXEL_YC	*ycp_temp;		
	int			w,h;			
	int			max_w,max_h;	
	int			frame;			
	int			frame_n;		
	int			org_w,org_h;	
	short		*audiop;		//	PCM16bit mono = 2byte , stereo = 4byte
	int			audio_n;		
	int			audio_ch;		
	PIXEL		*pixelp;		
	void		*editp;			
	int			reserve[10];	
} FILTER_PROC_INFO;

#define	FILTER_PROC_INFO_FLAG_FILL_OVERAREA		1
#define	FILTER_PROC_INFO_FLAG_MASK				0x0fffffff

typedef struct
{
	int		video;			
	int		audio;			
	int		inter;			//	FRAME_STATUS_INTER_NORMAL	
							//	FRAME_STATUS_INTER_REVERSE	
							//	FRAME_STATUS_INTER_ODD		
							//	FRAME_STATUS_INTER_EVEN		
							//	FRAME_STATUS_INTER_MIX		
							//	FRAME_STATUS_INTER_AUTO		
	int		index24fps;		//	24fps
	int		config;			
	int		vcm;			
	int		edit_flag;		//	EDIT_FRAME_EDIT_FLAG_KEYFRAME	
							//	EDIT_FRAME_EDIT_FLAG_MARKFRAME	
							//	EDIT_FRAME_EDIT_FLAG_DELFRAME	
							//	EDIT_FRAME_EDIT_FLAG_NULLFRAME	
	int		reserve[9];		
} FRAME_STATUS;

#define	FRAME_STATUS_INTER_NORMAL		0
#define	FRAME_STATUS_INTER_REVERSE		1
#define	FRAME_STATUS_INTER_ODD			2
#define	FRAME_STATUS_INTER_EVEN			3
#define	FRAME_STATUS_INTER_MIX			4
#define	FRAME_STATUS_INTER_AUTO			5
#define	EDIT_FRAME_EDIT_FLAG_KEYFRAME		1
#define	EDIT_FRAME_EDIT_FLAG_MARKFRAME		2
#define	EDIT_FRAME_EDIT_FLAG_DELFRAME		4
#define	EDIT_FRAME_EDIT_FLAG_NULLFRAME		8

typedef struct
{
	int		flag;					//	FILE_INFO_FLAG_VIDEO	
									//	FILE_INFO_FLAG_AUDIO	
	LPSTR	name;					
	int		w,h;					
	int		video_rate,video_scale;	
	int		audio_rate;				
	int		audio_ch;				
	int		reserve[8];				
} FILE_INFO;

#define FILE_INFO_FLAG_VIDEO	1
#define FILE_INFO_FLAG_AUDIO	2

typedef struct
{
	void		*(*get_ycp_ofs)( void *editp,int n,int ofs );
	void		*(*get_ycp)( void *editp,int n );
	void		*(*get_pixelp)( void *editp,int n );
	int			(*get_audio)( void *editp,int n,void *buf );
	BOOL		(*is_editing)( void *editp );
	BOOL		(*is_saving)( void *editp );
	int			(*get_frame)( void *editp );
	int			(*get_frame_n)( void *editp );
	BOOL		(*get_frame_size)( void *editp,int *w,int *h );
	int			(*set_frame)( void *editp,int n );
	int			(*set_frame_n)( void *editp,int n );
	BOOL		(*copy_frame)( void *editp,int d,int s );
	BOOL		(*copy_video)( void *editp,int d,int s );
	BOOL		(*copy_audio)( void *editp,int d,int s );
	BOOL		(*copy_clip)( HWND hwnd,void *pixelp,int w,int h );
	BOOL		(*paste_clip)( HWND hwnd,void *editp,int n );
	BOOL		(*get_frame_status)( void *editp,int n,FRAME_STATUS *fsp );
	BOOL		(*set_frame_status)( void *editp,int n,FRAME_STATUS *fsp );
	BOOL		(*is_saveframe)( void *editp,int n );
	BOOL		(*is_keyframe)( void *editp,int n );
	BOOL		(*is_recompress)( void *editp,int n );
	BOOL		(*filter_window_update)( void *fp );
	BOOL		(*is_filter_window_disp)( void *fp );
	BOOL		(*get_file_info)( void *editp,FILE_INFO *fip );
	LPSTR		(*get_config_name)( void *editp,int n );
	BOOL		(*is_filter_active)( void *fp );
	BOOL		(*get_pixel_filtered)( void *editp,int n,void *pixelp,int *w,int *h );
	int			(*get_audio_filtered)( void *editp,int n,void *buf );
	BOOL		(*get_select_frame)( void *editp,int *s,int *e );
	BOOL		(*set_select_frame)( void *editp,int s,int e );
	BOOL		(*rgb2yc)( PIXEL_YC *ycp,PIXEL *pixelp,int w );
	BOOL		(*yc2rgb)( PIXEL *pixelp,PIXEL_YC *ycp,int w );
	BOOL		(*dlg_get_load_name)( LPSTR name,LPSTR filter,LPSTR def );
	BOOL		(*dlg_get_save_name)( LPSTR name,LPSTR filter,LPSTR def );
	int			(*ini_load_int)( void *fp,LPSTR key,int n );
	int			(*ini_save_int)( void *fp,LPSTR key,int n );
	BOOL		(*ini_load_str)( void *fp,LPSTR key,LPSTR str,LPSTR def );
	BOOL		(*ini_save_str)( void *fp,LPSTR key,LPSTR str );
	int			reserve[10];
} EXFUNC;

typedef struct
{
	int		flag;				//	FILTER_FLAG_ALWAYS_ACTIVE		
								//	FILTER_FLAG_CONFIG_POPUP		
								//	FILTER_FLAG_CONFIG_CHECK		
								//	FILTER_FLAG_CONFIG_RADIO		
								//	FILTER_FLAG_EX_DATA				
								//	FILTER_FLAG_PRIORITY_HIGHEST	
								//	FILTER_FLAG_PRIORITY_LOWEST		
								//	FILTER_FLAG_WINDOW_THICKFRAME	
								//	FILTER_FLAG_WINDOW_SIZE			
								//	FILTER_FLAG_DISP_FILTER			
								//	FILTER_FLAG_REDRAW				
								//	FILTER_FLAG_EX_INFORMATION		
								//	FILTER_FLAG_INFORMATION			: FILTER_FLAG_EX_INFORMATION
								//	FILTER_FLAG_NO_CONFIG			
								//	FILTER_FLAG_AUDIO_FILTER		
								//	FILTER_FLAG_RADIO_BUTTON		
								//	FILTER_FLAG_WINDOW_HSCROLL		
								//	FILTER_FLAG_WINDOW_VSCROLL		
								//	FILTER_FLAG_IMPORT				
								//	FILTER_FLAG_EXPORT				
	int		x,y;				//	(FILTER_FLAG_WINDOW_SIZE)
	TCHAR	*name;				
	int		track_n;			
	TCHAR	**track_name;		
	int		*track_default;		
	int		*track_s,*track_e;	
	int		check_n;			
	TCHAR	**check_name;		
	int		*check_default;		
	BOOL	(*func_proc)( void *fp,FILTER_PROC_INFO *fpip );
	BOOL	(*func_init)( void *fp );
	BOOL	(*func_exit)( void *fp );
	BOOL	(*func_update)( void *fp );
	BOOL 	(*func_WndProc)( HWND hwnd,UINT message,WPARAM wparam,LPARAM lparam,void *editp,void *fp );
								//	WM_FILTER_UPDATE		
								//	WM_FILTER_FILE_OPEN		
								//	WM_FILTER_FILE_CLOSE	
								//	WM_FILTER_INIT			
								//	WM_FILTER_EXIT			
								//	WM_FILTER_SAVE_START	
								//	WM_FILTER_SAVE_END		
								//	WM_FILTER_IMPORT		
								//	WM_FILTER_EXPORT		
	int		*track,*check;		
	void	*ex_data_ptr;		//	(FILTER_FLAG_EX_DATA)
	int		ex_data_size;		//	(FILTER_FLAG_EX_DATA)
	TCHAR	*information;		//	(FILTER_FLAG_EX_INFORMATION)
	BOOL	(*func_save_start)( void *fp,int s,int e,void *editp );
	BOOL	(*func_save_end)( void *fp,void *editp );
	EXFUNC	*exfunc;			
	HWND	hwnd;				
	HINSTANCE	dll_hinst;		
	int		reserve[8];			
} FILTER;

#define	FILTER_FLAG_ALWAYS_ACTIVE		4
#define	FILTER_FLAG_CONFIG_POPUP		8
#define	FILTER_FLAG_CONFIG_CHECK		16
#define	FILTER_FLAG_CONFIG_RADIO		32
#define	FILTER_FLAG_EX_DATA				1024
#define	FILTER_FLAG_PRIORITY_HIGHEST	2048
#define	FILTER_FLAG_PRIORITY_LOWEST		4096
#define	FILTER_FLAG_WINDOW_THICKFRAME	8192
#define	FILTER_FLAG_WINDOW_SIZE			16384
#define	FILTER_FLAG_DISP_FILTER			32768
#define	FILTER_FLAG_REDRAW				0x20000
#define	FILTER_FLAG_EX_INFORMATION		0x40000
#define	FILTER_FLAG_INFORMATION			0x80000
#define	FILTER_FLAG_NO_CONFIG			0x100000
#define	FILTER_FLAG_AUDIO_FILTER		0x200000
#define	FILTER_FLAG_RADIO_BUTTON		0x400000
#define	FILTER_FLAG_WINDOW_HSCROLL		0x800000
#define	FILTER_FLAG_WINDOW_VSCROLL		0x1000000
#define	FILTER_FLAG_IMPORT				0x10000000
#define	FILTER_FLAG_EXPORT				0x20000000
#define WM_FILTER_UPDATE				(WM_USER+100)
#define WM_FILTER_FILE_OPEN				(WM_USER+101)
#define WM_FILTER_FILE_CLOSE			(WM_USER+102)
#define WM_FILTER_INIT					(WM_USER+103)
#define WM_FILTER_EXIT					(WM_USER+104)
#define WM_FILTER_SAVE_START			(WM_USER+105)
#define WM_FILTER_SAVE_END				(WM_USER+106)
#define WM_FILTER_IMPORT				(WM_USER+107)
#define WM_FILTER_EXPORT				(WM_USER+108)

typedef struct {
	int		flag;
	int		x,y;
	TCHAR	*name;
	int		track_n;
	TCHAR	**track_name;
	int		*track_default;
	int		*track_s,*track_e;
	int		check_n;
	TCHAR	**check_name;
	int		*check_default;
	BOOL	(*func_proc)( FILTER *fp,FILTER_PROC_INFO *fpip );
	BOOL	(*func_init)( FILTER *fp );
	BOOL	(*func_exit)( FILTER *fp );
	BOOL	(*func_update)( FILTER *fp );
	BOOL 	(*func_WndProc)( HWND hwnd,UINT message,WPARAM wparam,LPARAM lparam,void *editp,FILTER *fp );
	int		*track,*check;
	void	*ex_data_ptr;
	int		ex_data_size;
	TCHAR	*information;
	BOOL	(*func_save_start)( void *fp,int s,int e,void *editp );
	BOOL	(*func_save_end)( void *fp,void *editp );
	EXFUNC	*exfunc;
	HWND	hwnd;
	HINSTANCE	dll_hinst;
	int		reserve[8];
} FILTER_DLL;

#define	MID_FILTER_BUTTON			12004

BOOL func_proc( FILTER *fp,FILTER_PROC_INFO *fpip );
BOOL func_init( FILTER *fp );
BOOL func_exit( FILTER *fp );
BOOL func_update( FILTER *fp );
BOOL func_WndProc( HWND hwnd,UINT message,WPARAM wparam,LPARAM lparam,void *editp,FILTER *fp );
BOOL func_save_start( FILTER *fp,int s,int e,void *editp );
BOOL func_save_end( FILTER *fp,void *editp );
/*
#pragma pack(pop)
*/
#endif