/*
NRS - "Noise reduction suite" filter for Avisynth
Copyright (C) 2003 Antonio Foranna

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation.
	
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
		
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
			
The author can be contacted at:
kreel@tiscali.it
*/

#include "Cavisynth.h"
#include "CGamma.h"
#include "Cregistry.h"
#include "Define.h"
#include "Crop.h"
#include "Gamma.h"
#include "DNR.h"
#include "SmartBlur.h"
#include "Run.h"

extern bool g_MMXenabled;

extern void LoadReg(MyFilterData *mfd);
extern int nrsInitProc(FilterActivation *fa, const FilterFunctions *ff);



BYTE Cnrs::CnrsInit(PClip _child, IScriptEnvironment* env)
{
	if(!vi.IsRGB32())
	{
		env->ThrowError("Only RGB32 supported!");
		return 1;
	}
	g_MMXenabled=!!(env->GetCPUFlags()&CPUF_MMX);

PVideoFrame sf = child->GetFrame(0, env);
PVideoFrame df = env->NewVideoFrame(vi);
Pixel32	*src, *dst;

	src=(Pixel32 *)sf->GetReadPtr();
	dst=(Pixel32 *)df->GetWritePtr();

	mfd=&smfd;
	memset(mfd,0,sizeof(*mfd));

	mfd->wnc=(WORD)sf->GetPitch()>>2;
	mfd->w=(WORD)vi.width;
	mfd->h=(WORD)vi.height;

    mfd->sizeSrc = sf->GetRowSize()*sf->GetHeight();
    mfd->sizeDst = df->GetRowSize()*df->GetHeight();
	if(!mfd->sizeSrc || !mfd->sizeDst)
		return 1;

	mfd->NewImage=1;

	if(!(mfd->pGamma=new CGamma()))
		return 1;

	LoadReg(mfd);

	InitCrop(mfd,dst);
	mfd->xGap=(short)mfd->wnc-mfd->dst_width;
	InitGamma(mfd);
	if(InitDNR(mfd,src))
		return 1;
	if(InitSB(mfd))
		return 1;

	InitFuncs(mfd);

	return 0;
}

Cnrs::~Cnrs()
{
	DEL(mfd->pGamma);
	DELETE_ARRAY(mfd->pLogThresholdDNR);
	DELETE_ARRAY(mfd->pLogThresholdSB);
	DELETE_ARRAY(mfd->sav_data);
	DELETE_ARRAY(mfd->old_data);
	DELETE_ARRAY(mfd->DiffAcc);
	DELETE_ARRAY(mfd->Yold);
	DELETE_ARRAY(mfd->pWeight);
	DELETE_ARRAY(mfd->pScaleWeight);
	DELETE_ARRAY(mfd->LUTminx);
	DELETE_ARRAY(mfd->LUTmaxx);
	DELETE_ARRAY(mfd->LUTminy);
	DELETE_ARRAY(mfd->LUTmaxy);
}

PVideoFrame __stdcall Cnrs::GetFrame(int n, IScriptEnvironment* env) 
{
PVideoFrame sf = child->GetFrame(n, env);
PVideoFrame df = env->NewVideoFrame(vi);
Pixel32	*src, *dst;

	src=(Pixel32 *)sf->GetReadPtr();
	dst=(Pixel32 *)df->GetWritePtr();

	mfd->pRunProc(dst,src,mfd);

	return df;
}
	
AVSValue __cdecl Create_Cnrs(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	return new Cnrs(args[0].AsClip(),env);
}

extern "C" __declspec(dllexport) const char* __stdcall AvisynthPluginInit2(IScriptEnvironment* env)
{
  env->AddFunction("NRS","c",Create_Cnrs,0);
  return 0;
}
