/*
NRS - "Noise reduction suite" filter for VirtualDub
Copyright (C) 2003 Antonio Foranna

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation.
	
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
		
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
			
The author can be contacted at:
kreel@tiscali.it
*/

#include "Struct.h"

//************************************************************************************************

void InitCrop(MyFilterData *mfd, DWORD *dst)
{
long	src_shiftNC;
short	ImageWidthSrc=mfd->wnc,
		ImageWidthDst=mfd->w,
		ImageHeigth=(short)mfd->h;
DWORD	Color=mfd->R<<16|mfd->G<<8|mfd->B;
short	dst_left,
		dst_top;

	if(mfd->Use_crop)	
	{
		if(dst)
			if(!Color) // Black
				memset(dst,0,mfd->sizeDst);
			else
			{
			DWORD	nop=mfd->sizeDst>>2;
				while(nop--)
					*(dst++)=Color;
			}

		src_shiftNC=ImageWidthSrc*mfd->top+mfd->left;
		mfd->dst_width=ImageWidthDst-mfd->left-mfd->right;
		mfd->dst_heigth=ImageHeigth-mfd->top-mfd->bottom;

		dst_top=((mfd->top+mfd->bottom)>>1)+mfd->yShift; // -mfd->yShift because Rows are stored in bottom up order
		if(dst_top<=-ImageHeigth)
			dst_top=-ImageHeigth+1;
		if(dst_top>=ImageHeigth)
			dst_top=ImageHeigth-1;
		if(dst_top<0)
		{
			src_shiftNC-=ImageWidthSrc*dst_top;
			mfd->dst_heigth+=dst_top;
			dst_top=0;
		}

		if(mfd->dst_heigth<0)
			mfd->dst_heigth=0;
		if(mfd->dst_heigth+dst_top>ImageHeigth)
			mfd->dst_heigth=ImageHeigth-dst_top;

		dst_left=((mfd->left+mfd->right)>>1)+mfd->xShift;
		if(dst_left<=-ImageWidthDst)
			dst_left=ImageWidthDst+1;
		if(dst_left>=ImageWidthDst)
			dst_left=ImageWidthDst-1;
		if(dst_left<0)
		{
			src_shiftNC-=dst_left;
			mfd->dst_width+=dst_left;
			dst_left=0;
		}

		if(src_shiftNC>(long)mfd->sizeSrc)
			src_shiftNC=mfd->sizeSrc;
		if(src_shiftNC<0)
			src_shiftNC=0;

		mfd->dst_shift=ImageWidthSrc*dst_top+dst_left;
		if(src_shiftNC+mfd->dst_shift>(long)mfd->sizeDst)
			mfd->dst_shift=0;

		if(mfd->dst_width<0)
			mfd->dst_width=0;
		if(mfd->dst_width+dst_left>ImageWidthDst)
			mfd->dst_width=ImageWidthDst-dst_left;
		if(!mfd->dst_width)
			mfd->dst_heigth=0;
		mfd->dst_sizeSY=mfd->dst_heigth*(ImageWidthDst<<2);
	}
	else
	{
		src_shiftNC=0;
		mfd->dst_shift=0;
		mfd->dst_width=ImageWidthDst;
		mfd->dst_heigth=ImageHeigth;
	}
	mfd->xGap=ImageWidthSrc-mfd->dst_width;
	mfd->src_shift=src_shiftNC;
}
//************************************************************************************************
