//---------------------------------------------------------------------------
#ifndef DefineH
#define DefineH
//---------------------------------------------------------------------------

// search MAX_FUNCTION_PARAMS to know max # of parameters supported by source version of virtualdub (it should be 16)

extern bool g_MMXenabled;

// Misc
#define APP_VER 			"v1.2"
#define APP_NAME			"NRS"
#define REGISTRY_APP_NAME	"SOFTWARE\\4N\\" APP_NAME

#define THRESHOLDTABLELEN		8
#define SQUARE_MAX				255
#define FREQTHRESHOLD			4
#define	REG_DISABLEMMX			"Disable MMX"
#define DEF_DISABLEMMX			0
#define INIT_ALL				0
#define REG_INTERLACED			"Interlaced"
#define DEF_INTERLACED			0

// DNR
#define REG_USE_DNR				"Use DNR"
#define REG_MINT_DNR			"Min threshold DNR"
#define REG_MAXT_DNR			"Max threshold DNR"
#define REG_SCD					"SCD threshold"
#define MAXTHRESHOLD_DNR		32
#define DEF_MINTHRESHOLD_DNR	8
#define DEF_MAXTHRESHOLD_DNR	12
#define MAXTHRESHOLD_SCD		100
#define MAXTHRESHOLD_EDGES		32
#define DEF_SCD					100
#define DEF_USE_DNR				1
#define INIT_DNR				1
#define	REG_USE_DNRMP			"Use DNR Multi-pass"
#define	DEF_USE_DNRMP			0
#define	REG_EDGES_DNR			"Edges threshold"
#define	DEF_EDGES_DNR			6
#define	REG_SHOWBLENDED_DNR		"Show blended pixels"
#define	DEF_SHOWBLENDED_DNR		0

// SB

#define REG_USE_SB				"Use SB"
#define REG_MINT_SB				"Min threshold SB"
#define REG_MAXT_SB				"Max threshold SB"
#define REG_RADIUS_SB			"Radius SB"
#define REG_SHARPENEDGES		"Sharpen edges SB"
#define REG_SHARPENSTRENGTH		"Sharpen strength SB"
#define MAXRADIUS_SB			7
#define MAXTHRESHOLD_SB			255
#define DEF_RADIUS_SB			1
#define DEF_MINTHRESHOLD_SB		2
#define DEF_MAXTHRESHOLD_SB		12
#define DEF_USE_SB				0
#define INIT_SB					2
#define MAXSHARPEN_SB			6
#define DEF_SHARPENEDGES		0
#define DEF_SHARPENSTRENGTH		0

// Crop
#define REG_USE_CROP		"Use crop"
#define REG_LEFT			"Left"
#define REG_RIGHT			"Right"
#define REG_TOP				"Top"
#define REG_BOTTOM			"Bottom"
#define REG_XSHIFT			"X shift"
#define REG_YSHIFT			"Y shift"
#define DEF_CROP			0
#define DEF_SHIFT			0
#define DEF_USE_CROP		1

#define REG_R				"Channel R"
#define REG_G				"Channel G"
#define REG_B				"Channel B"
#define MAXCOLORS			255
#define DEF_COLORS			0
#define INIT_CROP			3

// Gamma
#define REG_USE_GAMMA		"Use gamma"
#define REG_GAMMA			"Gamma value"
#define REG_DARK_LIMIT		"Dark limit"
#define REG_BRIGHT_LIMIT	"Bright limit"
#define DEF_USE_GAMMA		0
#define DEF_GAMMA			10
#define DEF_DARK_LIMIT		0
#define DEF_BRIGHT_LIMIT	255
#define MAX_GAMMA			30
#define MAX_DARK			254
#define MAX_BRIGHT			255
#define INIT_GAMMA			4

//************************************************************************************************

#define DEL(buf) \
{ \
	if(buf) \
	{ \
	    delete buf; \
		buf = NULL; \
	} \
}
//------------------------------------------------------------------------------------------------

extern void DeleteArray(void **buf);
extern CreateArray(void **buf, int size);

#define DELETE_ARRAY(buf) DeleteArray((void **)&(buf));
#define CREATE_ARRAY(buf,type,size) if(CreateArray((void **)&(buf),sizeof(type)*(size))) return 1;

//------------------------------------------------------------------------------------------------

#define Min(a,b) ((a)<(b) ? (a) : (b))
#define Max(a,b) ((a)>(b) ? (a) : (b))
#define CLIP(a) ((a)<0 ? 0 : (a)>255 ? 255 : (a))

//------------------------------------------------------------------------------------------------

#endif