/*
NRS - "Noise reduction suite" filter for VirtualDub
Copyright (C) 2003 Antonio Foranna

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation.
	
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
		
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
			
The author can be contacted at:
kreel@tiscali.it
*/

#include "Struct.h"

//************************************************************************************************

void InitGamma(MyFilterData *mfd)
{
BYTE	*gamma=mfd->pGamma->GammaCorrection;

	if(mfd->Use_gamma)
		mfd->pGamma->InitGamma(mfd->GammaVal,mfd->darkLimit,mfd->brightLimit);
	else
		for(short i=0; i<256; i++)
			gamma[i]=(BYTE)i;
}

//************************************************************************************************

void GammaLine(DWORD *src, DWORD *dst, const BYTE *pGamma, DWORD Width)
{
	do
	{
		*(BYTE *)dst    =*(pGamma+*(BYTE *)src);
		*((BYTE *)dst+1)=*(pGamma+*((BYTE *)src+1));
		*((BYTE *)dst+2)=*(pGamma+*((BYTE *)src+2));

		src++;
		dst++;
	}while(--Width);
}
//************************************************************************************************
/*
inline void GammaAsm(DWORD *src, DWORD *dst, const BYTE *pGamma)
{
	__asm
	{
		push		edi
		push		esi
		push		ebx

// Gamma correction ------------------------------------------------------------------------------

		mov			ecx, src
		mov			ebx, [ecx]
		mov			esi, pGamma
		mov			edi, dst
		xor			eax, eax

		mov			ecx, ebx
		shr			ecx, 16
		xor			ch, ch
		mov			ah, [esi+ecx]
		shl			eax, 8

		mov			cl, bh
		mov			ah, [esi+ecx]

		mov			cl, bl
		mov			al, [esi+ecx]

		mov			[edi], eax

		pop			ebx
		pop			esi
		pop			edi
	}
}*/
//************************************************************************************************

void GammaLineAsm(DWORD *src, DWORD *dst, const BYTE *pGamma, DWORD Width)
{
/*	do
	{
		*(BYTE *)dst    =*(pGamma+*(BYTE *)src);
		*((BYTE *)dst+1)=*(pGamma+*((BYTE *)src+1));
		*((BYTE *)dst+2)=*(pGamma+*((BYTE *)src+2));

		src++;
		dst++;
	}while(--Width);
*/

static DWORD ebp_sav;

	__asm
	{
		push		edi
		push		esi

		xor			ebx, ebx
		mov			ecx, Width
		mov			edx, pGamma
		mov			esi, src
		mov			edi, dst

		mov			ebp_sav, ebp
		mov			ebp, edx

	x_loop:

// Gamma correction ------------------------------------------------------------------------------

		mov			edx, [esi]
		xor			eax, eax

		mov			bl, dh
		mov			ah, [ebp+ebx]

		mov			bl, dl
		mov			al, [ebp+ebx]

		shr			edx, 16
		xor			dh, dh
		mov			dl, [ebp+edx]
		shl			edx, 16
		or			eax, edx

		mov			[edi], eax

		add			esi, 4
		add			edi, 4
		sub			ecx, 1
		jnz			x_loop

		mov			ebp, ebp_sav

		pop			esi
		pop			edi
	}
}

