//---------------------------------------------------------------------------
#ifndef StructH
#define StructH
//---------------------------------------------------------------------------

#include <windows.h>
#include "filter.h"
#include "CGamma.h"

//#define WEIGHTMAX 65535					// Do not change - Plain code relies on these settings
//#define WEIGHTBITS 16					// As above

typedef struct MyFilterData
{
// Crop
WORD	left,
		right,
		top,
		bottom;
short	xShift,
		yShift;
BYTE	R,G,B;					// BackGround color
BYTE	Use_crop;				// Enable Crop

long	src_shift,				// number of pixels skipped from start of source frame
		dst_shift,				// number of pixels skipped from start of destination frame
		dst_width,				// width of cropped frame in pixels
		dst_heigth,				// heigth of cropped frame in pixels
		xGap,					// gap from end of source (cropped) line to start of next (cropped) line
		dst_sizeSY;				// precomputed to speedup RunShiftY

// DNR
BYTE	MinThresholdDNR,		// Min threshold value
		MaxThresholdDNR,		// Max threshold value
		SCD_threshold;			// 0 = DNR Disabled, 100 = DNR always enabled
DWORD	SCD_NumOfPixels;		// SCD_threshold in pixels
BYTE	*sav_data;				// Current frame modified with SB and/or gamma. It's needed when using SCD
BYTE	*old_data;				// previous frame
BYTE	*Yold;					// luminosity of previous frame
BYTE	*EdgesMask;				// Mask of edges in previous frame
DWORD	*DiffAcc;				// Sum of  squares of differences accumulator
DWORD	DiffAccSize;			// Size of DiffAcc in bytes
DWORD	*pLogThresholdDNR;		// Logaritmic table of Thresholds
BYTE	NewImage;				// if 1 than all the buffers are reallocated
BYTE	ResetOldData;			// if 1 than updates *old_data && *Yold
BYTE	show_blended;			// Show pixels blended by DNR
BYTE	show_DNR_edges;			// Show edges computed by DNR Multipass
BYTE	Use_DNR;				// Enable Dynamic Noise Reduction
BYTE	UseDnrMultiPass;		// Use multiple passes (better looking and slower)
BYTE	DnrMultiPassWeight,		// Weight to avoid divisions
		DnrMultiPassRest;		// 256-(sum of weights)
WORD	*pLogThresholdEdgesDNR;	// Table of Thresholds to find edges in old frame
BYTE	EdgesThreshold;			// Threshold to find edges in old frame

// Smart blur
BYTE	MinThresholdSB,			// Min threshold value
		MaxThresholdSB,			// Max threshold value
		radius;
DWORD	*pLogThresholdSB;		// Logaritmic table of Thresholds
BYTE	*LUTminx,				// LUTs of radii
		*LUTmaxx,
		*LUTminy,
		*LUTmaxy;
BYTE	*pScaleWeight;			// LUT of weights to scale current weight so it's divisible by 256
BYTE	*pWeight;				// LUT of weights for Gaussian blur
BYTE	*pCenterOfWeight;		// Center of the mask of weights
float	_255DivMaskArea;		// Precomputed to speedup visualization of edges
BYTE	WeightMax;				// Precomputed to speedup visualization of edges
WORD	SumOfWeights;			// Needed to show edges using blur
BYTE	show_edges;				// B/W visualization of edges
BYTE	Use_SB;					// Enable Smart Blur
BYTE	SharpenEdges;
char	SharpenStrength;
WORD	SharpenStrength2;

// Gamma correction
CGamma	*pGamma;				// Gamma LUT
char	GammaVal;				// Range 10/30 = gamma from 1.0 to 3.0. Range -30/-11 = inverse gamma
BYTE	darkLimit,brightLimit;	// Contrast effect
BYTE	Use_gamma;				// Enable Gamma Correction

// Misc
FilterFunctions *ff;
BYTE	DisableMMX;				// Disable MMX when available
DWORD	sizeSrc, sizeDst;		// size in bytes of frames
WORD	h, w, wnc;				// heigth, width and width of not cropped image
BYTE	PreviewMode;			// 1 if Preview mode is active, 0 otherwise
BYTE	Interlaced;				// Source is interlaced

// function pointers
int (*pRunProc)(DWORD *dst, DWORD *src, MyFilterData *mfd);
void (*pGammaLine)(DWORD *src, DWORD *dst, const BYTE *pGamma, DWORD Width);
void (*pBlurShowEdgesLine)(	DWORD *src, DWORD *dst, DWORD *bCenterOfWeight, const DWORD *pLogThresholdSB,
							BYTE diameter, BYTE diametery, DWORD minydiameter, DWORD minyImageWidthx4,
							DWORD xGapNear, DWORD dst_width, MyFilterData *mfd, BYTE *pMiny, BYTE *pMaxy);
void (*pBlurLine)(	DWORD *src, DWORD *dst, DWORD *bCenterOfWeight, const DWORD *pLogThresholdSB,
					BYTE diameter, BYTE diametery, DWORD minydiameter, DWORD minyImageWidthx4,
					DWORD xGapNear, DWORD in_width, MyFilterData *mfd, DWORD yOffset, BYTE *pMiny, BYTE *pMaxy);
DWORD (*pDNRline)(DWORD *src, DWORD *dst, DWORD *old, DWORD *DiffAcc, const DWORD *pLogThresholdDNR, DWORD Width, const MyFilterData *mfd, DWORD yOffset, BYTE *Yold);
} MyFilterData;

//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------
