/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : binsort.c
// Description:  binary search, insert sort
// Create Date:  1997. 3. 10
// ****************************************************************


#include <stdlib.h>

// do binary search
// n is the size of x
// x is sorted in ascending order
// p is the value to be find
// return the position i where x[i] <= p <= x[i+1]

#define macro_binsearch(funcname, stype)       \
int funcname(int n, stype *x, stype p)         \
{                                              \
  int i, m;                                    \
  m = 1;                                       \
  do {                                         \
    i = (m+n)/2;                               \
    if(x[i-1] > p)  {                          \
      n = i-1;                                 \
    }                                          \
    else if(x[i-1] < p) {                      \
      m = i+1;                                 \
    }                                          \
    else return i-1;                           \
  }while(m <= n);                              \
  return n;                                    \
}                                              \




// int r_binsearch(int n, double *x, double p)
macro_binsearch(r_binsearch, double)

// int f_binsearch(int n, float *x, float p)
macro_binsearch(f_binsearch, float)

// int i_binsearch(int n, int *x, int p)
macro_binsearch(i_binsearch, int)

// int b_binsearch(int n, unsigned char *x, unsigned char p)
macro_binsearch(b_binsearch, unsigned char)





// sort the array x (size n) in ascending order
#define macro_sort(funcname, stype, binsearch)       \
void funcname(int n, stype *x)                       \
{                                                    \
 int i,j,k;                                          \
 stype t;                                          \
                                                     \
 if(n <= 1) return;                                  \
 for(i=1; i<n; i++) {                                \
   k = binsearch(i, x, x[i]);                      \
   t = x[i];                                         \
   for(j=i; j>k; j--) x[j] = x[j-1];                 \
   x[k] = t;                                         \
 }                                                   \
}                                                    \



// void r_bsort(int n, double *x)
macro_sort(r_bsort, double, r_binsearch)

// void f_bsort(int n, float *x)
macro_sort(f_bsort, float, f_binsearch)

// void i_bsort(int n, int *x)
macro_sort(i_bsort, int, i_binsearch)

// void b_bsort(int n, unsigned char *x)
macro_sort(b_bsort, unsigned char, b_binsearch)





