/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : fastconv.c
// Description:  routines do some special convolution
// Create Date:  1996. 11. 24
// Modification(date/where):   
//
// ****************************************************************

#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <math.h>
#define _IMG_LIBBUILD_
#include "image.h"
#include "routines.h"


// do a 3x3 blur fast
//   "img" is the IBYTE matrix of image, size is "xsize" * "ysize"
//   "buf" is a user provided short int working buffer, size is "xsize" * 3
//   "xsize" and "ysize" is the size of image
//   blur matrix is all 1
void blur_3x3_fast(IBYTE  *img, short int *buf, int xsize, int ysize)
{
  int i,j;
  short int *bf1, *bf2, *bf3, *bft;
  int offset, offset1, xsz1, ysz1;

    bf1 = buf; bf2 = buf+xsize; bf3 = buf+xsize*2;
    xsz1=xsize-1; ysz1 = ysize-1;
    offset = 1;
    for(i=1; i<xsz1; i++, offset++) 
        bf1[i] = (short int)img[offset] + (short int)img[offset-1] + (short int)img[offset+1];
    bf1[0]=bf1[1]; bf1[xsize-1] = bf1[xsize-2]; 
        
    offset = xsize+1;
    for(i=1; i<xsz1; i++, offset++) 
        bf2[i] = (short int)img[offset] + (short int)img[offset-1] + (short int)img[offset+1];
    bf2[0]=bf2[1]; bf2[xsize-1] = bf2[xsize-2]; 

    offset = xsize*2+1;
    for(i=1; i<xsz1; i++, offset++) 
        bf3[i] = (short int)img[offset] + (short int)img[offset-1] + (short int)img[offset+1];
    bf3[0]=bf3[1]; bf3[xsize-1] = bf3[xsize-2]; 

    offset1 = xsize;
    for(j=1; j<ysz1; j++) {
      for(i=0; i<xsize; i++, offset1++) 
        img[offset1] = (IBYTE)((bf1[i]+bf2[i]+bf3[i])/9);
      bft=bf1; bf1=bf2; bf2=bf3; bf3=bft;
      offset = offset1+xsize+1;
      for(i=1; i<xsz1; i++, offset++) 
        bf3[i] = (short int)img[offset] + (short int)img[offset-1] + (short int)img[offset+1];
      bf3[0]=bf3[1]; bf3[xsize-1] = bf3[xsize-2]; 
    }
    memcpy(img, img+xsize, xsize);
    memcpy(img+xsize*(ysize-1), img+xsize*(ysize-2), xsize);
    return;
}


// do a 3x3 blur
//   "img" is the IBYTE matrix of image, size is "xsize" * "ysize"
//   "xsize" and "ysize" is the size of image
//   blur matrix is all 1
void blur_3x3(IBYTE  *img, int xsize, int ysize)
{
  register IWORD acc;
  register int k;
  register int i,j;
  int addr[9];
  int offset, offset1;

    store_addr3x3(addr, xsize);
    offset = xsize; offset1 = 0;
    for(j=1; j<ysize-1; j++) {
      for(i=1; i<xsize-1; i++) {
	 for(k=0, acc=0; k<9; k++) acc += (IWORD)img[offset+i+addr[k]];
	 img[offset1+i-1] = (IBYTE)(acc/9);
       }
      offset += xsize; offset1 += xsize;
     }
    offset = xsize*(ysize-3);
    for(j=ysize-2; j>0; j--) {
      memcpy(img+offset+xsize+1, img+offset, xsize-2);
      offset -= xsize;
    }
    return;
}

void sobel_edge(IBYTE  *img, short int *buf, int xsize, int ysize)
{
  int i,j;
  int offset;
  short int d1, d2;
  int addr[9];

    store_addr3x3(addr, xsize);
    for(j=1; j<ysize-1; j++) {
      offset = j*xsize;
      for(i=1; i<xsize-1; i++) {
         d1 = -(short int)img[offset+i+addr[0]] - ((short int)img[offset+i+addr[1]]<<1) - (short int)img[offset+i+addr[2]]
              +(short int)img[offset+i+addr[6]] + ((short int)img[offset+i+addr[5]]<<1) + (short int)img[offset+i+addr[4]];
         d2 = -(short int)img[offset+i+addr[0]] - ((short int)img[offset+i+addr[7]]<<1) - (short int)img[offset+i+addr[6]]
              +(short int)img[offset+i+addr[2]] + ((short int)img[offset+i+addr[3]]<<1) + (short int)img[offset+i+addr[4]];
         if(abs(d1) > abs(d2)) buf[offset+i] = d1;
         else buf[offset+i] = d2;
      }
    }
    blank_frame(buf, xsize, ysize, sizeof(short int));
}

/*
void sobel_edge(IBYTE  *img, short int *des, int xsize, int ysize)
{
  int i,j, xsz1, ysz1;
  int offset, offset1;
  short int d2;
  short int *buf;
  
    xsz1 = xsize-1; ysz1 = ysize-1;
    // firstly do the horizontal differential
    buf=des;  // the first line is not used
    for(j=1; j<ysz1; j++) {
      offset = j*xsize;
      buf[0] = ((short int)img[offset]<<1) + 
          (short int)img[offset-xsize] + (short int)img[offset+xsize];
      buf[1] = ((short int)img[offset+1]<<1) + 
          (short int)img[offset-xsize+1] + (short int)img[offset+xsize+1];
      offset++;
      for(i=1; i<xsz1; i++, offset++) {
         buf[i+1] = ((short int)img[offset+1]<<1) + 
             (short int)img[offset-xsize+1] + (short int)img[offset+xsize+1];
         des[offset] = buf[i+1] - buf[i-1];
      }
    }

    // then do the vertical differential
    buf=des;  // the first column is not used
    for(i=1; i<xsz1; i++) {
      offset = i; offset1 = xsize;
      buf[0] = ((short int)img[offset]<<1) + 
         (short int)img[offset-1] + (short int)img[offset+1];
      buf[offset1] = ((short int)img[offset+xsize]<<1) + 
         (short int)img[offset+xsize-1] + (short int)img[offset+xsize+1];
      for(j=1; j<ysz1; j++, offset+=xsize, offset1+=xsize) {
         buf[offset1+xsize] = ((short int)img[offset+xsize]<<1) + 
             (short int)img[offset+xsize-1] + (short int)img[offset+xsize+1];
         d2 = buf[offset1+xsize] - buf[offset1-xsize];
         if(abs(d2) > abs(des[offset])) des[offset] = d2;
      }
    }
    blank_frame(des, xsize, ysize, sizeof(short int));
    return;
}
*/


void sobel_edge_unsigned(IBYTE *img, int xsize, int ysize)
{
  int i,j, xsz1, ysz1;
  int offset;
  short int d1, d2;
  int addr[9];

    xsz1 = xsize-1; ysz1 = ysize-1;
    store_addr3x3(addr, xsize);
    for(j=1; j<ysz1; j++) {
      offset = j*xsize+1;
      for(i=1; i<xsz1; i++, offset++) {
         d1 = (short int)img[offset+addr[6]] + ((short int)img[offset+addr[5]]<<1) + (short int)img[offset+addr[4]]
             -(short int)img[offset+addr[0]] - ((short int)img[offset+addr[1]]<<1) - (short int)img[offset+addr[2]];
         d2 = (short int)img[offset+addr[2]] + ((short int)img[offset+addr[3]]<<1) + (short int)img[offset+addr[4]]
             -(short int)img[offset+addr[0]] - ((short int)img[offset+addr[7]]<<1) - (short int)img[offset+addr[6]];
         if(d1 < 0) d1 = -d1;
         if(d2 < 0) d2 = -d2;
         if(d1 < d2) if(d2 >= 255) img[offset+addr[0]] = 255; else img[offset+addr[0]] = (IBYTE)d2;
         else if(d1 >= 255) img[offset+addr[0]] = 255; else img[offset+addr[0]] = (IBYTE)d1;
      }
    }
    offset = xsize*(ysize-2);
    for(j=ysize-2; j>0; j--) {
      memcpy(img+offset+xsize+1, img+offset, xsize-2);
      offset -= xsize;
    }
    return;
}


void find_edge_fast(IBYTE *img, short int *des, int xsize, int ysize)
{
  int i,j, xsz1, ysz1;
  int offset;
  short int d1, d2;

    xsz1 = xsize-1; ysz1 = ysize-1;
    for(j=1; j<ysz1; j++) {
      offset = j*xsize+1;
      for(i=1; i<xsz1; i++, offset++) {
         d1 = (short int)img[offset+1] - (short int)img[offset-1];
         d2 = (short int)img[offset+xsize] - (short int)img[offset-xsize];
         if(d1 < 0) d1 = -d1;
         if(d2 < 0) d2 = -d2;
         if(d1 < d2) des[offset] = d2;
         else  des[offset] = d1;
      }
    }
    blank_frame(des, xsize, ysize, sizeof(short int));
    return;
}

  
 
