/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
/******************************************************************/
/*  Image process tool box*/
/*     by Yang Yudong*/
/**/
/* File : filepsd.c*/
/* Description:  Photoshop PSD image file I/O*/
/* Create Date:  2000. 3. 4 (YYYY/MM/DD) by Adam Hoult*/
/* Modification(date/where):  2000. 4. 8  by YYD,  Modified ping and memleak of LoadPSD32b, rewrite DecodePSD*/
/**/
/******************************************************************/

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#define _IMG_LIBBUILD_
#include "image.h"
#include "imgfile.h"


typedef struct PSDInfo
{
  IBYTE *Pixels;
  IDWORD	BitsPerChannel;
  IBYTE ColorData[768]; //For Indexed or DuoTone only
  IDWORD	Mode;
  IDWORD   Width;
  IDWORD   Height;
  IDWORD   ChannelCount;
  IDWORD   Compression;
}PSDInfo;



//Function Prototypes
static IBOOL DecodePSD32(FILE * fh, PSDInfo * ImageInfo , IBYTE *cr, IBYTE *cg, IBYTE *cb, IBYTE *ca);




/* load PSD 32 bits image*/
/* return ITRUE if successful*/
IBOOL LoadPSD32b(const char * fname, ImageDes *img, IBOOL ping)
{
	FILE *fh;
	PSDInfo ImageInfo;
	IDWORD IType=0;
	int ModeDataCount, ResourceDataCount, ReservedDataCount;

	// Firstopen the file and get the for us important entries from the header...
	fh = fopen(fname, "rb");
	IType = fgetLong(fh, IFALSE);
	//		fgetLong(fh, IFALSE);
	if (IType != 943870035) {fclose(fh); return IFALSE;} //Not a PSD File.
	if(fgetWord(fh,IFALSE) != 1) {fclose(fh); return IFALSE;}    //Incorrect PSD Version, MUST be 1.
	// Read 6 Bytes, irrelevant info. Must be 0
	fgetLong(fh, IFALSE);
	fgetWord(fh, IFALSE);
	ImageInfo.ChannelCount = fgetWord(fh, IFALSE);
	if( ImageInfo.ChannelCount < 0 || ImageInfo.ChannelCount > 16 ) {fclose(fh); return IFALSE;} //Incorrect Channel Count
	ImageInfo.Height = fgetLong(fh, IFALSE);
	ImageInfo.Width = fgetLong(fh, IFALSE);
	ImageInfo.BitsPerChannel = fgetWord(fh, IFALSE); //Supported values are 1,8 or 16
	if(ImageInfo.BitsPerChannel != 8 ) {fclose(fh); return IFALSE;} //NO RGB COLOURS
	// Make sure the color mode is RGB.
	//Supported Modes are Bitmap=0, Grayscale=1, Indexed=2,RGB=3,CMYK=4,MultiChannel=7
	//Duotone=8,Lab=9
	ImageInfo.Mode = fgetWord(fh, IFALSE);
	if( ImageInfo.Mode != 3 ) {fclose(fh); return IFALSE;} //ColorMode is Not RGB
	// Skip the Mode Data. (It's the palette for indexed color; other info for other modes.)
	if(ping) 
	{
		fclose(fh);
		return InitPicture(img, ImageInfo.Width, ImageInfo.Height, ITrueColor, ITRUE, 0);
	}

	ModeDataCount = fgetLong(fh, IFALSE);
	if( ModeDataCount) fseek( fh, ModeDataCount, SEEK_CUR );
	// Skip the image resources. (resolution, pen tool paths, etc)
	ResourceDataCount = fgetLong(fh, IFALSE);
	if( ResourceDataCount ) fseek( fh, ResourceDataCount, SEEK_CUR );
	// Skip the reserved data.
	ReservedDataCount = fgetLong(fh, IFALSE);
	if( ReservedDataCount ) fseek( fh, ReservedDataCount, SEEK_CUR );
	// Find out if the data is compressed.
	ImageInfo.Compression = fgetWord(fh, IFALSE);
	//Compression Type 0=Raw Data, RLE Compressed = 1
	if( ImageInfo.Compression > 1 ) {fclose(fh); return IFALSE;}  //Compression Type Not Supported

	if(!AllocPicture(img, ImageInfo.Width, ImageInfo.Height, ITrueColor, ITRUE, 0)){
		fclose(fh); return IFALSE;  /* can not allocate enough memory*/
	}

	__Img_Busy(1);

	// Decode Image...
	if(!DecodePSD32(fh,&ImageInfo, img->r, img->g, img->b, img->a))
	{
		fclose(fh);
		__Img_Busy(0);
		FreePicture(img);
		return IFALSE;
	}

	fclose(fh);
	img->load = ITRUE;
	__Img_Busy(0);
	return ITRUE;
}

// This function decodes the perhaps RLEcompressed PSD...
static IBOOL DecodePSD32(FILE * fh, PSDInfo * ImageInfo , IBYTE *cr, IBYTE *cg, IBYTE *cb, IBYTE *ca)
{
	IBYTE Default[4] = {0, 0, 0, 255};
	IDWORD chn[4]     = {2, 1, 0, 3};
	IBYTE* pChannel[4];
	IDWORD PixelCount = ImageInfo->Width * ImageInfo->Height;
	IDWORD c, channel;
	IBYTE *pc;

	pChannel[0] = cr;
	pChannel[1] = cg;
	pChannel[2] = cb;
	pChannel[3] = ca;

	if(ImageInfo->Compression) 
	{
		IDWORD count; 
		int	len, cc;
		fseek(fh, ImageInfo->Height * ImageInfo->ChannelCount * 2, SEEK_CUR);
		for(c=0;c<4;c++) 
		{
			channel=chn[c];
			pc=pChannel[c];
			if(channel>=ImageInfo->ChannelCount) 
			{
				memset(pc, Default[channel], PixelCount);
			}
			else
			{
				count=0;
				while(count<PixelCount)
				{
					len=fgetc(fh);
					if(len == EOF) return IFALSE;
					if(len==128) 
					{
					}
					else if(len<128) 
					{
						len++;
						while(len && count<PixelCount)
						{
							cc = fgetc(fh);
							if(cc == EOF) return IFALSE;
							pc[count]=(IBYTE)cc; count++; len--;
						}
					}
					else if(len>128)
					{
						len ^= 0x0FF;
						len += 2;
						cc = fgetc(fh);
						if(cc == EOF) return IFALSE;
						if(count+len > PixelCount) return IFALSE;
						memset(pc+count, len, (IBYTE)cc);
						count += (IDWORD)len;
					}
				}
			}
			__Img_Busy(c*100/4);
		}
	}
	else 
	{
		for(c=0;c<4;c++) 
		{
			channel = chn[c];
			pc=pChannel[c];
			if( channel>ImageInfo->ChannelCount ) 
			{
				memset(pc, Default[channel], PixelCount);
			}
			else
			{
				if(fread(pc, 1, PixelCount, fh) < PixelCount) return IFALSE;
			}
		}
		__Img_Busy(c*100/4);
	}
	return ITRUE;
}
