/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : iclear.c
// Description:  Clear contents of an image
// Create Date:  1996. 10. 29
// Modification(date/where): 
//
// ****************************************************************


#include <malloc.h>
#include <stdio.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"

IBOOL  image_clear(ImageDes img, IDWORD fills)
{ unsigned int m;
  IBYTE r,g,b, a;

  if(!img.alloc) return IFALSE;
  __Img_Busy(1);
  m = img.xsize*img.ysize;
  if(img.alpha)
  {
	  a = DWORD_COLOR_ALPHA(fills);
	  memset(img.a, a, m);
  }

  r = DWORD_COLOR_RED(fills);
  memset(img.r, r, m);
  __Img_Busy(img.imagetype != ITrueColor ? 95 : 33);
  if(img.imagetype != ITrueColor){
    __Img_Busy(0);
    return ITRUE;
   }
  g = DWORD_COLOR_GREEN(fills);
  memset(img.g, g, m);
  __Img_Busy(66);
  b = DWORD_COLOR_BLUE(fills);
  memset(img.b, b, m);
  __Img_Busy(99);
  __Img_Busy(0);
  return ITRUE;
}
