/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : icontrst.c
// Description:  expand contrast of an image by linearly expand histogram
// Create Date:  1996. 10. 7
// Modification(date/where): 
//
//****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"
#include "routines.h"

// Expand gray levels by  linearly remap gray lavels
//       { 0,                        old < min;
// new = { 255,                      old > max;
//       { 255*(old-min)/(max-min),  min <= old <= max.

void expandcontrast(int min, int max, IBYTE *buffer, IWORD imgWidth, IWORD imgHeight)
{
        int diff, ch=0;
        IBYTE tab[256];

        diff = max - min;     // divider
        while(ch <= min)
                tab[ch++] = 0;
        while(ch < max)           // Routine works for case max = min
                tab[ch++] = (IBYTE)((255 * (unsigned)(ch - min)) / diff);
        while(ch < 256)
                tab[ch++] = 255;
        table_mod_(tab, buffer, imgWidth, imgHeight);
}


IBOOL  image_expandcontrast(ImageDes img, int min, int max)
 {
  int diff, ch=0, i;
  IBYTE tab[256];

  if(!img.load) return IFALSE;
  if(min > max) {          // Swap values if min > max
     diff = max;
     max = min;
     min = diff;
  }
  if(min<0 || max>255)  // min, max out of boundary
       return IFALSE;
  if(min == max) return ITRUE;  // no operation
  __Img_Busy(1);
  diff = max - min;     // divider
  while(ch <= min)
      tab[ch++] = 0;
  while(ch < max)           // Routine works for case max = min
      tab[ch++] = (IBYTE)((255 * (unsigned)(ch - min)) / diff);
  while(ch < 256)
      tab[ch++] = 255;
  __Img_Busy(5);
  if(img.imagetype == IColor256 || img.imagetype == IIndexedColor) {
     for(i=0; i<256; i++) img.pal[i].r = tab[img.pal[i].r];
     __Img_Busy(33);
     for(i=0; i<256; i++) img.pal[i].g = tab[img.pal[i].g];
     __Img_Busy(66);
     for(i=0; i<256; i++) img.pal[i].b = tab[img.pal[i].b];
     __Img_Busy(99);
  }
  else {
    table_mod_(tab, img.r, img.xsize, img.ysize);
    __Img_Busy(img.imagetype == IGrey ? 95 : 33);
    if(img.imagetype == IGrey) {__Img_Busy(0); return ITRUE;}
    table_mod_(tab, img.g, img.xsize, img.ysize);
    __Img_Busy(66);
    table_mod_(tab, img.b, img.xsize, img.ysize);
  }
  __Img_Busy(0);
  return ITRUE;
 }






























