/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : ie_det2.c
// Description:  test edge detector trying trace gradient peak
// Create Date:  1996. 10. 17
// Modification(date/where): 
//
// ****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"
#include "routines.h"

void _myedgedetect2(IBYTE *img, short int *buf, int xsize, int ysize)
{
  int i,j;
  int offset1, cnt;
  short int   th;
  
    // Sobel edge detect routines
    sobel_edge(img, buf, xsize, ysize);
    for(j=0, offset1=0,cnt=0; j<ysize; j++)
      for(i=0; i<xsize; i++, offset1++) {
        buf[offset1]=(short int)abs(buf[offset1]);
        cnt+=buf[offset1];
      }
    
    th = (short int)(7*cnt/(xsize*ysize*10));
    //th = 20; //(short int)(2*cnt/(xsize*ysize)*3);
    trace_peak(img, buf, xsize, ysize, th);
    return;
}

// reinforced Sobel and tracing ones
IBOOL  image_testedge2(ImageDes img)
{
  short int *buf;

  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
  __Img_Busy(1);
  buf = (short int *)malloc(img.xsize*img.ysize*sizeof(short int));
  if(buf == NULL) { __Img_Busy(0); return IFALSE;}
  _myedgedetect2(img.r, buf, img.xsize, img.ysize);
  __Img_Busy(img.imagetype != ITrueColor ? 95 : 33);
  if(img.imagetype == IGrey){
    free(buf);
    __Img_Busy(0);
    return ITRUE;
   }
  _myedgedetect2(img.g, buf, img.xsize, img.ysize);
  __Img_Busy(66);
  _myedgedetect2(img.b, buf, img.xsize, img.ysize);
  __Img_Busy(99);
  free(buf);
  __Img_Busy(0);
  return ITRUE;
}


