/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : ie_dog.c
// Description:  DOG edge detector
// Create Date:  1996. 10. 16
// Modification(date/where): 
//
// ****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"
#include "routines.h"

  
void _DOG_edge(IBYTE *img, short int *buf, int xsize, int ysize)
{
  int i,j;
  int offset;
  short int  mtx[9];
  int addr[9];

    mtx[0] = 1;     mtx[1] = -2;    mtx[2] = 1;     
    mtx[7] = -2;    mtx[8] =  4;    mtx[3] = -2;    
    mtx[6] = 1;     mtx[5] = -2;    mtx[4] = 1;     
    convolution3x3(img, buf, mtx, xsize, ysize);
    blank_frame(buf, xsize, ysize, 2);
    store_addr3x3(addr, xsize);
    for(j=1, offset=xsize; j<ysize-1; j++) {
      offset++;
      for(i=1; i<xsize-1; i++, offset++) {
         if(buf[offset] > 0 && (   buf[offset+addr[1]]<0 || buf[offset+addr[3]]<0 
                       || buf[offset+addr[5]]<0 || buf[offset+addr[7]]<0 )) img[offset]=255;
         else if((buf[offset] == 0) &&
                 ((buf[offset+addr[1]]<0 && buf[offset+addr[5]]>0) || 
                  (buf[offset+addr[3]]<0 && buf[offset+addr[7]]>0) ||
                  (buf[offset+addr[5]]<0 && buf[offset+addr[1]]>0) ||
                  (buf[offset+addr[7]]<0 && buf[offset+addr[3]]>0) ||
                  (buf[offset+addr[0]]<0 && buf[offset+addr[4]]>0) ||
                  (buf[offset+addr[2]]<0 && buf[offset+addr[6]]>0) ||
                  (buf[offset+addr[4]]<0 && buf[offset+addr[0]]>0) ||
                  (buf[offset+addr[6]]<0 && buf[offset+addr[2]]>0)   )) img[offset]=255;
         else img[offset]=0;
      }
      offset++;
    }   
}           

// DOG zero cross
IBOOL image_DOGedge(ImageDes img)
{
  short int *buf;

  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
  __Img_Busy(1);
  buf = (short int *)malloc(img.xsize*img.ysize*sizeof(short int));
  if(buf == NULL) { __Img_Busy(0); return IFALSE;}
  _DOG_edge(img.r, buf, img.xsize, img.ysize);
  __Img_Busy(img.imagetype != ITrueColor ? 95 : 33);
  if(img.imagetype == IGrey){
    free(buf);
    __Img_Busy(0);
    return ITRUE;
   }
  _DOG_edge(img.g, buf, img.xsize, img.ysize);
  __Img_Busy(66);
  _DOG_edge(img.b, buf, img.xsize, img.ysize);
  __Img_Busy(99);
  free(buf);
  __Img_Busy(0);
  return ITRUE;
}
