/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : image.h
// Description:  image basic defination and manipulation routines header file
// Create Date:  1993. 10. 27
// Modification(date/where):   1995. 11. 14  enhanced ImageDes  
// Modification(date/where):   1996.  9. 25  reformatted as standard
// Modification(date/where):   1999. 12. 03  add limitted support for less than 256 indexed 
//                                           color and transparent image and alpha channel
//
//****************************************************************

#ifndef _INC_IMAGE
#define _INC_IMAGE

#include "config.h"

#ifdef _IMG_WIN32_DLL
   #ifdef _IMG_LIBBUILD_
      #define _IMG_DLLINTERFACE __declspec(dllexport)
   #else
      #define _IMG_DLLINTERFACE __declspec(dllimport)
   #endif
#else
   #define _IMG_DLLINTERFACE
#endif

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef max
 #define max(a,b) ((a)>(b)?(a):(b))
 #define min(a,b) ((a)>(b)?(b):(a))
#endif

#ifndef IWORD
 typedef unsigned short int IWORD;
 typedef unsigned char  IBYTE;
 typedef unsigned long  IDWORD;
 typedef long  ILONG;
 typedef short int ISHORT;
 typedef enum {IFALSE=0, ITRUE=1} IBOOL;
#endif

typedef enum {IGrey=0, IGray=IGrey,  IIndexedColor, IColor256, ITrueColor}  IImageType;

typedef struct {IBYTE r,g,b;}   IMyRGB;

// defination of image descripter
typedef  struct {
 IBOOL       alloc;      // flag used to indicate if memory has been allocated
 IBOOL       load;       // flag used to indicate if it has been loaded
 IImageType  imagetype;  // flag used to indicate image type
 int      xsize;         // xsize of image
 int      ysize;         // ysize of image
// this nameless union is discarded because of ANSI compatibility
// union 
// {
	 IBYTE  *    r;      // red/grey/color256  image buffer pointer
//	 IBYTE  *    grey;   // alias for grey scale image
//	 IBYTE  *    index;  // alias for indexed color image
// };
 IBYTE  *    g;          // green image buffer pointer
 IBYTE  *    b;          // blue  image buffer pointer
 IMyRGB  *   pal;        // palette pointer defination. Only used with IColor256 and Indexed image
 
 //------------- Newly added -------------
 IDWORD _allocated_size; // This is the actually allocated buffer size for each channel
 IBOOL alpha;			 // indicate if an alpha channel exists
 IBYTE  *    a;          // alpha  image buffer pointer

 IDWORD numColors;		 // this is the number of colors for the images planes
 IBOOL transparent;		 // if the image has a transparent color
 union __TRANS
 {
	IBYTE Index;	 //  Index to transparent palette Only used with IColor256 and Indexed image
	IBYTE Grey;     //  grey
	IMyRGB Color;	 //  transparent color for ITrueColor
 } trans;
 double gamma;			 // image gamma reference value
 IBOOL background;		 // indicate if a background color exists
 union __BACKGND
 {
	IBYTE Index;	 //  Index to background palette Only used with IColor256 and Indexed image
	IBYTE Grey;      // for grey
	IMyRGB Color;	 //  background color for true color
 } back;
} ImageDes;


typedef struct {
  int xstart, ystart;
  int xend, yend;
} IRect;


typedef enum {     // This defines the interpolation type of interpolation routines
  IInterp_normal,   // or bilinear interpolation (medium speed)
  IInterp_fast,     // or near neighbor interpolation (palette image can only do this) (fastest speed)
  IInterp_fine      // or bicubic interpolation (slowest speed)
 } IInterpType;
  

#define DWORD_COLOR_RED(x)   ((IBYTE)(x))
#define DWORD_COLOR_GREEN(x) ((IBYTE)(((IDWORD)(x))>>8))
#define DWORD_COLOR_BLUE(x)  ((IBYTE)(((IDWORD)(x))>>16))
#define DWORD_COLOR_ALPHA(x) ((IBYTE)(((IDWORD)(x))>>24))

#define DWORD_COLOR(r,g,b,a) ( ((IDWORD)((r)&0xff))    |   \
                               ((IDWORD)((g)&0xff)<<8) |   \
                               ((IDWORD)((b)&0xff)<<16)|   \
                               ((IDWORD)((a)&0xff)<<24)    )


// imgalloc.c
_IMG_DLLINTERFACE
IBOOL AllocPicture(ImageDes *picture, int xsize, int ysize, IImageType imagetype, IBOOL alpha, IDWORD numColor);
_IMG_DLLINTERFACE
IBOOL ReAllocPicture(ImageDes *picture, int xsize, int ysize, IImageType imagetype, IBOOL alpha);
_IMG_DLLINTERFACE
void FreePicture(ImageDes *picture);
_IMG_DLLINTERFACE
IBOOL InitPicture(ImageDes *picture, int xsize, int ysize, IImageType imagetype, IBOOL alpha, IDWORD numColor);

// imgc24_8.c
_IMG_DLLINTERFACE
IBOOL img_color24to8(ImageDes* des, ImageDes src, IDWORD num_of_color, IDWORD min_index);
_IMG_DLLINTERFACE
IBOOL img_colorquantization(ImageDes* des, ImageDes src, IDWORD num_of_color, IDWORD min_index);
// imgc2g.c
_IMG_DLLINTERFACE 
IBOOL img_color2grey(ImageDes *img, IBOOL justPalette);
// img_c24.c
_IMG_DLLINTERFACE
IBOOL img_to_color24(ImageDes *img);
// imgquant.c
_IMG_DLLINTERFACE
IBOOL img_quantbits(ImageDes *img, int numbits_per_plane);

// imgcopy.c
_IMG_DLLINTERFACE
IBOOL img_newcopy(ImageDes *des, ImageDes src);
_IMG_DLLINTERFACE
IBOOL img_copyblock(ImageDes *des, ImageDes src, int xs, int ys, int x, int y);
_IMG_DLLINTERFACE
IBOOL img_copybilt(ImageDes *des, ImageDes src,
		  int xs, int ys, int x, int y, int dx, int dy, IDWORD fills);

// imgflat.c
_IMG_DLLINTERFACE
IBOOL img_flatten(ImageDes *img, IDWORD bkcolor);
_IMG_DLLINTERFACE
IBOOL img_optimize_palette(ImageDes *img);


// ibitpack.c
//   pack R,G,B image to packed RGB image
//   Tricks:
//      packed_line_inc can be negtive to pack to bottom2up format
//      and des should be real des + packed_line_inc*ysize
_IMG_DLLINTERFACE
IBOOL img_rgb_2_packed_noalpha(ImageDes *src,  IBYTE *des, int packed_line_inc, IDWORD rPos, IDWORD gPos, IDWORD bPos, IDWORD packed_pixel_size);
//   pack R,G,B, A image to packed RGBA image
_IMG_DLLINTERFACE
IBOOL img_rgb_2_packed_alpha(ImageDes *src,  IBYTE *des, IDWORD packed_line_inc, IDWORD rPos, IDWORD gPos, IDWORD bPos, IDWORD aPos, IDWORD packed_pixel_size);
//   pack R,G,B, A image to packed RGBA image
_IMG_DLLINTERFACE
IBOOL img_r_g_b_2_packed_noalpha(IDWORD xsize, IDWORD ysize, IBYTE *sr, IBYTE *sg, IBYTE *sb, int src_line_inc, IBYTE *des, int packed_line_inc, IDWORD rPos, IDWORD gPos, IDWORD bPos, IDWORD packed_pixel_size);

// unpack RGB image to R,G,B ImageDes
//   Tricks:
//      packed_line_inc can be negtive to unpack from bottom2up format
//      and src should be real src + packed_line_inc*ysize
_IMG_DLLINTERFACE
IBOOL img_packed_2_img_noalpha(IBYTE *src, IDWORD xsize, IDWORD ysize, int packed_line_inc, IDWORD rPos, IDWORD gPos, IDWORD bPos, IDWORD packed_pixel_size, ImageDes *des);
// unpack RGBA image to R,G,B,A ImageDes
_IMG_DLLINTERFACE
IBOOL img_packed_2_img_alpha(IBYTE *src, IDWORD xsize, IDWORD ysize, int packed_line_inc, IDWORD rPos, IDWORD gPos, IDWORD bPos, IDWORD aPos, IDWORD packed_pixel_size, ImageDes *des);


#ifndef _IMG_WIN32_DLL
	extern void __Img_Busy(int percent);
#else
	#define __Img_Busy(percent)   // dummy for dll
#endif

#ifdef  __cplusplus
}
#endif

#endif
