/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : imajor.c
// Description:  majority filter
// Create Date:  1997. 5. 3
//
//****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"
#include "routines.h"
#include "mathutil.h"

#define MAJOR_MAX  30

// do majority filter of (size2*2+1)*(size2*2+1) of src to get des
IBOOL __image_majority(IBYTE *src, IBYTE *des, int xsize, int ysize, int size2, int bsystart, int bsyend)
{
 static IBYTE *bf;
 static int medsz; 
 int i, j, k, sx, sy, ovx, ovy, x, y, p, m;
  
 if(size2 <= 0) {  // size 1*1 is the same as it's self
    memcpy(des, src, xsize*ysize);
    return ITRUE;
 }
 if(size2 > MAJOR_MAX) return IFALSE;
 
 k = (size2*2+1)*(size2*2+1);
 if(k > medsz) {
   if(medsz == 0) medsz = max(1024, k);
   else medsz = k;
   if(bf == NULL) bf = malloc(medsz);
   else bf = realloc(bf, medsz);
   if(bf == NULL) {medsz = 0; return IFALSE;}
 }
 for(i=0, p=0; i<ysize; i++) {
   if(i >= size2) ovy = size2;
   else ovy = i;
   if(i+ovy >= ysize) ovy = ysize-i-1;
   sy = i-ovy;
   ovy = ovy*2+1;
   for(j=0; j<xsize; j++, p++) {
     if(j >= size2) ovx = size2;
     else ovx = j;
     if(j+ovx >= xsize) ovx = xsize-j-1;
     sx = j-ovx;
     ovx = ovx*2+1;
     if(ovx == 1 && ovy == 1) { des[p] = src[p]; continue; }
     for(y=0, k=sx+sy*xsize, m=0; y<ovy; y++, k+=xsize) 
        for(x=0; x<ovx; x++, m++)
          bf[m] = src[k+x];
     des[p] = b_major(ovx*ovy, bf);
   }
   __Img_Busy(i*(bsyend-bsystart)/ysize+bsystart);
 }
 return ITRUE;
}

// do majority filter of an image 
IBOOL  image_majority(ImageDes img, int size2)
{
  IBYTE *bf;
  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
  if(size2 <= 0) return ITRUE;
  bf = malloc(img.xsize*img.ysize);
  if(bf == NULL) return IFALSE;
  __Img_Busy(1);
  __image_majority(img.r, bf, img.xsize, img.ysize, size2, 1, img.imagetype == IGrey ? 95 : 33);
  memcpy(img.r, bf, img.xsize*img.ysize);
  __Img_Busy(img.imagetype == IGrey ? 95 : 33);
  if(img.imagetype != ITrueColor) {__Img_Busy(0); free(bf); return ITRUE;}
  __image_majority(img.g, bf, img.xsize, img.ysize, size2, 33, 66);
  memcpy(img.g, bf, img.xsize*img.ysize);
  __Img_Busy(66);
  __image_majority(img.b, bf, img.xsize, img.ysize, size2, 66, 99);
  memcpy(img.b, bf, img.xsize*img.ysize);
  __Img_Busy(0);
  free(bf); 
  return ITRUE;
}

