/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : imgcopy.c
// Description:  duplicate image or do bitbilt of an image(no interpolation)
// Create Date:
// Modification(date/where):
//
// ****************************************************************
#include <malloc.h>
#include <string.h>
#include <stdio.h>


#define _IMG_LIBBUILD_
#include "image.h"

// copy src to des. 
//  des will be allocated as need
// Return ITRUE if successful

IBOOL img_newcopy(ImageDes *des, ImageDes src)
{
 if(!src.alloc || !src.load) return IFALSE;
  #ifdef _DEBUG
     fprintf(stderr, "Dupilcate picture...");
  #endif
 if(!AllocPicture(des, src.xsize, src.ysize, src.imagetype, src.alpha, src.numColors)) return IFALSE;
 if(src.alpha) memcpy(des->a, src.a, src.xsize*src.ysize);
 switch(src.imagetype) {
     case IColor256:
	 case IIndexedColor:
        memcpy(des->pal, src.pal, 768);
     case IGrey:
        memcpy(des->r, src.r, src.xsize*src.ysize);
        break;
     case ITrueColor:
        memcpy(des->r, src.r, src.xsize*src.ysize);
        memcpy(des->g, src.g, src.xsize*src.ysize);
        memcpy(des->b, src.b, src.xsize*src.ysize);
        break;
 }
 des->load = ITRUE;
 des->transparent = src.transparent;
 des->trans = src.trans;
 des->background = src.background;
 des->back = src.back;

 des->gamma = src.gamma;
 #ifdef _DEBUG
    fprintf(stderr, "Succeed.\n");
 #endif
 return ITRUE;
}

// copy a block of src to des
//   des will be allocated as need
//   where (xs,ys) is the start point of source image block
//         (x, y) is the size of source image block
//         the copyed block must be inside the source image
// return ITRUE if successful

IBOOL img_copyblock(ImageDes *des, ImageDes src, int xs, int ys, int x, int y)
{
   int i;
   IBYTE *ss, *dd;
   
   if(!src.load || xs<0 || ys<0 || x<=0 || y<=0 
      || xs+x > src.xsize || ys+y > src.ysize) return IFALSE;
   if(!AllocPicture(des, x, y, src.imagetype, src.alpha, src.numColors)) return IFALSE;
   des->load = ITRUE;
   des->transparent = src.transparent;
   des->trans = src.trans;
   des->background = src.background;
   des->back = src.back;
   des->gamma = src.gamma;
   if(src.alpha) 
   {
	   dd = des->a; ss = src.a + xs + ys*src.xsize;
	   for(i=0; i<y; i++) {
		   memcpy(dd, ss, x);
		   dd += x; ss += src.xsize;
	   }
   }
   dd = des->r; ss = src.r + xs + ys*src.xsize;
   for(i=0; i<y; i++) {
     memcpy(dd, ss, x);
     dd += x; ss += src.xsize;
   }
   if(src.imagetype == IColor256 || src.imagetype == IIndexedColor) { memcpy(des->pal, src.pal, 768); return ITRUE; }
   if(src.imagetype != ITrueColor) return ITRUE;
   dd = des->g; ss = src.g + xs + ys*src.xsize;
   for(i=0; i<y; i++) {
     memcpy(dd, ss, x);
     dd += x; ss += src.xsize;
   }
   dd = des->b; ss = src.b + xs + ys*src.xsize;
   for(i=0; i<y; i++) {
     memcpy(dd, ss, x);
     dd += x; ss += src.xsize;
   }
   return ITRUE;
}

// copy and strech bitbilt of src to des
//   des will be allocated as need
//   where (xs,ys) is the start point of source image block
//         (x, y) is the size of source image block
//         (dx, dy) is the destination image size
//         fills is what used to fill blanked destination area
// return ITRUE if successful
IBOOL img_copybilt(ImageDes *des, ImageDes src, 
                  int xs, int ys, int x, int y, int dx, int dy, IDWORD fills)
{
   int i,j, m, n, p;
   IBYTE *ss, *dd;
   IBYTE fr, fg, fb, fa;


   
   if(!src.load || dx<=0 || dy<=0 || x<=0 || y<=0) return IFALSE;
   if(!AllocPicture(des, dx, dy, src.imagetype, src.alpha, src.numColors)) return IFALSE;
   des->load = ITRUE;
   des->transparent = src.transparent;
   des->trans = src.trans;
   des->background = src.background;
   des->back = src.back;
   des->gamma = src.gamma;
   if(src.alpha)
   {
	   fa = DWORD_COLOR_ALPHA(fills);
	   dd = des->a; ss = src.a;
	   for(j = 0; j < dy; j++, dd += dx) {
		   n = ys + j*y/dy;
		   if(n<0 || n>=src.ysize) for(i=0; i<dx; i++) dd[i] = fa;
		   else {
			   p = n*src.xsize;
			   for(i=0; i<dx; i++) {
				   m = xs + i*x/dx;
				   if(m<0 || m>=src.xsize) dd[i] = fa;
				   else dd[i] = ss[p+m];
			   }
		   }
	   }
   }

   fr = DWORD_COLOR_RED(fills);
   dd = des->r; ss = src.r;
   for(j = 0; j < dy; j++, dd += dx) {
     n = ys + j*y/dy;
     if(n<0 || n>=src.ysize) for(i=0; i<dx; i++) dd[i] = fr;
     else {
       p = n*src.xsize;
       for(i=0; i<dx; i++) {
          m = xs + i*x/dx;
          if(m<0 || m>=src.xsize) dd[i] = fr;
          else dd[i] = ss[p+m];
       }
     }
   }
   if(src.imagetype == IColor256 || src.imagetype == IIndexedColor) { memcpy(des->pal, src.pal, 768); return ITRUE; }
   if(src.imagetype != ITrueColor) return ITRUE;
   fg = DWORD_COLOR_GREEN(fills);
   dd = des->g; ss = src.g;
   for(j = 0; j < dy; j++, dd += dx) {
     n = ys + j*y/dy;
     if(n<0 || n>=src.ysize) for(i=0; i<dx; i++) dd[i] = fg;
     else {
       p = n*src.xsize;
       for(i=0; i<dx; i++) {
          m = xs + i*x/dx;
          if(m<0 || m>=src.xsize) dd[i] = fg;
          else dd[i] = ss[p+m];
       }
     }
   }
   fb = DWORD_COLOR_BLUE(fills);
   dd = des->b; ss = src.b;
   for(j = 0; j < dy; j++, dd += dx) {
     n = ys + j*y/dy;
     if(n<0 || n>=src.ysize) for(i=0; i<dx; i++) dd[i] = fb;
     else {
       p = n*src.xsize;
       for(i=0; i<dx; i++) {
          m = xs + i*x/dx;
          if(m<0 || m>=src.xsize) dd[i] = fb;
          else dd[i] = ss[p+m];
       }
     }
   }
   return ITRUE;       
}
