/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : imgdraw.h
// Description:  graphics and image block routines 
// Create Date:  1996. 12. 18
// Modification(date/where): 
//
// ****************************************************************

#ifndef _IMGDRAW_INC
#define _IMGDRAW_INC

#include "image.h"

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef _IDRAW_DEFINE
extern int _id_draw_mode;
extern IBYTE _id_red_color;
extern IBYTE _id_green_color;
extern IBYTE _id_blue_color;
#endif

#define IDRAW_OVERWRITE   0
#define IDRAW_XOR	  1
#define IDRAW_AND	  2
#define IDRAW_OR	  3



// imgdraw.c

// Set draw color
_IMG_DLLINTERFACE
void img_draw_color(IBYTE r, IBYTE g, IBYTE b);

// Retrive a most fit color index
_IMG_DLLINTERFACE
int img_draw_fitcolor(ImageDes img, IBYTE r, IBYTE g, IBYTE b);

// Set draw mode
_IMG_DLLINTERFACE
void img_draw_mode(int m);

// draw pixel at img(x,y)
_IMG_DLLINTERFACE
void img_draw_pixel(ImageDes img, int x, int y);


// id_line.c
/****************************************************************************
*
* Function:     img_draw_line
* Parameters:   img         - image to draw the line on
*               x1,y1       - First endpoint of line
*               x2,y2       - Second endpoint of line
* Description:  Scan convert a line segment using the MidPoint Digital
*               Differential Analyser algorithm.
*
****************************************************************************/
_IMG_DLLINTERFACE
void img_draw_line(ImageDes img, int x1,int y1,int x2,int y2);

// id_rect.c
/****************************************************************************
*
* Function:     img_draw_rect
* Parameters:   img         - image to draw the line on
*               x1,y1       - Upper Left corner of rect
*               x2,y2       - Down Right corner of rect
*               IBOOL solid
* Description:  draw rectanglar on image
*
****************************************************************************/
_IMG_DLLINTERFACE
void img_draw_rect(ImageDes img, int x1,int y1,int x2,int y2, IBOOL solid);


// ibitbilt.c
//   do bitbilt (rectangle block copy) of src to des
//   des must be allocated and must be the same type as src
//   where (xs,ys) is the start point of source image block (can be negtive)
//         (x, y) is the size of source image block
//         (dx, dy) is the destination location (can be negtive)
// return ITRUE if successful
_IMG_DLLINTERFACE
IBOOL img_bitbilt(ImageDes des, ImageDes src, 
                  int xs, int ys, int x, int y, int dx, int dy);
_IMG_DLLINTERFACE
IBOOL img_bitbilt_alpha(ImageDes des, ImageDes src, IBYTE *alpha,
                  int xs, int ys, int x, int y, int dx, int dy);

//   do transparent bitbilt (rectangle block copy) of src to des
//   des must be allocated and must be the same type as src
//   where (xs,ys) is the start point of source image block (can be negtive)
//         (x, y) is the size of source image block
//         (dx, dy) is the destination location (can be negtive)
//         (tr, tg, tb) is the color that is transparent, 
//            only tr is used when image is not RGB true color.
// return ITRUE if successful
_IMG_DLLINTERFACE
IBOOL img_bitbilt_transparent(ImageDes des, ImageDes src,
                  int xs, int ys, int x, int y, int dx, int dy, IBYTE tr, IBYTE tg, IBYTE tb);
_IMG_DLLINTERFACE
IBOOL img_bitbilt_transparent_alpha(ImageDes des, ImageDes src, IBYTE *alpha, 
                  int xs, int ys, int x, int y, int dx, int dy, IBYTE tr, IBYTE tg, IBYTE tb);


// imgshade.c
// Draw shadow using current color on img 
_IMG_DLLINTERFACE
IBOOL img_draw_shadow(ImageDes img, int xst, int yst, int xsz, int ysz, int radius);

#ifdef  __cplusplus
}
#endif

#endif // _IMGDRAW_INC
