/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : imgfile.c
// Description: system independent image file I/O routines
// Create Date: 1996. 11. 23
// Modification(date/where):
//
// ****************************************************************

#include <stdio.h>
#define _IMG_LIBBUILD_
#include "image.h"
#include "imgfile.h"

IWORD fgetWord(FILE *fp, IBOOL intel)
  {
    IWORD i,j;
    i=(IWORD)(fgetc(fp)&0xff);
    j=(IWORD)(fgetc(fp)&0xff);
    if(intel) return(i+(j<<8));
    else return ((i<<8)+j);
  }

IDWORD fgetLong(FILE *fp, IBOOL intel)
{
    IDWORD i,j,k,l;
    i=(IDWORD)(fgetc(fp) & 0xff);
    j=(IDWORD)(fgetc(fp) & 0xff);
    k=(IDWORD)(fgetc(fp) & 0xff);
    l=(IDWORD)(fgetc(fp) & 0xff);
    if(intel)   return(i+(j<<8)+(k<<16)+(l<<24));
    else  return(l+(k<<8)+(j<<16)+(i<<24));
}

int fputWord(IWORD wd, FILE *fp, IBOOL intel)
  {
    int rtn;
    if(intel) {
      rtn = fputc(wd&0xff, fp);
      rtn = fputc((wd>>8)&0xff, fp);
    }
    else {
      rtn = fputc((wd>>8)&0xff, fp);
      rtn = fputc(wd&0xff, fp);
    }
    return rtn;
  }

int fputLong(IDWORD dw, FILE *fp, IBOOL intel)
  {
    int rtn;
    if(intel) {
      rtn = fputc(dw&0xff, fp);
      rtn = fputc((dw>>8)&0xff, fp);
      rtn = fputc((dw>>16)&0xff, fp);
      rtn = fputc((dw>>24)&0xff, fp);
    }
    else {
      rtn = fputc((dw>>24)&0xff, fp);
      rtn = fputc((dw>>16)&0xff, fp);
      rtn = fputc((dw>>8)&0xff, fp);
      rtn = fputc(dw&0xff, fp);
    }
    return rtn;
  }
