/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : imgquant.c
// Description: bit quantization or supplimentation of images 
// Create Date: 1996. 9. 25
// Modification(date/where): 
//
//****************************************************************
#include <malloc.h>
#include <string.h>
#include <stdio.h>


#define _IMG_LIBBUILD_
#include "image.h"

void __img_quant_up(IBYTE *src, IBYTE *des, int shift, IDWORD size)
{
	register IBYTE *_src=src, *_des=des;
	register IDWORD i;
	register int _shift=shift;

	for(i=size; i>0; i--)
	{
		*_des++ = (*_src++)<<_shift;
	}
}

void __img_quant_down(IBYTE *src, IBYTE *des, int shift, IDWORD size)
{
	register IBYTE *_src=src, *_des=des;
	register IDWORD i;
	register int _shift=shift;

	for(i=size; i>0; i--)
	{
		*_des++ = (*_src++)>>_shift;
	}
}

IDWORD __img_numbits_from_numColor(IDWORD numColor)
{
	register IDWORD n=0, k=1, nc=numColor;
	while(k < numColor)
	{
		k <<= 1;
		n++;
	}
	return n;
}

IBOOL img_quantbits(ImageDes *img, int numbits_per_plane)
{
	int numbits, size;
	if(!img->alloc || !img->load) return IFALSE;
	
	numbits = __img_numbits_from_numColor(img->numColors);

	if(numbits == numbits_per_plane) return ITRUE;

	size = img->xsize*img->ysize;

	if(numbits > numbits_per_plane) 
	{
		switch(img->imagetype)
		{
		case ITrueColor:
			__img_quant_down(img->r, img->r, numbits-numbits_per_plane, size);
			__img_quant_down(img->g, img->g, numbits-numbits_per_plane, size);
			__img_quant_down(img->b, img->b, numbits-numbits_per_plane, size);
			img->numColors = 1<<numbits_per_plane;
			img->transparent = IFALSE; // quant down is not safe for transparent
			__img_quant_down((IBYTE *)&img->back.Color, (IBYTE *)&img->back.Color, numbits-numbits_per_plane, sizeof(img->back.Color));
			break;
		case IGrey:
			__img_quant_down(img->r /*grey*/, img->r /*grey*/, numbits-numbits_per_plane, size);
			img->numColors = 1<<numbits_per_plane;
			img->transparent = IFALSE; // quant down is not safe for transparent
			__img_quant_down((IBYTE *)&img->back.Grey, (IBYTE *)&img->back.Grey, numbits-numbits_per_plane, sizeof(img->back.Grey));
			break;
		case IColor256:
		case IIndexedColor:
			{
				ImageDes tmp;
				memcpy(&tmp, img, sizeof(ImageDes)); // just use the same is safe
				tmp.pal = (IMyRGB *)malloc(sizeof(IMyRGB)*256);  // except the palette which is remapped
				if(tmp.pal == NULL)
				{
					return IFALSE;
				}
				memcpy(tmp.pal, img->pal, sizeof(IMyRGB)*256);
				img_colorquantization(img, tmp, 1<<numbits_per_plane, 0);
				free(tmp.pal); 
				break;
			}
		}
	}
	else
	{
		switch(img->imagetype)
		{
		case ITrueColor:
			__img_quant_up(img->r, img->r, numbits_per_plane-numbits, size);
			__img_quant_up(img->g, img->g, numbits_per_plane-numbits, size);
			__img_quant_up(img->b, img->b, numbits_per_plane-numbits, size);
			img->numColors = 1<<numbits_per_plane;
			__img_quant_up((IBYTE *)&img->trans.Color, (IBYTE *)&img->trans.Color, numbits_per_plane-numbits, sizeof(img->trans.Color));
			__img_quant_up((IBYTE *)&img->back.Color, (IBYTE *)&img->back.Color, numbits_per_plane-numbits, sizeof(img->back.Color));
			break;
		case IGrey:
			__img_quant_up(img->r /*grey*/, img->r /*grey*/, numbits_per_plane-numbits, size);
			img->numColors = 1<<numbits_per_plane;
			__img_quant_up((IBYTE *)&img->trans.Grey, (IBYTE *)&img->trans.Grey, numbits_per_plane-numbits, sizeof(img->trans.Grey));
			__img_quant_up((IBYTE *)&img->back.Grey, (IBYTE *)&img->back.Grey, numbits_per_plane-numbits, sizeof(img->back.Grey));
			break;
		case IColor256:
		case IIndexedColor:
			break;
		}
	}
	return ITRUE;
}
