/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : irot90.c
// Description:  rotate an image by 90 degree
// Create Date:  1996. 10. 7
// Modification(date/where): 
//
//****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"

static void __rotateccw90(IBYTE *buffer, IDWORD imgWidth, IDWORD imgHeight, IBYTE *tmpbuf)
{
 IDWORD x, y;
 register IBYTE *t1;
 register IBYTE *t2;

 t1 = buffer;
 t2 = tmpbuf;
 memcpy(t2, t1, imgWidth*imgHeight);

 for(y=imgWidth; y>0; y--) {
   t2 = tmpbuf+y-1;
   for(x=0; x<imgHeight; x++) {
     *(t1++) = *t2;
     t2+=imgWidth;
    }
  }
 return;
}

IBOOL  image_rotateccw90(ImageDes *img)
{
  IBYTE *buf;
  IDWORD tmp;

  if(!img->load) return IFALSE;
  __Img_Busy(1);
  buf = (IBYTE *)malloc(img->xsize*img->ysize);
  if(buf == NULL) {__Img_Busy(0); return IFALSE;}
  if(img->alpha) 
      __rotateccw90(img->a, img->xsize, img->ysize, buf);            // calculating r,g,b planes
  __rotateccw90(img->r, img->xsize, img->ysize, buf);            // calculating r,g,b planes
  __Img_Busy(img->imagetype != ITrueColor ? 95 : 33);
//  if(img->imagetype != ITrueColor)  {__Img_Busy(0); return ITRUE;}
  if(img->imagetype == ITrueColor) {
    __rotateccw90(img->g, img->xsize, img->ysize, buf);            // calculating r,g,b planes
    __Img_Busy(66);
    __rotateccw90(img->b, img->xsize, img->ysize, buf);            // calculating r,g,b planes
    __Img_Busy(99);
  }
  free(buf);
  tmp=img->xsize;
  img->xsize = img->ysize;
  img->ysize = tmp;
  __Img_Busy(0);
  return ITRUE;
}

static void __rotatecw90(IBYTE *buffer, IDWORD imgWidth, IDWORD imgHeight, IBYTE *tmpbuf)
{
 IDWORD x, y;
 register IBYTE *t1;
 register IBYTE *t2;

 t1 = buffer;
 t2 = tmpbuf;
 memcpy(t2, t1, imgWidth*imgHeight);

 t1 = buffer;
 for(y=0; y<imgWidth; y++) {
   t2 = tmpbuf + imgWidth*(imgHeight-1)+y;
   for(x=0; x<imgHeight; x++) {
     *(t1++) = *t2;
     t2 -= imgWidth;
    }
  }
 return;
}

IBOOL  image_rotatecw90(ImageDes *img)
{
  IBYTE *buf;
  IDWORD tmp;

  if(!img->load) return IFALSE;
  __Img_Busy(1);
  buf = (IBYTE *)malloc(img->xsize*img->ysize);
  if(buf == NULL) {__Img_Busy(0); return IFALSE;}
  if(img->alpha) 
      __rotatecw90(img->a, img->xsize, img->ysize, buf);            // calculating r,g,b planes
  __rotatecw90(img->r, img->xsize, img->ysize, buf);            // calculating r,g,b planes
  __Img_Busy(img->imagetype != ITrueColor ? 95 : 33);
//  if(img->imagetype != ITrueColor)  {__Img_Busy(0); return ITRUE;}
  if(img->imagetype == ITrueColor) {
    __rotatecw90(img->g, img->xsize, img->ysize, buf);            // calculating r,g,b planes
    __Img_Busy(66);
    __rotatecw90(img->b, img->xsize, img->ysize, buf);            // calculating r,g,b planes
    __Img_Busy(99);
  }
  free(buf);
  tmp=img->xsize;
  img->xsize = img->ysize;
  img->ysize = tmp;
  __Img_Busy(0);
  return ITRUE;
}
