/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : isaturat.c
// Description:  adjust saturation of a color image
// Create Date:  1996. 10. 7
// Modification(date/where): 
//
//****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"

IBOOL  image_saturation(ImageDes img, int alpha)
// alpha is between 0 to 256, 128 is middle
{
  IBYTE *cr;
  IBYTE *cg;
  IBYTE *cb;
  IMyRGB  *pal;
  int tr, tg, tb, ty;
  int x,y, i; 

  if(!img.load || img.imagetype == IGrey) return IFALSE;
  if(alpha > 256 || alpha < 0) return IFALSE;
  alpha = (alpha -128)*2;
  cr = img.r;
  cg = img.g;
  cb = img.b;
  if(img.imagetype == ITrueColor) 
     for(x=0; x<img.xsize; x++) {
        __Img_Busy(x*100/img.xsize);
        for(y=0; y<img.ysize; y++) {
          // Y = 0.30  *R + 0.59 *G + 0.11 *B
          ty = (int)(((IWORD)*cr *77 + (IWORD)*cg *151 + (IWORD)*cb *28) >> 8); 
          tr =  (int)(((int)*cr*(alpha+256) - alpha*ty + 127)/256);
          if(tr > 255) *cr = 255;
          else if(tr < 0) *cr = 0;
          else *cr = (IBYTE)tr;

          tg =  (int)(((int)*cg*(alpha+256) - alpha*ty + 127)/256);
          if(tg > 255) *cg = 255;
          else if(tg < 0) *cg = 0;
          else *cg = (IBYTE)tg;

          tb =  (int)(((int)*cb*(alpha+256) - alpha*ty + 127)/256);
          if(tb > 255) *cb = 255;
          else if(tb < 0) *cb = 0;
          else *cb = (IBYTE)tb;

          cr++; cg++; cb++;
        }
     }
  else { // palette 256 color
     pal = img.pal;
     for(i=0; i<256; i++) {
          __Img_Busy(i*100/256);
          // Y = 0.30  *R + 0.59 *G + 0.11 *B
          ty = (int)(((IWORD)pal[i].r *77 + (IWORD)pal[i].g *151 + (IWORD)pal[i].b *28) >> 8); 
          tr =  (int)(((int)pal[i].r*(alpha+256) - alpha*ty + 127)/256);
          if(tr > 255) pal[i].r = 255;
          else if(tr < 0) pal[i].r = 0;
          else pal[i].r = (IBYTE)tr;

          tg =  (int)(((int)pal[i].g*(alpha+256) - alpha*ty + 127)/256);
          if(tg > 255) pal[i].g = 255;
          else if(tg < 0) pal[i].g = 0;
          else pal[i].g = (IBYTE)tg;

          tb =  (int)(((int)pal[i].b*(alpha+256) - alpha*ty + 127)/256);
          if(tb > 255) pal[i].b = 255;
          else if(tb < 0) pal[i].b = 0;
          else pal[i].b = (IBYTE)tb;
     }
  }
  __Img_Busy(0);
  return ITRUE;
}
