/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : ishrink.c
// Description:  do area shrink or expand
// Create Date:  1996. 10. 7
// Modification(date/where): 
//
//****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"
#include "routines.h"


void __shrink_expand(IBYTE *bf, int xsz, int ysz, IBOOL expd, IBOOL conn4)
{
  int i,j,k, nbs, nbi;
  int p;
  int  nb[9];

  store_addr3x3(nb, xsz);
  if(conn4) { nbs = 1, nbi = 2;}
  else {nbs=0; nbi = 1; }

  if(expd) { // expand
     for(j=1;j <ysz-1; j++) {
        p = j*xsz;
        for(i=1; i<xsz-1; i++)
           if(!bf[p+i])
              for(k=nbs; k<8; k+=nbi)
                 if(bf[p+i+nb[k]]==255) {
                    bf[p+i] = 127;
                    break;
                 }
     }
     for(j=1;j <ysz-1; j++) {
        p = j*xsz;
        for(i=1; i<xsz-1; i++)
           if(bf[p+i]==127) bf[p+i] = 255;
     }
  }
  else {   // shrink
     for(j=1;j <ysz-1; j++) {
        p = j*xsz;
        for(i=1; i<xsz-1; i++)
           if(bf[p+i])
              for(k=nbs; k<8; k+=nbi)
                 if(bf[p+i+nb[k]]==0) {
                    bf[p+i] = 127;
                    break;
                 }
     }
     for(j=1;j <ysz-1; j++) {
        p = j*xsz;
        for(i=1; i<xsz-1; i++)
           if(bf[p+i]==127) bf[p+i] = 0;
     }
  }
}

IBOOL  image_expand(ImageDes img)
{
  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
  __Img_Busy(1);
  __shrink_expand(img.r, img.xsize, img.ysize, ITRUE, IFALSE);            // calculating r,g,b planes
  __Img_Busy(img.imagetype != ITrueColor ? 95 : 33);
  if(img.imagetype == IGrey){__Img_Busy(0); return ITRUE;}
  __shrink_expand(img.g, img.xsize, img.ysize, ITRUE, IFALSE);            // calculating r,g,b planes
  __Img_Busy(66);
  __shrink_expand(img.b, img.xsize, img.ysize, ITRUE, IFALSE);            // calculating r,g,b planes
  __Img_Busy(0);
  return ITRUE;
}

IBOOL  image_shrink(ImageDes img)
{
  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
  __Img_Busy(1);
  __shrink_expand(img.r, img.xsize, img.ysize, IFALSE, IFALSE);            // calculating r,g,b planes
  __Img_Busy(img.imagetype != ITrueColor ? 95 : 33);
  if(img.imagetype == IGrey){__Img_Busy(0); return ITRUE;}
  __shrink_expand(img.g, img.xsize, img.ysize, IFALSE, IFALSE);            // calculating r,g,b planes
  __Img_Busy(66);
  __shrink_expand(img.b, img.xsize, img.ysize, IFALSE, IFALSE);            // calculating r,g,b planes
  __Img_Busy(0);
  return ITRUE;
}                   
