/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : isketch.c
// Description:  Convert image to sketch like drawing.
// Create Date:  2000. 03. 01  (YYYY/MM/DD) - By Adam Hoult
//
//****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"
#include "routines.h"

/* apply sketch filter to image pointed by buffer */
void applysketch(IBYTE *buffer, int imgWidth, int imgHeight) 
{
   int          i;
   short int    matrix[9];

        // Initial Sketch matrix  is  -4 -4 -4
        //                            -4 20  0
        //                            -4  0  0
        for (i=0; i<8; i++)  matrix[i] = -4;     
        matrix[8] = 20;
		matrix[3] = 0;
		matrix[4] = 0;
		matrix[5] = 0;
        self_convolution3x3(buffer, matrix, 1, imgWidth, imgHeight);
}

IBOOL  image_sketch(ImageDes img)
{
  IDWORD x,y;
  IBYTE *rr, *gg, *bb, gr;
  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
  __Img_Busy(1);
  applysketch(img.r, img.xsize, img.ysize);            // calculating r,g,b planes
  __Img_Busy(img.imagetype == IGrey ? 95 : 33);
  if(img.imagetype == IGrey) {__Img_Busy(0); return ITRUE;}
  applysketch(img.g, img.xsize, img.ysize);
  __Img_Busy(66);
  applysketch(img.b, img.xsize, img.ysize);
  __Img_Busy(0);
  //Convert Image to Negative (black on white instead of white on black)
  image_negative(img);
  
  //Convert all colours to a greyscale.
  rr = img.r;
  gg = img.g;
  bb = img.b;
  for(y=img.ysize; y; y--)
   {
	   for(x=img.xsize; x; x--)
	   {
			gr = (IBYTE)((IWORD)((IWORD)*rr*77+(IWORD)*gg*151+(IWORD)*bb*28)>>8);
			*rr++ = gr;
			*gg++ = gr;
			*bb++ = gr;
	   }
  }
  return ITRUE;
}


