/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : looktbl.c
// Description:  Mosiac effect of an image
// Create Date:  1996. 10. 1
//
//****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "image.h"

// lookup table process
void table_mod_(IBYTE *tabaddr, IBYTE *buffer, int imgWidth, int imgHeight)
{
  register IDWORD i;
  register IBYTE *tbl=tabaddr;
  register IBYTE *buf=buffer;
  for (i=imgHeight*imgWidth; i; i--, buf++)
       *buf = tbl[*buf];       // replace the value by lookup table value
}

void table_mod_int(int *tabaddr, IBYTE *buffer, int imgWidth, int imgHeight)
{
  register IDWORD i;
  register int *tbl=tabaddr;
  register IBYTE *buf=buffer;
  for (i=imgHeight*imgWidth; i; i--, buf++)
       *buf = (IBYTE)tbl[*buf];       // replace the value by lookup table value
}

void threshold_(IBYTE *buffer, IBYTE th_, IBYTE small_, IBYTE big_, int imgWidth, int imgHeight)
{
  register IDWORD i;
  register IBYTE *buf=buffer;
  register IBYTE th=th_;
  register IBYTE small=small_;
  register IBYTE big=big_;
  for (i=imgHeight*imgWidth; i; i--, buf++)
       *buf = *buf >= th ? big : small;      // replace the value by lookup table value
}
