/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : mat3x3.c
// Description:  some 3x3 matrix operation routines
// Create Date:  1997. 6. 30
// Modification(date/where): 
//
// ****************************************************************

#include <float.h>
#include <math.h>
#include <string.h>

int __mat_3x3_is_not_degenerate(double mat[9])
{
  double det;
  
  det = mat[0]*mat[4]*mat[8] + mat[1]*mat[5]*mat[6] + mat[2]*mat[3]*mat[7]
      - mat[2]*mat[4]*mat[6] - mat[1]*mat[3]*mat[8] - mat[0]*mat[5]*mat[7];
  if(fabs(det) <= DBL_EPSILON) return 0;
  return 1;
}

int __inv_mat_3x3(double des[9], double src[9])
{
  double det;
  double t[9];
  
  det = src[0]*src[4]*src[8] + src[1]*src[5]*src[6] + src[2]*src[3]*src[7]
      - src[2]*src[4]*src[6] - src[1]*src[3]*src[8] - src[0]*src[5]*src[7];
  if(fabs(det) <= DBL_EPSILON) return 0;
  
  t[0] = (src[4]*src[8] - src[5]*src[7])/det;
  t[1] = (src[2]*src[7] - src[1]*src[8])/det;
  t[2] = (src[1]*src[5] - src[2]*src[4])/det;
  t[3] = (src[5]*src[6] - src[3]*src[8])/det;
  t[4] = (src[0]*src[8] - src[2]*src[6])/det;
  t[5] = (src[2]*src[3] - src[0]*src[5])/det;
  t[6] = (src[3]*src[7] - src[4]*src[6])/det;
  t[7] = (src[1]*src[6] - src[0]*src[7])/det;
  t[8] = (src[0]*src[4] - src[1]*src[3])/det;
  memcpy(des, t, 9*sizeof(double));
  return 1;
}  


// c= a*b,  c can be the same as a or b or a new one
void __mat_mul_3x3(double a[9], double b[9], double c[9]) 
{
 double t[9];
 int i,j,k;
   // t = rot*rot'
  for(i=0; i<=8; i++) {
    j = (i/3)*3; k = i%3;
    t[i] = a[j]*b[k] + a[j+1]*b[k+3] + a[j+2]*b[k+6];
  }
  memcpy(c, t, 9*sizeof(double));
  return;
}

void construct_project_matrix(double pj[9], double roll, double pitch, double yaw, double camA[4], double camB[4])
{
  double  c1, c2, c3, s1, s2, s3,  cam[9];
  double scl;


  roll *= (3.1415926535897932385/180.0);
  pitch *= (3.1415926535897932385/180.0);
  yaw *= (3.1415926535897932385/180.0);

  c1 = cos(roll);
  s1 = sin(roll);
  c2 = cos(pitch);
  s2 = sin(pitch);
  c3 = cos(yaw);
  s3 = sin(yaw);

//  yaw then pitch
  pj[0] = c1*c3;    pj[1] = s1*c2 - c1*s2*s3;   pj[2] = s1*s2 + c1*c2*s3; 
  pj[3] = -s1*c3;   pj[4] = c1*c2 + s1*s2*s3;   pj[5] = c1*s2 - s1*c2*s3; 
  pj[6] = -s3;      pj[7] = -s2*c3;             pj[8] = c2*c3; 

//  pitch then yaw
//  pj[0] = c1*c3 - s1*s2*s3;    pj[1] = s1*c2;   pj[2] = c1*s3 + s1*s2*c3; 
//  pj[3] = -s1*c3 - c1*s2*s3;   pj[4] = c1*c2;   pj[5] = -s1*s3 + c1*s2*c3; 
//  pj[6] = -c2*s3;              pj[7] = -s2;     pj[8] = c2*c3; 

  // FA
  scl = camA[3]/camA[2];
  cam[0] = 1;       cam[1] = 0;       cam[2] = camA[0];
  cam[3] = 0;       cam[4] = scl;     cam[5] = camA[1];
  cam[6] = 0;       cam[7] = 0;       cam[8] = camA[2];
  
  //  C=R*FA
  __mat_mul_3x3(pj, cam, pj);

  // FB^-1
  scl = camB[3]/camB[2];
  cam[0] = 1;       cam[1] = 0;       cam[2] = -camB[0]/camB[2];
  cam[3] = 0;       cam[4] = 1/scl;   cam[5] = -camB[1]/camB[3];
  cam[6] = 0;       cam[7] = 0;       cam[8] = 1/camB[2];

  // A = FB^-1*R*FA
  __mat_mul_3x3(cam, pj, pj);

  return;
}  
