/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : mmedian.c
// Description:  median filter ...
// Create Date:  1997. 3. 10
// ****************************************************************


#include <malloc.h>
#include <stdlib.h>
#include <string.h>
#include "mathutil.h"


// return the median value of x which is size n
#define RTN_AVERAGE  1
#define RTN_MED      0
 
#define macro_median(funcname, data_type, SORTPROC, rtntype) \
data_type funcname(int n, data_type *x)                    \
{                                                          \
 static data_type *bf = NULL;                              \
 static int medsz = 0;                                     \
                                                           \
 if(n < 0) return (data_type)0;                            \
 if(n <= 2) return x[0];                                   \
                                                           \
 if(n > medsz) {                                           \
   if(medsz == 0) medsz = max(1024, n);                    \
   else medsz = n;                                         \
   if(bf == NULL) bf = malloc(medsz*sizeof(data_type));    \
   else bf = realloc(bf, medsz*sizeof(data_type));         \
   if(bf == NULL) {medsz = 0; return x[0];}                \
 }                                                         \
 memcpy(bf, x, n*sizeof(data_type));                       \
 SORTPROC(n, bf);                                          \
 if(rtntype) {                                             \
   if(n&1)  return bf[n/2];                                \
   return (bf[n/2]+bf[n/2+1])/(data_type)2;                \
 }                                                         \
 else                                                      \
   return bf[n/2];                                         \
}                                                          \



// double r_median(int n, double *x)
macro_median(r_median, double, r_qsort, RTN_AVERAGE)

// float f_median(int n, float *x)
macro_median(f_median, float, f_qsort, RTN_AVERAGE)

// int i_median(int n, int *x)
macro_median(i_median, int, i_qsort, RTN_MED)

// unsigned char b_median(int n, unsigned char *x)
macro_median(b_median, unsigned char, b_qsort, RTN_MED)






// return the majority or the median                   
#define macro_major(funcname, data_type, SORTPROC)         \
data_type funcname(int n, data_type *x)                    \
{                                                          \
 int i, k, k1, k2;                                         \
 data_type t, t1, t2;                                      \
                                                           \
 if(n <= 1) return  x[0];                                  \
 SORTPROC(n,x);                                            \
 t = x[0];  k = 1;                                         \
 k1 = k2 = 0;  t1 = t2 = t; k1 = k2 = k;                   \
 for(i=1; i<n; i++)                                        \
    if(t == x[i]) k++;                                     \
    else {                                                 \
      if(k > k1) {                                         \
        t2 = t1; k2 = k1;                                  \
        t1 = t;  k1 = k;                                   \
      }                                                    \
      else if(k > k2) {                                    \
        t2 = t;  k2 = k;                                   \
      }                                                    \
      k = 1; t = x[i];                                     \
    }                                                      \
                                                           \
 if(k > k1 && k > 1) return t;                             \
 if(k1 > 1) {                                              \
   if(k1 > k2) return t1;                                  \
   if(k1 > n/4)                                            \
     return (abs(t1-x[n/2]) > abs(t2-x[n/2])) ? t2 : t1;   \
 }                                                         \
 return x[n/2];                                            \
}                                                          \




// int i_major(int n, int *x)
macro_major(i_major, int, i_qsort)

// unsigned char b_major(int n, unsigned char *x)
macro_major(b_major, unsigned char, b_qsort)

