/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : routines.h
// Description:  image processing general routines header file
// Create Date:  1996. 9. 11
// Modification(date/where):   1996. 10.01 reformatted as standard
// Modification(date/where):   1996. 12.10 add fast routines
// Modification(date/where):   1997.  1.13 add clip routines
// Modification(date/where):   1997.  5.14 add fastrtns.c routines
// ****************************************************************

#ifndef _INC_ROUTINES
#define _INC_ROUTINES

#include "image.h"

#ifdef  __cplusplus
extern "C" {
#endif

// cliprect.c
IBOOL __clip_rect(int src_xsz, int src_ysz, int des_xsz, int des_ysz, 
                 int *xsts, int *ysts, int *xstd, int *ystd, int *xblk, int *yblk);

// convfilt.c
void store_addr3x3(int addr[9], int xsize);
void store_addr5x5(int addr[25], int xsize);
void convolution3x3(IBYTE *src, short int *des, short int mtx[9], int xsize, int ysize);
void self_convolution3x3(IBYTE  *src, short int mtx[9], short int divisor, int xsize, int ysize);
void blank_frame(void *buf, int xsize, int ysize, int elmsz);
void trace_peak(IBYTE *img, short int *buf, int xsize, int ysize, int th);

// fastconv.c
void sobel_edge(IBYTE *img, short int *buf, int xsize, int ysize);
void sobel_edge_unsigned(IBYTE *img, int xsize, int ysize);
void find_edge_fast(IBYTE *img, short int *buf, int xsize, int ysize);
void blur_3x3(IBYTE  *img, int xsize, int ysize);
void blur_3x3_fast(IBYTE  *img, short int *buf, int xsize, int ysize);

// colorpre.c
void color_unify(IBYTE *cr, IBYTE *cg, IBYTE *cb, int xsize, int ysize);
short diffcolor(IBYTE r1, IBYTE g1, IBYTE b1, IBYTE r2, IBYTE g2, IBYTE b2);

// imghisto.c
int select_threshold(int *histo, int hsize, int scale1000);
void count_histo(int *histo, int hsize, void *ptr, int sz, int cnt);

// looktbl.c
void table_mod_(IBYTE *tabaddr, IBYTE *buffer, int imgWidth, int imgHeight);
void table_mod_int(int *tabaddr, IBYTE *buffer, int imgWidth, int imgHeight);
void threshold_(IBYTE *buffer, IBYTE th, IBYTE small, IBYTE big, int imgWidth, int imgHeight);

// lut2d.c
void __lut2d(IBYTE *src, int srcx, int srcy, IBYTE *des, int desx, int desy, long *lutxy, IBYTE fill);
void __lut2d_fast(IBYTE *src, int srcx, int srcy, IBYTE *des, int desx, int desy, long *lutxy, IBYTE fill);
void __lut2d_fine(IBYTE *src, int srcx, int srcy, IBYTE *des, int desx, int desy, long *lutxy, IBYTE fill);
void __lut2d_keep_old(IBYTE *src, int srcx, int srcy, IBYTE *des, int desx, int desy, long *lutxy);
void __lut2d_fast_keep_old(IBYTE *src, int srcx, int srcy, IBYTE *des, int desx, int desy, long *lutxy);
void __lut2d_fine_keep_old(IBYTE *src, int srcx, int srcy, IBYTE *des, int desx, int desy, long *lutxy);


// resample.c
void __resample(IBYTE *src, int imgWidth, int imgHeight, IBYTE *des, int newWidth, int newHeight);
void __resample_fast(IBYTE *src, int imgWidth, int imgHeight, IBYTE *des, int newWidth, int newHeight);
void __resample_fine(IBYTE *src, int imgWidth, int imgHeight, IBYTE *des, int newWidth, int newHeight);

// imedian.c
IBOOL __image_median(IBYTE *src, IBYTE *des, int xsize, int ysize, int size2, int bsystart, int bsyend);

// imajor.c 
// do majority filter of (size2*2+1)*(size2*2+1) of src to get des
IBOOL __image_majority(IBYTE *src, IBYTE *des, int xsize, int ysize, int size2, int bsystart, int bsyend);

// ishrink.c
void __shrink_expand(IBYTE *bf, int xsz, int ysz, IBOOL expd, IBOOL conn4);

//imgquant.c
void __img_quant_up(IBYTE *src, IBYTE *des, int shift, IDWORD size);
void __img_quant_down(IBYTE *src, IBYTE *des, int shift, IDWORD size);

#define swapit(a, b, type) {type __swap; __swap = (a); (a) = (b); (b) = __swap}

#ifdef __WATCOMC__
  //$$$ This is machine dependent
  //$$$ it is for Watcom C32 10.0 on Intel i386 platform
  extern short int limit_it(short int a);
  #pragma aux limit_it=\
		"cmp    ax, 0"  \
		"jge    no_neg" \
		"neg    ax"     \
  "no_neg: 	 cmp    ax, 255"\
		"jle    no_over"\
		"mov    ax, 255"\
  "no_over:"                      \
		parm [ax]       \
		value[ax]
  extern short int myabs(short int a);
  #pragma aux myabs=\
		"cmp    ax, 0"  \
		"jge    no_neg" \
		"neg    ax"     \
  "no_neg:"	                \
		parm [ax]       \
		value[ax]

  extern int trunc_8(int a);
  #pragma aux trunc_8=\
		"cmp    eax, 0"  \
		"jge    no_neg" \
		"xor    eax,eax"     \
  "no_neg: 	 cmp    eax, 255"\
		"jle    no_over"\
		"mov    eax, 255"\
  "no_over:"                      \
		parm [eax]       \
		value[eax]

#elif defined(_MSC_VER)
  //MSC writing
    __inline short int limit_it(short int a) {
      if(a < 0) 
         if( a < -255) return 255; else return -a;
      else if(a > 255) return 255;
      else return a;
    }
    __inline short int myabs(short int a) {if(a<0) return -a; else return a;}
    __inline int trunc_8(int a) {
      if(a < 0) return 0;
      else if(a > 255) return 255;
      else return a;
    }
#else
  // if inline is not supported then this is defined in: fastrtns.c
    short int m_limit_it(short int a);
    short int m_myabs(short int a);
    int m_trunc_8(int a);
    #define  limit_it(a)  m_limit_it(a)
    #define  myabs(a)     m_myabs(a)
    #define  trunc_8(a)   m_trunc_8(a)
#endif


#ifdef  __cplusplus
}
#endif

#endif
