#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>


#include "..\proc\image.h"
#include "..\proc\imgfile.h"
#include "..\proc\imgdraw.h"
#include "..\util\utility.h"

ImageDes  img;
ImageDes  des;
#ifndef _IMG_WIN32_DLL
void __Img_Busy(int percent)
{
  if(percent > 100)    printf("Busy \b\b\b\b\b");
  else if(percent<= 0) printf("Idle \b\b\b\b\b");
  else                 printf("%3d%% \b\b\b\b\b", percent);
}            
#endif

int main(int argc, char **argv)
{
  int tmp;
  int quality = 75;
  char ifname[257];
  char ofname[257];
  char ext[4];
  IBOOL csplit;
  IBOOL togray;
  IBOOL to256;
  
  ifname[0]=0;
  ofname[0]=0;
  ext[0] = 0;
  csplit=IFALSE;
  togray=IFALSE;
  to256=IFALSE;
  fputs("Image File Format Converter Version 1.0a\n"
        "Released 05/25/1999, Yang YuDong.\n"
        "   yangyd@yahoo.com\n"
	    "   http://pcvideo.yeah.net\n", stderr);
  for(tmp=1; tmp <argc; tmp++)
    if(argv[tmp][0] != '/' && argv[tmp][0] != '-')
      if(!*ifname)  strcpy(ifname, argv[tmp]);
      else strcpy(ofname, argv[tmp]);
    else 
      switch (argv[tmp][1]){
       case '?' :
         fputs("Usage :  Img2Img infilename [outfilename] [options]\n"
		       "Options :  \n"
               "      /? : command line help\n"
               "      /S : split true color image to  r, g, b (defalut no) \n"
               "      /G : force converting to gray scale (defalut no) \n"
               "      /P : force converting to 256 color (defalut no) \n"
		       "     /Qn : n = 0..100, set JPEG quality (default 75)\n"
               "   /Xext : Specify the destination image type by extension\n"
               "           ext = RAW TIF BMP JPG TGA PNG\n", 
		 stderr);
         return 0;
       case 'x' :
       case 'X' :
         strncpy(ext, argv[tmp]+2, 3);
         ext[3]=0;
         break;
       case 'q' :
       case 'Q' :
         quality = atoi(argv[tmp]+2);
		 if(quality > 100) quality = 100;
		 else if(quality < 0) quality = 0;
         break;
       case 's' :
       case 'S' :
         csplit=ITRUE;
         break;
       case 'g' :
       case 'G' :
         togray=ITRUE;
         break;
       case 'p' :
       case 'P' :
         to256=ITRUE;
         break;
       default :
           fputs("Unknown option :", stderr); fputs(argv[tmp], stderr); fputs("\n", stderr);
           return 0;
     }
  if(!*ifname){
    fputs("Use: 'Img2Img /?' for help\n", stderr);
    return 0;
  }
  if(!*ofname) strcpy(ofname, ifname);
  
  if(ext[0]) 
  {
	  replace_extension(ofname, ext, WIMG_PATH_SEPR, 256);
	  strncpyupr(ext, ext, 5);
  }
  {
	  char *pext = get_file_extension(ofname, WIMG_PATH_SEPR);
	  if(pext) strncpyupr(ext, pext, 5);
	  else strcpy(ext, "PNG"); // assume it is PNG
  }

  des.alloc=img.alloc=IFALSE;
  if(!Loadfile_on_extension(ifname, &img, -1, -1, IFALSE, WIMG_PATH_SEPR)) {
    fprintf(stderr, "Error: unable to load image '%s'\n", ifname);
    return 0;
  }
  if(csplit && img.imagetype == ITrueColor) {
    des.alloc = des.load = ITRUE;
    des.imagetype = IGrey; des.xsize = img.xsize; des.ysize = img.ysize;
    des.r = img.r;
    replace_extension(ofname, "R", WIMG_PATH_SEPR, 256);
    SaveRawGrey(ofname, des);
    des.r = img.g;
    replace_extension(ofname, "G", WIMG_PATH_SEPR, 256);
    SaveRawGrey(ofname, des);
    des.r = img.b;
    replace_extension(ofname, "B", WIMG_PATH_SEPR, 256);
    SaveRawGrey(ofname, des);
    des.alloc = IFALSE;
    goto img_done;
  }
  else if(togray  && img.imagetype != IGray) img_color2grey(&img, IFALSE);
  else if(to256 && img.imagetype == ITrueColor)
    if(img_color24to8(&des, img, 256, 0)) { FreePicture(&img); img=des; }  
    else { 
      fprintf(stderr, "Error: unable to convert image '%s'\n", ifname);
      return 0;
    }

  // optimize the palette
  //img_optimize_palette(&img);
  if(ext[0]) // try to flatten the image if needed
  {
	 if(strcmp(ext, "PNG")) // only PNG support alpha channel and background and transparent
	 {
		 // flatten the image on a white background
		 IDWORD bk = DWORD_COLOR(255,255,255,255);
		 if(img.imagetype != ITrueColor && img.imagetype != IGrey)
			bk = img_draw_fitcolor(img, 255, 255, 255);
		 img_flatten(&img, bk);
	 }
  }

  if(!Savefile_on_extension(ofname, img, WIMG_PATH_SEPR, 75)) {
    FreePicture(&des);
    FreePicture(&img);
    fprintf(stderr, "Error: unable to save image '%s'\n", ofname);
    return 0;
  }

img_done:
  FreePicture(&img);
  printf("Done %s\n", ofname);
  return 1;

}
