#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "..\proc\image.h"
#include "..\proc\imgfile.h"
#include "..\proc\imgproc.h"
#include "..\proc\imgdraw.h"
#include "..\util\utility.h"

ImageDes  img;
ImageDes  des;
ImageDes  mid;
void __Img_Busy(int percent)
{
  if(percent > 100)    printf("Busy \b\b\b\b\b");
  else if(percent<= 0) printf("Idle \b\b\b\b\b");
  else                 printf("%3d%% \b\b\b\b\b", percent);
}            

int main(int argc, char **argv)
{
  int tmp;
  char ifname[257];
  char ofname[257];
  char bfname[257];
  int xdes, ydes;
  double xzoom, yzoom, zoom;
  int br=0, bg=0, bb=0;
  int xsize, ysize;
  int xstart, ystart;
  int desxs, desys;
  IBOOL fit = IFALSE, full = IFALSE;
  int shadow=0;
  

  fputs("Image File Fit In Version 1.1a\n"
        "Released 05/25/1999, Yang YuDong.\n"
        "   yangyd@yahoo.com\n"
	    "   http://pcvideo.yeah.net\n", stderr);

  ifname[0]=0;
  ofname[0]=0;
  bfname[0]=0;
  xdes = 704; ydes = 576;
  xsize = 0; ysize = 0;
  for(tmp=1; tmp <argc; tmp++)
    if(argv[tmp][0] != '/' && argv[tmp][0] != '-')
      if(!*ifname)  strcpy(ifname, argv[tmp]);
      else strcpy(ofname, argv[tmp]);
    else 
      switch (argv[tmp][1]){
       case '?' :
         fputs("Usage :  ImgFit infilename [outfilename] [options]\n", stderr);
         fputs("Options :  \n", stderr);
         fputs("             /? : commandline help\n", stderr);
         fputs("            /Xm : source horizontal size (RAW file only)\n", stderr);
         fputs("            /Ym : source vertical size (RAW file only)\n", stderr);
         fputs("            /Hr : destination horizontal size (default is 704)\n", stderr);
         fputs("            /Vr : destination vertical size   (default is 576)\n", stderr);
		 fputs("            /Z  : Zoom image to fit just inside (dafualt is no)\n", stderr);
         fputs("            /F  : zoom image to full with clip  (default is no)\n", stderr);
         fputs("            /Rn : Back ground Red   (0-255, dafault is 0)\n", stderr);
         fputs("            /Gn : Back ground Green (0-255, dafault is 0)\n", stderr);
         fputs("            /Bn : Back ground Blue  (0-255, dafault is 0)\n", stderr);
         fputs("            /Pname : Use back ground picture 'name' \n"
			   "                  (picture 'name' will be clipped)\n", stderr);
         fputs("            /Sn : Draw shadow on background (height n)\n", stderr);
         return 0;
       case 'x' :
       case 'X' :
         sscanf(argv[tmp]+2, "%d", &xsize);
         break;
       case 'y' :
       case 'Y' :
         sscanf(argv[tmp]+2, "%d", &ysize);
         break;
       case 'h' :
       case 'H' :
         sscanf(argv[tmp]+2, "%d", &xdes);
         break;
       case 'v' :
       case 'V' :
         sscanf(argv[tmp]+2, "%d", &ydes);
         break;
       case 'r' :
       case 'R' :
           sscanf(argv[tmp]+2, "%d", &br);
           break;
       case 'g' :
       case 'G' :
           sscanf(argv[tmp]+2, "%d", &bg);
           break;
       case 'b' :
       case 'B' :
           sscanf(argv[tmp]+2, "%d", &bb);
           break;
       case 'p' :
       case 'P' :
           strcpy(bfname, argv[tmp]+2);
           break;
       case 'z' :
       case 'Z' :
           fit = ITRUE;
           break;
       case 'f' :
       case 'F' :
           full = ITRUE;
           break;
       case 's' :
       case 'S' :
           sscanf(argv[tmp]+2, "%d", &shadow);
           break;
       default :
           fputs("Unknown option :", stderr); fputs(argv[tmp], stderr); fputs("\n", stderr);
           return 0;
     }
  if(!*ifname){
    fputs("Use: 'ImgFit /?' for help\n", stderr);
    return 0;
  }
  if(xdes <= 0 || ydes <= 0) {
    fputs("Error: destination size is invalid.\n", stderr);
    return 0;
  }
  if(br < 0 || bg < 0 || bb < 0 || br > 255 || bg > 255 || bb >255)  {
    fputs("Error: invalid back ground color.\n", stderr);
    return 0;
  }



  mid.alloc = des.alloc = img.alloc = IFALSE;
  if(!Loadfile_on_extension(ifname, &img, xsize, ysize, IFALSE, WIMG_PATH_SEPR)) {
    fprintf(stderr, "Error: unable to load image '%s'\n", ifname);
    return 0;
  }
  if(xdes == img.xsize && ydes == img.ysize) {
	  if(!*ofname || !strcmp(ofname, ifname)) { // src == des
		  printf("Not changed : %s\n", ifname);
		  return 0;
	  } 
	  else if(!Savefile_on_extension(ofname, img, WIMG_PATH_SEPR, 75)) {
		  FreePicture(&img);
		  fprintf(stderr, "Error: unable to save image '%s'\n", ofname);
		  return 0;
	  }
	  FreePicture(&img);
	  printf("Done %s\n", ofname);
	  return 1;
  }
  
  if(!AllocPicture(&des, xdes, ydes, img.imagetype, img.alpha, img.numColors)) {
    fprintf(stderr, "Error: failed to alloc destination buffer\n");
    return 0;
  }

  if(!*ofname) strcpy(ofname, ifname);

  xsize = img.xsize; ysize = img.ysize;
  zoom = 1.0;

  if(fit) {
	xzoom = (double)xdes/(double)img.xsize;
	yzoom = (double)ydes/(double)img.ysize;
	if(xzoom > yzoom) { ysize = ydes; xsize = (int)(img.xsize*yzoom); zoom = yzoom; }
	else { xsize = xdes; ysize = (int)(img.ysize*xzoom);  zoom = xzoom; }
  }
  if(full) {
	xzoom = (double)xdes/(double)img.xsize;
	yzoom = (double)ydes/(double)img.ysize;
	if(xzoom > yzoom) { xsize = xdes; ysize = (int)(img.ysize*xzoom); zoom = xzoom; }
	else { ysize = ydes; xsize = (int)(img.xsize*yzoom); zoom = yzoom; }
  }

  
  des.load = ITRUE;
  if(img.imagetype == IColor256 || img.imagetype == IIndexedColor) memcpy(des.pal, img.pal, 768);
  if(!full) {
	if(img.imagetype == ITrueColor) img_draw_color((IBYTE)br, (IBYTE)bg, (IBYTE)bb);
	else img_draw_color((IBYTE)img_draw_fitcolor(img, (IBYTE)br, (IBYTE)bg, (IBYTE)bb), 0, 0);
	img_draw_mode(IDRAW_OVERWRITE);
	img_draw_rect(des, 0, 0, xdes, ydes, ITRUE);
  }

  if(bfname[0] && Loadfile_on_extension(bfname, &mid, 0, 0, IFALSE, WIMG_PATH_SEPR)) { // has backgnd pic
      if(mid.xsize >= xdes) { xstart = (mid.xsize-xdes)/2; desxs = 0; }
      else { xstart = 0; desxs = (xdes-mid.xsize)/2; }
      if(mid.ysize >= ydes) { ystart = (mid.ysize-ydes)/2; desys = 0; }
      else { ystart = 0; desys = (ydes-mid.ysize)/2; }
	  img_bitbilt(des, mid, xstart, ystart, xdes, ydes, desxs, desys);
  }	  


  if(xsize >= xdes) { xstart = (xsize-xdes)/2; desxs = 0; }
  else { xstart = 0; desxs = (xdes-xsize)/2; }
  if(ysize >= ydes) { ystart = (ysize-ydes)/2; desys = 0; }
  else { ystart = 0; desys = (ydes-ysize)/2; }
  if(shadow) {
	  img_draw_shadow(des, desxs+shadow, desys+shadow, xsize, ysize, abs(shadow)*2+1);
  }
  if(zoom == 1.0) { // no zoom is needed
	  if(!img_bitbilt(des, img, xstart, ystart, xsize, ysize, desxs, desys)) {
		  FreePicture(&des);
		  FreePicture(&img);
		  fprintf(stderr, "Error: failed to do fit\n");
		  return 0;
	  }
  }
  else {
	  if(!image_resample(&mid, img, xsize, ysize, IInterp_fine)) {
		  FreePicture(&des);
		  FreePicture(&img);
		  fprintf(stderr, "Error: failed to do fit\n");
		  return 0;
	  }
	  if(!img_bitbilt(des, mid, xstart, ystart, xsize, ysize, desxs, desys)) {
		  FreePicture(&des);
		  FreePicture(&img);
		  fprintf(stderr, "Error: failed to do fit\n");
		  return 0;
	  }
	  FreePicture(&mid);
  }
  if(!Savefile_on_extension(ofname, des, WIMG_PATH_SEPR, 75)) {
    FreePicture(&des);
    FreePicture(&img);
    fprintf(stderr, "Error: unable to save image '%s'\n", ofname);
    return 0;
  }
  FreePicture(&des);
  FreePicture(&img);
  printf("Done %s\n", ofname);
  return 1;
}

  
