/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : vdfilter.h
// Description:  filter interface for VirtualDub
// Create Date:  2000. 10. 29
//
//****************************************************************

#include <windows.h>

#include "../proc/imgproc.h"
#include "../proc/imgdraw.h"
#include "../proc/imgfile.h"

#include "sdk/ScriptInterpreter.h" // virtualDub
#include "sdk/ScriptError.h" // virtualDub
#include "sdk/ScriptValue.h" // virtualDub
#include "sdk/filter.h"  // virtualDub

#define _IMG_FILTER_VERSION_STR "1.0A"

struct MyFilterData 
{
	HWND hWin;
	HINSTANCE hInst;
	PixDim  xsize, ysize;
	ImageDes img;
	int which;
	int parm1, parm2;
	bool	clip;
	int	top, bottom, left, right; // clip
};


typedef struct
{
	const char *desc;
	void *func;
	const char *parmstr;
	int numparm;
	int defaultparm1, defaultparm2;
} FilterFunc;


typedef IBOOL (*proc_noparm)(ImageDes img);
typedef IBOOL (*proc_1parm)(ImageDes img, int parm1);
typedef IBOOL (*proc_2parm)(ImageDes img, int parm1, int parm2);

extern FilterFunc filters[];

// winproc.cpp
int filter_config(MyFilterData *cfg);

