# Add Marker at 5 seconds interval
# * 
# * Version: 1.1
# * Author: Harold Linke
# * Date: October 6, 2018
# * Copyright: Harold Linke 2018
# * VEGASPython: https://www.hlinke.de/dokuwiki/doku.php?id=en:vegas_python
# * VEGASPython on Github: https://github.com/haroldlinke/VEGASPython
# * 
# * based on JScript script by: Edward Troxel
# * www.jetdv.com/tts
# * Modified: 05-29-2003
# *
# * History of Change
# * V1.00 07.10.2018 - Harold Linke - adaptation for VEGASPython
# * V1.01 17.08.2019 - Harold Linke - added group handling
# *
#
import clr
clr.AddReference('ScriptPortal.Vegas')
import ScriptPortal.Vegas
from ScriptPortal.Vegas import *

def FromVegas(pyVEGAS):
      # Change this value to be the desired interval
      # Format:  hh:mm:ss:ff (hours:minutes:seconds:frames)      
      Interval = "00:00:05:00"
      
      IncTime=Timecode.FromString(Interval)
      CurrTime = IncTime
      EndTime = pyVEGAS.Project.Length
      
      while CurrTime < EndTime:
            # Put a marker at the interval point
            myMarker = Marker(CurrTime)
            pyVEGAS.Project.Markers.Add(myMarker)
            CurrTime = Timecode(CurrTime.ToMilliseconds() + IncTime.ToMilliseconds())
            
            
if __name__ == "__main__":
      FromVegas(pyVEGAS)