# This script will add regions for all events on the selected track
# 
# * 
# * Version: 1.0
# * Author: Harold Linke
# * Date: September 29, 2018
# * Copyright: Harold Linke 2018
# * VEGASPython: https://www.hlinke.de/dokuwiki/doku.php?id=en:vegas_python
# * VEGASPython on Github: https://github.com/haroldlinke/VEGASPython
# * 
# * based on Jscript by John Meyer 11/4/2003 (with ideas from Edward Troxel's "Markers to Events" script)
# *
# * History of Change
# * V1.00 29.09.2018 - Harold Linke - adaptation for VEGASPython


import clr
clr.AddReference('ScriptPortal.Vegas')
import ScriptPortal.Vegas
from ScriptPortal.Vegas import *

def FromVegas(pyVEGAS):
    
    for track in pyVEGAS.Project.Tracks:
        if track.Selected:
            RegionNumber = 1
            for event in track.Events:
                myRegion = Region(event.Start,event.Length,str(RegionNumber));#Insert a region over this event
                pyVEGAS.Project.Regions.Add(myRegion)
                
if __name__ == "__main__":
    FromVegas(pyVEGAS)                