# * Adds slow motion effect to the selected clips, adjusts the length of the clip to the slomo rate
# * 
# * Version: 1.1
# * Author: Harold Linke
# * Date: August 16, 2018
# * Copyright: Harold Linke 2018
# * VEGASPython: https://www.hlinke.de/dokuwiki/doku.php?id=en:vegas_python
# * VEGASPython on Github: https://github.com/haroldlinke/VEGASPython
# *
# * History of Change
# * V1.00 14.08.2018 - Harold Linke - initial implementation
# * V1.10 16.08.2018 - Harold Linke - removed automatic analysis start
# * 

 
import clr
clr.AddReference('System.Windows.Forms')
import System.Windows.Forms
# from System.Windows.Forms import *
clr.AddReference('ScriptPortal.Vegas')
import ScriptPortal.Vegas
from ScriptPortal.Vegas import *

clr.AddReference('System.Drawing')
import System.Drawing


class StringDialog (System.Windows.Forms.Form):

    def addTextControl(self,labelName, left, width, top, defaultValue):
        self.label = System.Windows.Forms.Label()
        self.label.AutoSize = True
        self.label.Text = labelName + ":"
        self.label.Left = left
        self.label.Top = top + 4
        self.Controls.Add(self.label)

        self.textbox = System.Windows.Forms.TextBox()
        self.textbox.Multiline = False
        self.textbox.Left = self.label.Right
        self.textbox.Top = top 
        self.textbox.Width = width - (self.label.Width)
        self.textbox.Text = defaultValue
        self.Controls.Add(self.textbox)

        return self.textbox

    def __init__(self,mainLabel, inputLabel, inputInit):
        self.Text = mainLabel
        self.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog
        self.MaximizeBox = False
        self.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        self.Width = 350
        self.Height = 160

        self.buttonWidth = 80
        self.buttonHeight = 24
        self.buttonTop = 60

        self.stringBox = self.addTextControl(inputLabel, 20, 200, 20, inputInit)

        self.okButton = System.Windows.Forms.Button()
        self.okButton.Text = "OK"
        self.okButton.Left = 240 - ((self.buttonWidth+20))
        self.okButton.Top = self.buttonTop
        self.okButton.Width = self.buttonWidth
        self.okButton.Height = self.buttonHeight
        self.okButton.DialogResult = System.Windows.Forms.DialogResult.OK
        self.AcceptButton = self.okButton
        self.Controls.Add(self.okButton)

        self.btnCancel = System.Windows.Forms.Button()
        self.btnCancel.Text = "Cancel"
        self.btnCancel.Left = 140 - ((self.buttonWidth+20))
        self.btnCancel.Top = self.buttonTop
        self.btnCancel.Width = self.buttonWidth
        self.btnCancel.Height = self.buttonHeight
        self.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel
        
#        self.AcceptButton = self.okButton
        self.Controls.Add(self.btnCancel)
        self.Controls.Add(self.okButton)

        self.label = System.Windows.Forms.Label()
        self.label.AutoSize = True
        self.label.Text = "Copyright 2018 Hlinke"
        self.label.Left = 20
        self.label.Top = 100
        self.Controls.Add(self.label)

def FindSelectedEvents (myVEGAS: Vegas):
    selectedEvents = []
    for track in myVEGAS.Project.Tracks:
        for trackEvent in track.Events:
            if trackEvent.Selected:
                if not (trackEvent in selectedEvents):
                    eventisGrouped = trackEvent.IsGrouped
                    if eventisGrouped: # add all group members e.g. audio and video
                        selectedEvents += list(trackEvent.Group) # add all grouped events
                    else:
                        selectedEvents.append(trackEvent)
    return selectedEvents     



def FromVegas(pyVEGAS : Vegas):
    

    dialog = StringDialog("Script - Add Slow Motion to Clip","Slow Mo Play Rate (0.00)","1.00")
    
    dialogResult = dialog.ShowDialog()
    
    if System.Windows.Forms.DialogResult.OK == dialogResult:
              
        playrate_str = dialog.stringBox.Text
        
        playrate = float(playrate_str)
    
        for evnt in FindSelectedEvents(pyVEGAS): 
            length_TC = evnt.Length
            length_MS = length_TC.ToMilliseconds()
            
            newLength = Timecode.FromMilliseconds(length_MS / playrate)
            evnt.Length = newLength
        
        pyVEGAS.UpdateUI()
        
        selEvent = []
        
        for track in pyVEGAS.Project.Tracks: # type: Track_
            if track.MediaType == MediaType.Video:
                for evnt in track.Events: # type: TrackEvent_
                    if (evnt.Selected):
                        if evnt.MediaType == MediaType.Video: # only video events
                            selEvent.append(evnt)
    
        bezierEvent = None
    
        if (len(selEvent) == 0):
            System.Windows.Forms.MessageBox.Show("Missing Selection", "No selected event", System.Windows.Forms.MessageBoxButtons.OK, System.Windows.Forms.MessageBoxIcon.Warning)
        else:
            hasSloMoFx = False
            for Event in selEvent: # type: VideoEvent
                fxList = Event.Effects
                for slomoFX in fxList: # type: Effect_
                    if slomoFX.PlugIn.UniqueID == "{Svfx:de.magix:TimeWarp}":
                        hasSloMoFx=True
                        break
                if not hasSloMoFx:
                    plugIn = pyVEGAS.VideoFX.FindChildByUniqueID("{Svfx:de.magix:TimeWarp}")
                    if plugIn:
                        Event.Effects.AddEffect(plugIn)
                        for slomoFX in fxList:
                            if slomoFX.PlugIn.UniqueID == "{Svfx:de.magix:TimeWarp}":
                                hasSloMoFx=True
                                break                        
                    
                if hasSloMoFx:
                    ofxList = slomoFX.OFXEffect.Parameters
                    ParamAnalyseButton = None
                    hasParamAnalyseButton = False
                    
                    #  BezierParamLoc = ofxList.Find(x => (x.Name == "Location_0"))
    
                    for SloMoParam in ofxList: # type: OFXParameter
                        if SloMoParam.Name == "Analyse Button":
                            SloMoParamAB = SloMoParam
                        if SloMoParam.Name == "Slow Motion Ratio":
                            SloMoParamRatio = SloMoParam
#                    User needs to be able to seelct the analysis quality before startingthe analysis
#                    when starting automatically the prog
#                    SloMoParamAB.ParameterChanged () 
                    SloMoParamRatio.Value = playrate                    
    
            if not hasSloMoFx:
                System.Windows.Forms.MessageBox.Show("Add Slow Motion Effect to Clip", "VEGAS Slow Motion Effect not applied", System.Windows.Forms.MessageBoxButtons.OK, System.Windows.Forms.MessageBoxIcon.Warning)
      
          
                    
if __name__ == "__main__":
    FromVegas(pyVEGAS)                           
