# inverts the motion tracking information that was copied by the script "copy motion track to PIP"
# of the selected video events 
# After applying this script  the PIP will not follow the tracked object anymore 
# but the tracked object is fixed on the screen
# 
# * To use this script:
# * 1) Create track motion on an event using Bezier mask FX
# * 2) 
# * 2) Apply a PiP FX to the event (from a different track) that you want to follow along with the motion on the original event
# * 3) Adjust location, scale and angle of PiP FX for a certain point in time.
# * 4) Select both events (hold ctrl key)
# * 5) Run the script
# *
# *
# * Version: 1.0
# * Author: Harold Linke
# * Date: August 16, 2019
# * Copyright: Harold Linke 2019
# * VEGASPython: https://www.hlinke.de/dokuwiki/doku.php?id=en:vegas_python
# * VEGASPython on Github: https://github.com/haroldlinke/VEGASPython
# * 
# *
# * History of Change
# * V1.00 16.08.2019 - Harold Linke - initial creation


import clr
#clr.AddReference('VEGASPythonTools')
#import VegasPythonTools
#from VegasPythonTools import *

clr.AddReference('ScriptPortal.Vegas')
import ScriptPortal.Vegas as VEGAS
from ScriptPortal.Vegas import *

clr.AddReference("System.Windows.Forms")
import System.Windows.Forms as WinForms

def FromVegas (myVegas):
    missingSelectionString = "Please select the video event to which you have applied tracking and the overlapping video event on a different track that holds the media you want to pin to the tracking."
    missingTrackingDataString = "You must first apply the Bezier masking plug-in to one of the selected events and add motion tracking data for Mask 1."
    missingPipFxString = "You must first add the Picture in Picture plug-in to the event that you want to pin to the motion tracked event."
    TrackingDataCopiedString = "Inverting of track motion data finished"

    selEvent = []
    
    for track in myVegas.Project.Tracks: # type: Track_
        if track.MediaType == MediaType.Video:
            for evnt in track.Events: # type: VideoEvent
                if (evnt.Selected):
                    if evnt.MediaType == MediaType.Video: # only video events
                        selEvent.append(evnt)

    PIPEvent = None
    haspipfx = False

    if (len(selEvent) != 2):
        WinForms.MessageBox.Show(missingSelectionString, "Less or more than two selected event", WinForms.MessageBoxButtons.OK, WinForms.MessageBoxIcon.Warning)
    else:
        for evnt in selEvent: # type: VideoEvent
            fxList = evnt.Effects
           
            for pipFX in fxList: # type: Effect_
                if pipFX.PlugIn.UniqueID == "{Svfx:com.vegascreativesoftware:pictureinpicture}":
                    haspipfx = True

                    ofxparamList = pipFX.OFXEffect.Parameters
                    for param in ofxparamList: # type: OFXParameter_
                        if param.Name == "Location":
                            # handle location Keyframes
                            valueAtCursorPosition = param.GetValueAtTime(Timecode(myVegas.Transport.CursorPosition.ToMilliseconds()))
                            initlocX = valueAtCursorPosition.X
                            initlocY = valueAtCursorPosition.Y                                

                            for paramKeyframe in param.Keyframes: # type:OFXDouble2DKeyframe
                                tmpkeyframe = param.GetValueAtTime(paramKeyframe.Time) # type:OFXDouble2D
                                print(tmpkeyframe.X,",",tmpkeyframe.Y)
                                tmpkeyframe.X = 2* initlocX - tmpkeyframe.X
                                tmpkeyframe.Y = 2* initlocY - tmpkeyframe.Y
                                print(tmpkeyframe.X,",",tmpkeyframe.Y)
                                param.SetValueAtTime(paramKeyframe.Time, tmpkeyframe)
                   
                        if param.Name == "Angle":
                            # handle Angle Keyframes

                            print("Set Angle Keyframe:")
                            for paramKeyframe in param.Keyframes:
                                print(paramKeyframe.Time)
                                tmpValue = -param.GetValueAtTime(paramKeyframe.Time)
                                param.SetValueAtTime(paramKeyframe.Time, tmpValue)

                        if param.Name == "Scale":
                            # handle Scale Keyframes
                            valueAtCursorPosition = param.GetValueAtTime(Timecode(myVegas.Transport.CursorPosition.ToMilliseconds()))
                            initScale = valueAtCursorPosition
                            print("Set ScaleX Keyframe:")
                            for paramKeyframe in param.Keyframes:
                                tmpValue = initScale/param.GetValueAtTime(paramKeyframe.Time)
                                param.SetValueAtTime(paramKeyframe.Time, tmpValue)
                                
                        if param.Name == "DistortionScaleY":
                            # handle ScaleY Keyframes
                            valueAtCursorPosition = param.GetValueAtTime(Timecode(myVegas.Transport.CursorPosition.ToMilliseconds()))
                            initScaleY = valueAtCursorPosition
                            print("Set ScaleY Keyframe:")
                            for paramKeyframe in param.Keyframes:
                                tmpValue = initScaleY/param.GetValueAtTime(paramKeyframe.Time)
                                param.SetValueAtTime(paramKeyframe.Time, tmpValue)
                                
                        if param.Name == "DistortionShear":
                            # handle Shear Keyframes

                            print("Set ScaleY Keyframe:")
                            for paramKeyframe in param.Keyframes:
                                tmpValue = -param.GetValueAtTime(paramKeyframe.Time)
                                param.SetValueAtTime(paramKeyframe.Time, tmpValue)

                    WinForms.MessageBox.Show(TrackingDataCopiedString, "Motion Track Keyframe Invertation Finished", WinForms.MessageBoxButtons.OK, WinForms.MessageBoxIcon.Warning)                    
                        
 
        if not haspipfx:
            WinForms.MessageBox.Show(missingPipFxString, "No PiP FX", WinForms.MessageBoxButtons.OK, WinForms.MessageBoxIcon.Warning)


if __name__ == "__main__":
    FromVegas(pyVEGAS)        



    
    
    
