# * Limit the length of all selected clips to 4 seconds including groups
# * 
# * Version: 1.1
# * Author: Harold Linke
# * Date: August 16, 2018
# * Copyright: Harold Linke 2018
# * VEGASPython: https://www.hlinke.de/dokuwiki/doku.php?id=en:vegas_python
# * VEGASPython on Github: https://github.com/haroldlinke/VEGASPython
# * 
# * based on JScript script by: Edward Troxel
# * www.jetdv.com/tts
# * Modified: 05-29-2003
# *
# * History of Change
# * V1.00 07.10.2018 - Harold Linke - adaptation for VEGASPython
# * V1.01 17.08.2019 - Harold Linke - added group handling
# *

 
import clr
clr.AddReference('System.Windows.Forms')
import System.Windows.Forms
from System.Windows.Forms import *
clr.AddReference('ScriptPortal.Vegas')
import ScriptPortal.Vegas
from ScriptPortal.Vegas import *

clr.AddReference('System.Drawing')
import System.Drawing


def FindSelectedEvents (myVEGAS: Vegas):
    selectedEvents = []
    for track in myVEGAS.Project.Tracks:
        for trackEvent in track.Events:
            if trackEvent.Selected:
                if not (trackEvent in selectedEvents):
                    eventisGrouped = trackEvent.IsGrouped
                    if eventisGrouped: # add all group members e.g. audio and video
                        selectedEvents += list(trackEvent.Group) # add all grouped events
                    else:
                        selectedEvents.append(trackEvent)
    return selectedEvents     


def FromVegas(pyVEGAS):
    maxLength = Timecode.FromString("00:00:04:00")

    # Go through the list of selected events
    for evnt in FindSelectedEvents(pyVEGAS):
        dLength = evnt.Length
        if dLength > maxLength:
            dLength = maxLength
        evnt.Length = dLength
                    
if __name__ == "__main__":
    FromVegas(pyVEGAS)                           
