# This script will add markers between all events on the selected track
#
# * Version: 1.0
# * Author: Harold Linke
# * Date: October 6, 2018
# * Copyright: Harold Linke 2018
# * VEGASPython: https://www.hlinke.de/dokuwiki/doku.php?id=en:vegas_python
# * VEGASPython on Github: https://github.com/haroldlinke/VEGASPython
# * 
# * based on JScript script by: Edward Troxel
# * www.jetdv.com/tts
# * Modified: 05-29-2003
# *
# * History of Change
# * V1.00 07.10.2018 - Harold Linke - adaptation for VEGASPython
# *
#

import clr
clr.AddReference('ScriptPortal.Vegas')
import ScriptPortal.Vegas
from ScriptPortal.Vegas import *

def FromVegas(pyVEGAS):

    for track in pyVEGAS.Project.Tracks:
        if track.Selected:
            for event in track.Events:
                myMarker = Marker(event.Start)
                pyVEGAS.Project.Markers.Add(myMarker)
                
if __name__ == "__main__":
    FromVegas(pyVEGAS)                