/*//////////////////////////////////////////////////////////////////////////

	flaXen Cartoon Tool for VirtualDub
	(c) Copyright 2000 Dan Flower (flaXen)

	A simple edge darkening tool for cartoons created by me.

*//////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <stdio.h>
#include <math.h>

#include "resource.h"
#include "filter.h"
#include "ScriptInterpreter.h"
#include "ScriptError.h"
#include "ScriptValue.h"

typedef struct MyFilterData {
	long	*TanTab, *ScaleTab;
	long	*yr, *yg, *yb;
	long	*ir, *ig, *ib;
	long	*qr, *qg, *qb;
	long	*ri, *rq;
	long	*gi, *gq;
	long	*bi, *bq;
	int		daShow, daInt, daCBase, daSBase;
} MyFilterData;

///////////////////////////////////////////////////////////////////////////

int		fxTOONRunProc(const FilterActivation *fa, const FilterFunctions *ff);
void	fxToon_DarkenYIQs(Pixel32 *, Pixel32 *, long, long, long, MyFilterData *);
void	fxToon_DarkenYIQ(Pixel32 *, Pixel32 *, long, long, long, MyFilterData *);
int		fxTOONStartProc(FilterActivation *fa, const FilterFunctions *ff);
int		fxTOONEndProc(FilterActivation *fa, const FilterFunctions *ff); 
int		fxTOONInitProc(FilterActivation *fa, const FilterFunctions *ff);
int		fxTOONConfigProc(FilterActivation *fa, const FilterFunctions *ff, HWND hwnd);
void	fxTOONStringProc(const FilterActivation *fa, const FilterFunctions *ff, char *buf);
void	fxTOONScriptConfig(IScriptInterpreter *isi, void *lpVoid, CScriptValue *argv, int argc);
bool	fxTOONFssProc(FilterActivation *fa, const FilterFunctions *ff, char *buf, int buflen);

///////////////////////////////////////////////////////////////////////////

ScriptFunctionDef fxTOON_func_defs[]={
    { (ScriptFunctionPtr)fxTOONScriptConfig, "Config", "0iii" },
    { NULL },
};

CScriptObject fxTOONobj={
    NULL, fxTOON_func_defs
};

struct FilterDefinition filterDef_fxTOON = {
	NULL, NULL, NULL,		// next, prev, module

	"Cartoon Tool",				// name
	"flaXen's Cartoon Tool",	// desc
	"flaXen",				// maker

	NULL,					// private_data
	sizeof(MyFilterData),	// inst_data_size
	fxTOONInitProc,			// initProc
	NULL,					// deinitProc
	fxTOONRunProc,			// runProc
	NULL,					// paramProc
	fxTOONConfigProc,		// configProc
	fxTOONStringProc,		// stringProc
	fxTOONStartProc,			// startProc
	fxTOONEndProc,			// endProc
	&fxTOONobj,				// script_obj
	fxTOONFssProc,			// fssProc
};

///////////////////////////////////////////////////////////////////////////

extern "C" int __declspec(dllexport) __cdecl VirtualdubFilterModuleInit2(FilterModule *fm, const FilterFunctions *ff, int& vdfd_ver, int& vdfd_compat);
extern "C" void __declspec(dllexport) __cdecl VirtualdubFilterModuleDeinit(FilterModule *fm, const FilterFunctions *ff);

static FilterDefinition *fd_fxTOON;

int __declspec(dllexport) __cdecl VirtualdubFilterModuleInit2(FilterModule *fm, const FilterFunctions *ff, int& vdfd_ver, int& vdfd_compat) {
	if (!(fd_fxTOON = ff->addFilter(fm, &filterDef_fxTOON, sizeof(FilterDefinition))))
		return 1;

	vdfd_ver    = VIRTUALDUB_FILTERDEF_VERSION;
	vdfd_compat = VIRTUALDUB_FILTERDEF_COMPATIBLE;
	return 0;
}

void __declspec(dllexport) __cdecl VirtualdubFilterModuleDeinit(FilterModule *fm, const FilterFunctions *ff) {
	ff->removeFilter(fd_fxTOON);
}

///////////////////////////////////////////////////////////////////////////

int fxTOONRunProc(const FilterActivation *fa, const FilterFunctions *ff) {
	MyFilterData	*mfd = (MyFilterData *)fa->filter_data;
	Pixel32	*isrc, *idst;
	const long	swid = fa->src.w, shei = fa->src.h;
	const long	spit = fa->src.pitch >> 2;

	isrc = (Pixel32 *)fa->src.data;
	idst = (Pixel32 *)fa->dst.data;

	if (mfd->daShow == BST_CHECKED)
		fxToon_DarkenYIQs(isrc, idst, swid, shei, spit, mfd);
	else
		fxToon_DarkenYIQ(isrc, idst, swid, shei, spit, mfd);

	return 0;
}

///////////////////////////////////////////////////////////////////////////

void fxToon_DarkenYIQs(Pixel32 *isrc, Pixel32 *idst, long swid, long shei, long spit, MyFilterData *mfd) {
	PixDim	x, y;
	Pixel32	*src, *dst;
	long	cr, cg, cb, cy, ci, cq;
	long	dxy, dyy, sy, ty;
	long	*yr = (long *)mfd->yr;
	long	*yg = (long *)mfd->yg;
	long	*yb = (long *)mfd->yb;
	long	*ir = (long *)mfd->ir;
	long	*ig = (long *)mfd->ig;
	long	*ib = (long *)mfd->ib;
	long	*qr = (long *)mfd->qr;
	long	*qg = (long *)mfd->qg;
	long	*qb = (long *)mfd->qb;
	long	*ri = (long *)mfd->ri;
	long	*rq = (long *)mfd->rq;
	long	*gi = (long *)mfd->gi;
	long	*gq = (long *)mfd->gq;
	long	*bi = (long *)mfd->bi;
	long	*bq = (long *)mfd->bq;
	const long	spit4 = spit << 2;

	for (y = 0; y <= shei; y++) {
		src = isrc + y * spit;
		dst = idst + y * spit;
		for (x = 0; x <= swid; x++) {
			__asm {
				mov		ebx, [src]
				mov		eax, [ebx]
				mov		ecx, eax
				and		ecx, 0x0000FF
				shl		ecx, 2
				mov		[cb], ecx
				mov		ebx, eax
				and		ebx, 0x00FF00
				shr		ebx, 6
				mov		[cg], ebx
				and		eax, 0xFF0000
				shr		eax, 14
				mov		[cr], eax

				mov		esi, [yr]
				add		esi, eax
				mov		edx, [esi]
				mov		esi, [yg]
				add		esi, ebx
				add		edx, [esi]
				mov		esi, [yb]
				add		esi, ecx
				add		edx, [esi]
				test	edx, 0xFF000000
				jz		cs11
				jns		cs10
				xor		edx, edx
				jmp		cs12
cs10:			mov		edx, 0x00FF0000
cs11:			shr		edx, 16
cs12:			mov		[cy], edx

				mov		esi, [ir]
				add		esi, eax
				mov		edx, [esi]
				mov		esi, [ig]
				add		esi, ebx
				add		edx, [esi]
				mov		esi, [ib]
				add		esi, ecx
				add		edx, [esi]
				add		edx, 8388608
				test	edx, 0xFF000000
				jz		cs21
				jns		cs20
				xor		edx, edx
				jmp		cs22
cs20:			mov		edx, 0x00FF0000
cs21:			shr		edx, 16
cs22:			mov		[ci], edx

				mov		esi, [qr]
				add		esi, eax
				mov		edx, [esi]
				mov		esi, [qg]
				add		esi, ebx
				add		edx, [esi]
				mov		esi, [qb]
				add		esi, ecx
				add		edx, [esi]
				add		edx, 8388608
				test	edx, 0xFF000000
				jz		cs31
				jns		cs30
				xor		edx, edx
				jmp		cs32
cs30:			mov		edx, 0x00FF0000
cs31:			shr		edx, 16
cs32:			mov		[cq], edx
			}

			sy = 255 - cy - mfd->daCBase;
			if (sy < 0) sy = 0;
			__asm {
				mov		ebx, [src]
				mov		eax, [ebx + 4]
				mov		ecx, eax
				and		ecx, 0x0000FF
				shl		ecx, 2
				mov		[cb], ecx
				mov		ebx, eax
				and		ebx, 0x00FF00
				shr		ebx, 6
				mov		[cg], ebx
				and		eax, 0xFF0000
				shr		eax, 14
				mov		[cr], eax

				mov		esi, [yr]
				add		esi, eax
				mov		edx, [esi]
				mov		esi, [yg]
				add		esi, ebx
				add		edx, [esi]
				mov		esi, [yb]
				add		esi, ecx
				add		edx, [esi]
				test	edx, 0xFF000000
				jz		cd11
				jns		cd10
				xor		edx, edx
				jmp		cd12
cd10:			mov		edx, 0x00FF0000
cd11:			shr		edx, 16
cd12:			mov		[dxy], edx

				mov		ebx, [src]
				add		ebx, [spit4]
				mov		eax, [ebx]
				mov		ecx, eax
				and		ecx, 0x0000FF
				shl		ecx, 2
				mov		[cb], ecx
				mov		ebx, eax
				and		ebx, 0x00FF00
				shr		ebx, 6
				mov		[cg], ebx
				and		eax, 0xFF0000
				shr		eax, 14
				mov		[cr], eax

				mov		esi, [yr]
				add		esi, eax
				mov		edx, [esi]
				mov		esi, [yg]
				add		esi, ebx
				add		edx, [esi]
				mov		esi, [yb]
				add		esi, ecx
				add		edx, [esi]
				test	edx, 0xFF000000
				jz		cd21
				jns		cd20
				xor		edx, edx
				jmp		cd22
cd20:			mov		edx, 0x00FF0000
cd21:			shr		edx, 16
cd22:			mov		[dyy], edx
			}
			ty = abs(cy - dxy) + abs(cy - dyy) - mfd->daCBase/2;
			if (ty < 0) ty = 0;
			if (ty > 255) ty = 255;

			*dst++ = (ty << 16) | (ty << 8) | ty;
			src++;
		}
	}
}

///////////////////////////////////////////////////////////////////////////

void fxToon_DarkenYIQ(Pixel32 *isrc, Pixel32 *idst, long swid, long shei, long spit, MyFilterData *mfd) {
	PixDim	x, y;
	Pixel32	*src, *dst;
	long	cr, cg, cb, cy, ci, cq;
	long	dxy, dyy, sy, ty, cBase;
	long	*yr = (long *)mfd->yr;
	long	*yg = (long *)mfd->yg;
	long	*yb = (long *)mfd->yb;
	long	*ir = (long *)mfd->ir;
	long	*ig = (long *)mfd->ig;
	long	*ib = (long *)mfd->ib;
	long	*qr = (long *)mfd->qr;
	long	*qg = (long *)mfd->qg;
	long	*qb = (long *)mfd->qb;
	long	*ri = (long *)mfd->ri;
	long	*rq = (long *)mfd->rq;
	long	*gi = (long *)mfd->gi;
	long	*gq = (long *)mfd->gq;
	long	*bi = (long *)mfd->bi;
	long	*bq = (long *)mfd->bq;
	long	*sTab = (long *)mfd->ScaleTab;
	const long	spit4 = spit << 2;

	cBase = mfd->daCBase;

	for (y = 0; y <= shei; y++) {
		src = isrc + y * spit;
		dst = idst + y * spit;
		for (x = 0; x <= swid; x++) {
			__asm {
				mov		ebx, [src]
				mov		eax, [ebx]
				mov		ecx, eax
				and		ecx, 0x0000FF
				shl		ecx, 2
				mov		[cb], ecx
				mov		ebx, eax
				and		ebx, 0x00FF00
				shr		ebx, 6
				mov		[cg], ebx
				and		eax, 0xFF0000
				shr		eax, 14
				mov		[cr], eax

				mov		esi, [yr]
				add		esi, eax
				mov		edx, [esi]
				mov		esi, [yg]
				add		esi, ebx
				add		edx, [esi]
				mov		esi, [yb]
				add		esi, ecx
				add		edx, [esi]
				test	edx, 0xFF000000
				jz		cs11
				jns		cs10
				xor		edx, edx
				jmp		cs12
cs10:			mov		edx, 0x00FF0000
cs11:			shr		edx, 16
cs12:			mov		[cy], edx

				mov		esi, [ir]
				add		esi, eax
				mov		edx, [esi]
				mov		esi, [ig]
				add		esi, ebx
				add		edx, [esi]
				mov		esi, [ib]
				add		esi, ecx
				add		edx, [esi]
				add		edx, 8388608
				test	edx, 0xFF000000
				jz		cs21
				jns		cs20
				xor		edx, edx
				jmp		cs22
cs20:			mov		edx, 0x00FF0000
cs21:			shr		edx, 16
cs22:			mov		[ci], edx

				mov		esi, [qr]
				add		esi, eax
				mov		edx, [esi]
				mov		esi, [qg]
				add		esi, ebx
				add		edx, [esi]
				mov		esi, [qb]
				add		esi, ecx
				add		edx, [esi]
				add		edx, 8388608
				test	edx, 0xFF000000
				jz		cs31
				jns		cs30
				xor		edx, edx
				jmp		cs32
cs30:			mov		edx, 0x00FF0000
cs31:			shr		edx, 16
cs32:			mov		[cq], edx
			}

			sy = 255 - cy;// - mfd->daCBase;
			if (sy < 0) sy = 0;
			__asm {
				mov		ebx, [src]
				mov		eax, [ebx + 4]
				mov		ecx, eax
				and		ecx, 0x0000FF
				shl		ecx, 2
				mov		[cb], ecx
				mov		ebx, eax
				and		ebx, 0x00FF00
				shr		ebx, 6
				mov		[cg], ebx
				and		eax, 0xFF0000
				shr		eax, 14
				mov		[cr], eax

				mov		esi, [yr]
				add		esi, eax
				mov		edx, [esi]
				mov		esi, [yg]
				add		esi, ebx
				add		edx, [esi]
				mov		esi, [yb]
				add		esi, ecx
				add		edx, [esi]
				test	edx, 0xFF000000
				jz		cd11
				jns		cd10
				xor		edx, edx
				jmp		cd12
cd10:			mov		edx, 0x00FF0000
cd11:			shr		edx, 16
cd12:			mov		[dxy], edx

				mov		ebx, [src]
				add		ebx, [spit4]
				mov		eax, [ebx]
				mov		ecx, eax
				and		ecx, 0x0000FF
				shl		ecx, 2
				mov		[cb], ecx
				mov		ebx, eax
				and		ebx, 0x00FF00
				shr		ebx, 6
				mov		[cg], ebx
				and		eax, 0xFF0000
				shr		eax, 14
				mov		[cr], eax

				mov		esi, [yr]
				add		esi, eax
				mov		edx, [esi]
				mov		esi, [yg]
				add		esi, ebx
				add		edx, [esi]
				mov		esi, [yb]
				add		esi, ecx
				add		edx, [esi]
				test	edx, 0xFF000000
				jz		cd21
				jns		cd20
				xor		edx, edx
				jmp		cd22
cd20:			mov		edx, 0x00FF0000
cd21:			shr		edx, 16
cd22:			mov		[dyy], edx
			}
/*			ty = abs(cy - dxy) + abs(cy - dyy) - mfd->daCBase;
			if (ty < 0) ty = 0; else if (ty > 255) ty = 255;
			cy -= mfd->ScaleTab[(sy << 8) | ty];
			if (cy < 0) cy = 0; else if (cy > 255) cy = 255;	*/
			__asm {
				mov		eax, [cy]
				mov		ebx, eax
				sub		eax, [dxy]
				jns		ab10
				neg		eax
ab10:			sub		ebx, [dyy]
				jns		ab11
				neg		ebx
ab11:			add		eax, ebx
				sub		eax, [cBase]
				jns		ty10
				xor		eax, eax
				jmp		ty11
ty10:			test	eax, 0xFFFFFF00
				jz		ty11
				mov		eax, 0x00FF
ty11:
				mov		ebx, [sTab]
				mov		ecx, [sy]
				shl		ecx, 8
				or		ecx, eax
				shl		ecx, 2
				mov		eax, [cy]
				sub		eax, [ebx + ecx]

				//mov		eax, [cy]
				shl		eax, 16
				mov		ebx, [ci]
				shl		ebx, 2
				mov		ecx, [cq]
				shl		ecx, 2

				mov		edx, eax
				mov		esi, [ri]
				add		edx, [esi + ebx]
				mov		esi, [rq]
				add		edx, [esi + ecx]
				test	edx, 0xFF000000
				jz		cv21
				jns		cv20
				xor		edi, edi
				jmp		cv22
cv20:			mov		edi, 0x000000FF
				jmp		cv22
cv21:			shr		edx, 16
				mov		edi, edx
				shl		edi, 8
cv22:
				mov		edx, eax
				mov		esi, [gi]
				add		edx, [esi + ebx]
				mov		esi, [gq]
				add		edx, [esi + ecx]
				test	edx, 0xFF000000
				jz		cv31
				jns		cv30
				xor		edx, edx
				jmp		cv32
cv30:			mov		edx, 0x00FF0000
cv31:			shr		edx, 16
				or		edi, edx
cv32:			shl		edi, 8

				mov		edx, eax
				mov		esi, [bi]
				add		edx, [esi + ebx]
				mov		esi, [bq]
				add		edx, [esi + ecx]
				test	edx, 0xFF000000
				jz		cv41
				jns		cv40
				xor		edx, edx
				jmp		cv42
cv40:			mov		edx, 0x00FF0000
cv41:			shr		edx, 16
				or		edi, edx
cv42:
				mov		ebx, [dst]
				add		[dst], 4
				mov		[ebx], edi
				add		[src], 4

			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////

int fxTOONStartProc(FilterActivation *fa, const FilterFunctions *ff) {
	MyFilterData *mfd = (MyFilterData *)fa->filter_data;
	long	d, i;

	// 1/256th Scalar Table
	if (!(mfd->ScaleTab = new long[65536])) return 1;

	// RGB -> YUV (YIQ) conversion tables
	if (!(mfd->yr = new long[256])) return 1;
	if (!(mfd->yg = new long[256])) return 1;
	if (!(mfd->yb = new long[256])) return 1;

	if (!(mfd->ir = new long[256])) return 1;
	if (!(mfd->ig = new long[256])) return 1;
	if (!(mfd->ib = new long[256])) return 1;

	if (!(mfd->qr = new long[256])) return 1;
	if (!(mfd->qg = new long[256])) return 1;
	if (!(mfd->qb = new long[256])) return 1;

	// YUV (YIQ) -> RGB conversion tables
	if (!(mfd->ri = new long[256])) return 1;
	if (!(mfd->rq = new long[256])) return 1;
	if (!(mfd->gi = new long[256])) return 1;
	if (!(mfd->gq = new long[256])) return 1;
	if (!(mfd->bi = new long[256])) return 1;
	if (!(mfd->bq = new long[256])) return 1;

	// Calculate data for RGB -> YUV conversion tables
	for (d = 0; d < 256; d++) {
		// RGB -> YIQ transformation matrix
		mfd->yr[d] = (long)(+0.299 * d * 65536 + 0.5);
		mfd->yg[d] = (long)(+0.587 * d * 65536 + 0.5);
		mfd->yb[d] = (long)(+0.114 * d * 65536 + 0.5);
		mfd->ir[d] = (long)(+0.596 * d * 65536 + 0.5);
		mfd->ig[d] = (long)(-0.275 * d * 65536 + 0.5);
		mfd->ib[d] = (long)(-0.321 * d * 65536 + 0.5);
		mfd->qr[d] = (long)(+0.212 * d * 65536 + 0.5);
		mfd->qg[d] = (long)(-0.523 * d * 65536 + 0.5);
		mfd->qb[d] = (long)(+0.311 * d * 65536 + 0.5);

		// YIQ -> RGB transformation matrix
		mfd->ri[d] = (long)(+0.956 * (d-128) * 65536 + 0.5);
		mfd->rq[d] = (long)(+0.621 * (d-128) * 65536 + 0.5);
		mfd->gi[d] = (long)(-0.272 * (d-128) * 65536 + 0.5);
		mfd->gq[d] = (long)(-0.647 * (d-128) * 65536 + 0.5);
		mfd->bi[d] = (long)(-1.105 * (d-128) * 65536 + 0.5);
		mfd->bq[d] = (long)(+1.702 * (d-128) * 65536 + 0.5);
	}

	// ArcTan lookup table
	if (!(mfd->TanTab = new long[256])) return 1;
	for (d = 0; d < 255; d++) {
		mfd->TanTab[d]=200 - (long)(atan((255-d) * 0.00613592315154256 * 8) * mfd->daInt - mfd->daCBase);
		if (mfd->TanTab[d] < 0) mfd->TanTab[d] = 0;
	}

	// 1/256th Scalar Table
	for (d = 0; d < 256; d++)
		for (i = 0; i < 256; i++)
			mfd->ScaleTab[i * 256 + d] = i * (1.0 / 255.0 * d);

	return 0;
}

///////////////////////////////////////////////////////////////////////////

int fxTOONEndProc(FilterActivation *fa, const FilterFunctions *ff) {
	MyFilterData *mfd = (MyFilterData *)fa->filter_data;

	// Delete RGB -> YUV conversion tables
	delete[] mfd->yr; mfd->yr = NULL;
	delete[] mfd->yg; mfd->yg = NULL;
	delete[] mfd->yb; mfd->yb = NULL;

	delete[] mfd->ir; mfd->ir = NULL;
	delete[] mfd->ig; mfd->ig = NULL;
	delete[] mfd->ib; mfd->ib = NULL;

	delete[] mfd->qr; mfd->qr = NULL;
	delete[] mfd->qg; mfd->qg = NULL;
	delete[] mfd->qb; mfd->qb = NULL;

	delete[] mfd->ri; mfd->ri = NULL;
	delete[] mfd->rq; mfd->rq = NULL;
	delete[] mfd->gi; mfd->gi = NULL;
	delete[] mfd->gq; mfd->gq = NULL;
	delete[] mfd->bi; mfd->bi = NULL;
	delete[] mfd->bq; mfd->bq = NULL;

	delete[] mfd->TanTab; mfd->TanTab = NULL;
	delete[] mfd->ScaleTab; mfd->ScaleTab = NULL;

	return 0;
}

///////////////////////////////////////////////////////////////////////////

int fxTOONInitProc(FilterActivation *fa, const FilterFunctions *ff) {
	MyFilterData *mfd = (MyFilterData *)fa->filter_data;

	mfd->daSBase = 16;
	mfd->daInt = 200;
	mfd->daCBase = 16;
	mfd->daShow	= BST_UNCHECKED;

	return 0;
}

///////////////////////////////////////////////////////////////////////////

BOOL CALLBACK fxTOONConfigDlgProc(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam) {
	MyFilterData *mfd = (MyFilterData *)GetWindowLong(hdlg, DWL_USER);

	switch(msg) {
	case WM_INITDIALOG:
		SetWindowLong(hdlg, DWL_USER, lParam);
		mfd = (MyFilterData *)lParam;
		SetDlgItemInt(hdlg, IDC_DA_SCLBASE, mfd->daSBase, FALSE);
		SetDlgItemInt(hdlg, IDC_DA_SCLINT, mfd->daInt, FALSE);
		SetDlgItemInt(hdlg, IDC_DA_PIXBASE, mfd->daCBase, FALSE);
		CheckDlgButton(hdlg, IDC_DA_SHOW, mfd->daShow ? BST_CHECKED : BST_UNCHECKED);
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam)) {
		case IDOK:
			mfd->daSBase = GetDlgItemInt(hdlg, IDC_DA_SCLBASE, &mfd->daSBase, FALSE);
			mfd->daInt = GetDlgItemInt(hdlg, IDC_DA_SCLINT, &mfd->daInt, FALSE);
			mfd->daCBase = GetDlgItemInt(hdlg, IDC_DA_PIXBASE, &mfd->daCBase, FALSE);
			mfd->daShow = !!IsDlgButtonChecked(hdlg, IDC_DA_SHOW);
			EndDialog(hdlg, 0);

			if (mfd->daSBase > 255) mfd->daSBase = 255;
			if (mfd->daInt > 512) mfd->daInt = 512;
			if (mfd->daCBase > 255) mfd->daCBase = 255;
			return TRUE;
		case IDCANCEL:
			EndDialog(hdlg, 1);
			return FALSE;
		}
		break;
	}

	return FALSE;
}

///////////////////////////////////////////////////////////////////////////

int fxTOONConfigProc(FilterActivation *fa, const FilterFunctions *ff, HWND hwnd) {
	return DialogBoxParam(fa->filter->module->hInstModule,
	       MAKEINTRESOURCE(IDD_FXTOON_CONFIG), hwnd,
		   fxTOONConfigDlgProc, (LPARAM)fa->filter_data);
}

///////////////////////////////////////////////////////////////////////////

void fxTOONStringProc(const FilterActivation *fa, const FilterFunctions *ff, char *str) {
	MyFilterData *mfd = (MyFilterData *)fa->filter_data;

	sprintf(str, " - Darken Edges: %d, %d, %d", mfd->daSBase, mfd->daInt, mfd->daCBase);
}

///////////////////////////////////////////////////////////////////////////

void fxTOONScriptConfig(IScriptInterpreter *isi, void *lpVoid, CScriptValue *argv, int argc) {
    FilterActivation *fa = (FilterActivation *)lpVoid;
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;

	mfd->daSBase = argv[0].asInt();
	mfd->daInt = argv[1].asInt();
	mfd->daCBase = argv[2].asInt();
}

///////////////////////////////////////////////////////////////////////////

bool fxTOONFssProc(FilterActivation *fa, const FilterFunctions *ff, char *buf, int buflen) {
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;

    _snprintf(buf, buflen, "Config(%d, %d, %d)", mfd->daSBase, mfd->daInt, mfd->daCBase);

    return true;
}