#include <windows.h>
#include <stdio.h>
#include <commctrl.h> //ez az include azert kell, mert ebben van benne, hogy milyen uzeneteket lehet egy slidernek kuldeni

#include "ScriptInterpreter.h"
#include "ScriptError.h"
#include "ScriptValue.h"
#include "VBitMap.h"

#include "resource.h"
#include "filter.h"


typedef struct MyFilterData {
	IFilterPreview		*ifp;
	long	imagesize;
	long	R_offset;
	long	G_offset;
	long	B_offset;
	long	R_amp;
	long	G_amp;
	long	B_amp;
	bool	FIRSTRUN;
	unsigned char	*LUT_R;
	unsigned char	*LUT_G;
	unsigned char	*LUT_B;
} MyFilterData;

///////////////////////////////////////////////////////////////////////////

int tutorialRunProc(const FilterActivation *fa, const FilterFunctions *ff);
int tutorialStartProc(FilterActivation *fa, const FilterFunctions *ff);
int tutorialEndProc(FilterActivation *fa, const FilterFunctions *ff);
long tutorialParamProc(FilterActivation *fa, const FilterFunctions *ff);
int InitProc(FilterActivation *fa, const FilterFunctions *ff);
int tutorialConfigProc(FilterActivation *fa, const FilterFunctions *ff, HWND hwnd);
void tutorialStringProc(const FilterActivation *fa, const FilterFunctions *ff, char *str);
void tutorialScriptConfig(IScriptInterpreter *isi, void *lpVoid, CScriptValue *argv, int argc);
bool tutorialFssProc(FilterActivation *fa, const FilterFunctions *ff, char *buf, int buflen);


void MakeLUT(MyFilterData *mfd);
///////////////////////////////////////////////////////////////////////////


ScriptFunctionDef tutorial_func_defs[]={
    { (ScriptFunctionPtr)tutorialScriptConfig, "Config", "0iiiiii" },
    { NULL },
};

CScriptObject tutorial_obj={
    NULL, tutorial_func_defs
};

struct FilterDefinition filterDef_tutorial = {

    NULL, NULL, NULL,       // next, prev, module
    "color equalizer v1.1",             // name
    "Equalizes colors in the image.\r\nIt contains color offset and color amplification equalization.",
                            // desc
    "Tams B. Bak",               // maker
    NULL,                   // private_data
    sizeof(MyFilterData),   // inst_data_size

    InitProc,                   // initProc
    NULL,                   // deinitProc
    tutorialRunProc,        // runProc
    tutorialParamProc,      // paramProc
    tutorialConfigProc,     // configProc
    tutorialStringProc,     // stringProc
    tutorialStartProc,      // startProc
    tutorialEndProc,        // endProc

    &tutorial_obj,          // script_obj
    tutorialFssProc,        // fssProc

};

///////////////////////////////////////////////////////////////////////////

extern "C" int __declspec(dllexport) __cdecl VirtualdubFilterModuleInit2(FilterModule *fm, const FilterFunctions *ff, int& vdfd_ver, int& vdfd_compat);
extern "C" void __declspec(dllexport) __cdecl VirtualdubFilterModuleDeinit(FilterModule *fm, const FilterFunctions *ff);

static FilterDefinition *fd_tutorial;

///////////////////////////////////////////////////////////////////////////

int __declspec(dllexport) __cdecl VirtualdubFilterModuleInit2(FilterModule *fm, const FilterFunctions *ff, int& vdfd_ver, int& vdfd_compat) {
    if (!(fd_tutorial = ff->addFilter(fm, &filterDef_tutorial, sizeof(FilterDefinition))))
        return 1;

	vdfd_ver = VIRTUALDUB_FILTERDEF_VERSION;
	vdfd_compat = VIRTUALDUB_FILTERDEF_COMPATIBLE;

    return 0;
}

void __declspec(dllexport) __cdecl VirtualdubFilterModuleDeinit(FilterModule *fm, const FilterFunctions *ff) {
    ff->removeFilter(fd_tutorial);
}

///////////////////////////////////////////////////////////////////////////

int tutorialStartProc(FilterActivation *fa, const FilterFunctions *ff) {
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;
	mfd->imagesize = (fa->src.Size())/sizeof(Pixel32);
	MakeLUT(mfd);
    return 0;
}


int tutorialRunProc(const FilterActivation *fa, const FilterFunctions *ff) {
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;
    register unsigned char *src,*R,*G,*B;
	register long imagesize = mfd->imagesize;
	src = (unsigned char*)fa->src.data + (imagesize<<2)-1;
	R=(mfd->LUT_R);G=(mfd->LUT_G);B=(mfd->LUT_B);

    do{
		*src--;
		*src-- = R[*src];
		*src-- = G[*src];
		*src-- = B[*src];
    }while(--imagesize);

    return 0;
}
	//fa->src.BitBltXlat3(0, 0, (VBitmap *)(fa->src.data), 0, 0, (fa->src.w)-1, (fa->src.h)-1, mfd->LUT);


int tutorialEndProc(FilterActivation *fa, const FilterFunctions *ff) {
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;
	delete (mfd->LUT_R);
	mfd->LUT_R = NULL;
	delete (mfd->LUT_G);
	mfd->LUT_G = NULL;
	delete (mfd->LUT_B);
	mfd->LUT_B = NULL;
	return 0;
}

long tutorialParamProc(FilterActivation *fa, const FilterFunctions *ff) {
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;

    fa->dst.offset = fa->src.offset;

    return 0;//FILTERPARAM_SWAP_BUFFERS; FILTER_NEEDS_LAST
}

int InitProc(FilterActivation *fa, const FilterFunctions *ff) {
	MyFilterData *mfd = (MyFilterData *)fa->filter_data;

	mfd->R_offset = 0;
	mfd->B_offset = 0;
	mfd->G_offset = 0;
	mfd->R_amp = 256;
	mfd->G_amp = 256;
	mfd->B_amp = 256;

	return 0;
}

BOOL CALLBACK tutorialConfigDlgProc(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam) {
    MyFilterData *mfd = (MyFilterData *)GetWindowLong(hdlg, DWL_USER);
	char mytext [64];
    switch(msg) {
        case WM_INITDIALOG:
			{
				SetWindowLong(hdlg, DWL_USER, lParam);
				mfd = (MyFilterData *)lParam;

/*				if(!(mfd->FIRSTRUN))
				{
						mfd->R_offset = 0;
						mfd->B_offset = 0;
						mfd->G_offset = 0;
						mfd->R_amp = 256;
						mfd->G_amp = 256;
						mfd->B_amp = 256;
						mfd->FIRSTRUN=TRUE;
				}*/

				SendDlgItemMessage (hdlg, IDC_SLIDER_RA, TBM_SETTICFREQ, 255, 0);
				SendDlgItemMessage (hdlg, IDC_SLIDER_RA, TBM_SETRANGE, false, MAKELONG (0, 4*255));
				SendDlgItemMessage (hdlg, IDC_SLIDER_RA, TBM_SETPOS, true, mfd->R_amp);
				sprintf (mytext, "%.3f", float(mfd->R_amp)/256);
				SetDlgItemText (hdlg, IDC_EDIT_RA, mytext);

                SendDlgItemMessage (hdlg, IDC_SLIDER_GA, TBM_SETTICFREQ, 255, 0);
                SendDlgItemMessage (hdlg, IDC_SLIDER_GA, TBM_SETRANGE, false, MAKELONG (0, 4*255));
                SendDlgItemMessage (hdlg, IDC_SLIDER_GA, TBM_SETPOS, true, mfd->G_amp);
				sprintf (mytext, "%.3f", float(mfd->G_amp)/256);
				SetDlgItemText (hdlg, IDC_EDIT_GA, mytext);

                SendDlgItemMessage (hdlg, IDC_SLIDER_BA, TBM_SETTICFREQ, 255, 0);
                SendDlgItemMessage (hdlg, IDC_SLIDER_BA, TBM_SETRANGE, false, MAKELONG (0, 4*255));
                SendDlgItemMessage (hdlg, IDC_SLIDER_BA, TBM_SETPOS, true, mfd->B_amp);
				sprintf (mytext, "%.3f", float(mfd->B_amp)/256);
				SetDlgItemText (hdlg, IDC_EDIT_BA, mytext);


				SendDlgItemMessage (hdlg, IDC_SLIDER_RO, TBM_SETTICFREQ, 255, 0);
				SendDlgItemMessage (hdlg, IDC_SLIDER_RO, TBM_SETRANGE, true, MAKELONG (-255, 255));
				SendDlgItemMessage (hdlg, IDC_SLIDER_RO, TBM_SETPOS, true, (mfd->R_offset)/255);
				sprintf (mytext, "%d", mfd->R_offset);
				SetDlgItemText (hdlg, IDC_EDIT_RO, mytext);

                SendDlgItemMessage (hdlg, IDC_SLIDER_GO, TBM_SETTICFREQ, 255, 0);
                SendDlgItemMessage (hdlg, IDC_SLIDER_GO, TBM_SETRANGE, true, MAKELONG (-255, 255));
                SendDlgItemMessage (hdlg, IDC_SLIDER_GO, TBM_SETPOS, true, (mfd->G_offset)/255);
				sprintf (mytext, "%d", mfd->G_offset);
				SetDlgItemText (hdlg, IDC_EDIT_GO, mytext);

                SendDlgItemMessage (hdlg, IDC_SLIDER_BO, TBM_SETTICFREQ, 255, 0);
                SendDlgItemMessage (hdlg, IDC_SLIDER_BO, TBM_SETRANGE, true, MAKELONG (-255, 255));
                SendDlgItemMessage (hdlg, IDC_SLIDER_BO, TBM_SETPOS, true, (mfd->B_offset)/255);
				sprintf (mytext, "%d", mfd->B_offset);
				SetDlgItemText (hdlg, IDC_EDIT_BO, mytext);

				return TRUE;
			}
        case WM_NOTIFY:
            {
				long value;
				value = SendDlgItemMessage (hdlg, IDC_SLIDER_RA, TBM_GETPOS, 0, 0);
				sprintf (mytext, "%.3f", float(value)/256);
				SetDlgItemText (hdlg, IDC_EDIT_RA, mytext);
				(mfd->R_amp) = value;

				value = SendDlgItemMessage (hdlg, IDC_SLIDER_GA, TBM_GETPOS, 0, 0);
				sprintf (mytext, "%.3f", float(value)/256);
				SetDlgItemText (hdlg, IDC_EDIT_GA, mytext);
				(mfd->G_amp) = value;

				value = SendDlgItemMessage (hdlg, IDC_SLIDER_BA, TBM_GETPOS, 0, 0);
				sprintf (mytext, "%.3f", float(value)/256);
				SetDlgItemText (hdlg, IDC_EDIT_BA, mytext);
				(mfd->B_amp) = value;

				
				value = SendDlgItemMessage (hdlg, IDC_SLIDER_RO, TBM_GETPOS, 0, 0);
				sprintf (mytext, "%d", value);
				SetDlgItemText (hdlg, IDC_EDIT_RO, mytext);
				(mfd->R_offset) = (value<<8);

				value = SendDlgItemMessage (hdlg, IDC_SLIDER_GO, TBM_GETPOS, 0, 0);
				sprintf (mytext, "%d", value);
				SetDlgItemText (hdlg, IDC_EDIT_GO, mytext);
				(mfd->G_offset) = (value<<8);

				value = SendDlgItemMessage (hdlg, IDC_SLIDER_BO, TBM_GETPOS, 0, 0);
				sprintf (mytext, "%d", value);
				SetDlgItemText (hdlg, IDC_EDIT_BO, mytext);
				(mfd->B_offset) = (value<<8);
				MakeLUT(mfd);
				mfd->ifp->RedoFrame();
				return TRUE;
            }
        case WM_COMMAND:
			{
				switch(LOWORD(wParam)) 
				{
					case IDOK:
						{
							long value;
							value = SendDlgItemMessage (hdlg, IDC_SLIDER_RA, TBM_GETPOS, 0, 0);
							(mfd->R_amp) = value;

							value = SendDlgItemMessage (hdlg, IDC_SLIDER_GA, TBM_GETPOS, 0, 0);
							(mfd->G_amp) = value;

							value = SendDlgItemMessage (hdlg, IDC_SLIDER_BA, TBM_GETPOS, 0, 0);
							(mfd->B_amp) = value;
							
							value = SendDlgItemMessage (hdlg, IDC_SLIDER_RO, TBM_GETPOS, 0, 0);
							(mfd->R_offset) = (value<<8);

							value = SendDlgItemMessage (hdlg, IDC_SLIDER_GO, TBM_GETPOS, 0, 0);
							(mfd->G_offset) = (value<<8);

							value = SendDlgItemMessage (hdlg, IDC_SLIDER_BO, TBM_GETPOS, 0, 0);
							(mfd->B_offset) = (value<<8);

							EndDialog(hdlg, 0);
							return TRUE;
						}
					case IDCANCEL:
						{
							EndDialog(hdlg, 1);
							return FALSE;
						}
					case IDC_BUTTON_RESET:
						{
							mfd->R_amp = 256;
							SendDlgItemMessage (hdlg, IDC_SLIDER_RA, TBM_SETPOS, true, mfd->R_amp);
							sprintf (mytext, "%.3f", float(mfd->R_amp)/256.0f);
							SetDlgItemText (hdlg, IDC_EDIT_RA, mytext);

							mfd->G_amp = 256;
							SendDlgItemMessage (hdlg, IDC_SLIDER_GA, TBM_SETPOS, true, mfd->G_amp);
							sprintf (mytext, "%.3f", float(mfd->G_amp)/256.0f);
							SetDlgItemText (hdlg, IDC_EDIT_GA, mytext);

							mfd->B_amp = 256;
							SendDlgItemMessage (hdlg, IDC_SLIDER_BA, TBM_SETPOS, true, mfd->B_amp);
							sprintf (mytext, "%.3f", float(mfd->B_amp)/256.0f);
							SetDlgItemText (hdlg, IDC_EDIT_BA, mytext);

							mfd->R_offset = 0;
							SendDlgItemMessage (hdlg, IDC_SLIDER_RO, TBM_SETPOS, true, (mfd->R_offset)/255);
							sprintf (mytext, "%.3f", mfd->R_offset);
							SetDlgItemText (hdlg, IDC_EDIT_RO, mytext);

							mfd->G_offset = 0;
							SendDlgItemMessage (hdlg, IDC_SLIDER_GO, TBM_SETPOS, true, (mfd->G_offset)/255);
							sprintf (mytext, "%.3f", mfd->G_offset);
							SetDlgItemText (hdlg, IDC_EDIT_GO, mytext);

							mfd->B_offset = 0;
							SendDlgItemMessage (hdlg, IDC_SLIDER_BO, TBM_SETPOS, true, (mfd->B_offset)/255);
							sprintf (mytext, "%.3f", mfd->B_offset);
							SetDlgItemText (hdlg, IDC_EDIT_BO, mytext);

							MakeLUT(mfd);
							mfd->ifp->RedoFrame();
							return FALSE;
						}
					case IDC_BUTTON_PREVIEW:
						{
							mfd->ifp->Toggle(hdlg);
							return FALSE;
						}
				}
				break;
			}
    }

    return FALSE;
}

int tutorialConfigProc(FilterActivation *fa, const FilterFunctions *ff, HWND hwnd) {
	MyFilterData *mfd = (MyFilterData *)fa->filter_data;
	mfd->ifp = fa->ifp;
    return DialogBoxParam(fa->filter->module->hInstModule,
            MAKEINTRESOURCE(IDD_FILTER_TUTORIAL), hwnd,
            tutorialConfigDlgProc, (LPARAM)fa->filter_data);
}

void tutorialStringProc(const FilterActivation *fa, const FilterFunctions *ff, char *str) {
	MyFilterData *mfd = (MyFilterData *)fa->filter_data;

	sprintf(str, " (red %.3f/%d, green %.3f/%d, blue %.3f/%d)",
				float(mfd->R_amp)/256, mfd->R_offset/255, float(mfd->G_amp)/256, mfd->G_offset/255, float(mfd->B_amp)/256, mfd->B_offset/255);
}

void tutorialScriptConfig(IScriptInterpreter *isi, void *lpVoid, CScriptValue *argv, int argc) {
    FilterActivation *fa = (FilterActivation *)lpVoid;
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;

    mfd->R_amp		= argv[0].asInt();
    mfd->G_amp		= argv[1].asInt();
	mfd->B_amp		= argv[2].asInt();
	mfd->R_offset	= argv[3].asInt();
	mfd->G_offset	= argv[4].asInt();
	mfd->B_offset	= argv[5].asInt();
//	mfd->FIRSTRUN	= argv[6].asInt();
}

bool tutorialFssProc(FilterActivation *fa, const FilterFunctions *ff, char *buf, int buflen) {
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;

    _snprintf(buf, buflen, "Config(%i, %i, %i, %i, %i, %i)",
        mfd->R_amp,
        mfd->G_amp,
		mfd->B_amp,
		mfd->R_offset,
		mfd->G_offset,
		mfd->B_offset);

    return true;
}

void MakeLUT(MyFilterData *mfd)
{
				if(mfd->LUT_R==NULL)
				{
					(mfd->LUT_R) = new unsigned char[256];
				}
				if(mfd->LUT_G==NULL)
				{
					(mfd->LUT_G) = new unsigned char[256];
				}
				if(mfd->LUT_B==NULL)
				{
					(mfd->LUT_B) = new unsigned char[256];
				}
				long i;
				long R_amp    = mfd->R_amp;
				long G_amp    = mfd->G_amp;
				long B_amp    = mfd->B_amp;
				long R_offset = (mfd->R_offset);
				long G_offset = (mfd->G_offset);
				long B_offset = (mfd->B_offset);
				long color;
				for(i=0;i<256;i++)
				{
					color=(i*R_amp + R_offset + 128)>>8;
					color= (color&0x80000000)? 0x00000000 : ((color&0x7FFFFF00)? 0x000000FF : (color&0x000000FF));
					(mfd->LUT_R[i])=(unsigned char)color;
					color=(i*G_amp + G_offset + 128)>>8;
					color= (color&0x80000000)? 0x00000000 : ((color&0x7FFFFF00)? 0x000000FF : (color&0x000000FF));
					(mfd->LUT_G[i])=(unsigned char)color;
					color=(i*B_amp + B_offset + 128)>>8;
					color= (color&0x80000000)? 0x00000000 : ((color&0x7FFFFF00)? 0x000000FF : (color&0x000000FF));
					(mfd->LUT_B[i])=(unsigned char)color;
				}
}