#ifndef _PGCOMMON
#define _PGCOMMON

#include <stdio.h>

typedef unsigned char uchar;
typedef unsigned short ushort;
typedef unsigned int uint;
typedef unsigned long ulong;

typedef signed char schar;
typedef signed short sshort;
typedef signed int sint;
typedef signed long slong;

typedef float real;

#ifndef _MSC_VER
typedef enum {false = 0, true = 1} bool;
#endif

#define pgmax(a,b)  (((a) > (b)) ? (a) : (b))
#define pgmin(a,b)  (((a) < (b)) ? (a) : (b))
#define pgabs(a)  (((a) >= 0) ? (a) : (-(a)))

#define bitmask(b) ((1<<(b))-1)
#define bitvalue(b) (1<<(b))
#define bitchk(n, bit) (((n) >> (7 - (bit))) & 1)

typedef int Fixed8;
typedef uint uFixed8;
typedef int Fixed16;
typedef uint uFixed16;

#define IntToFixed8(x) ((x)<<8)
#define Fixed8ToInt(x) ((x)>>8)
#define FloatToFixed8(x) ((int)((x)*256))
#define Fixed8ToFloat(x) ((float)(x)/256.0)

#define IntToFixed16(x) ((x)<<16)
#define Fixed16ToInt(x) ((x)>>16)
#define FloatToFixed16(x) ((int)((x)*65536))
#define Fixed16ToFloat(x) (float(x)/65536.0)

#define Fixed16ToFixed8(x) ((x)>>8)
#define Fixed8ToFixed16(x) ((x)<<8)

#define Fixed8Mul(x,y) ((x)*(y)>>8)
#define Fixed8Div(x,y) (((x)<<8)/(y))

#define Fixed16Mul(x,y) FloatToFixed16(Fixed16ToFloat(x)*Fixed16ToFloat(y))
#define Fixed16Div(x,y) FloatToFixed16(Fixed16ToFloat(x)/Fixed16ToFloat(y))


#endif
