// ConfigDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ConfigDlg.h"
#include "PicfixAboutDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigDlg dialog


CConfigDlg::CConfigDlg(int threshold, int quality, CWnd* pParent /*=NULL*/)
	: CDialog(CConfigDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConfigDlg)
	m_fSaveSettings = FALSE;
	m_threshold = 0;
	m_quality = 0;
	//}}AFX_DATA_INIT

	m_threshold = threshold;
	m_quality = quality;
}


void CConfigDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigDlg)
	DDX_Control(pDX, IDC_SLIDER2, m_qualityctrl);
	DDX_Control(pDX, IDC_SLIDER1, m_thresholdctrl);
	DDX_Check(pDX, IDC_CHECK1, m_fSaveSettings);
	DDX_Slider(pDX, IDC_SLIDER1, m_threshold);
	DDX_Slider(pDX, IDC_SLIDER2, m_quality);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConfigDlg, CDialog)
	//{{AFX_MSG_MAP(CConfigDlg)
	ON_BN_CLICKED(IDC_ABOUT, OnAbout)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigDlg message handlers

BOOL CConfigDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_fSaveSettings = AfxGetApp()->GetProfileInt("Config", "LoadSettingsOnNextRun", 0);
	UpdateData(FALSE);

	m_thresholdctrl.SetRange(0, 16, TRUE);
	m_qualityctrl.SetRange(0, 4, TRUE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CConfigDlg::OnAbout() 
{
	CPicfixAboutDlg().DoModal();
}

void CConfigDlg::OnOK() 
{
	UpdateData();

	if(m_fSaveSettings)
	{
		AfxGetApp()->WriteProfileInt("Config", "LoadSettingsOnNextRun", 1);
		AfxGetApp()->WriteProfileInt("Config", "Threshold", m_threshold);
		AfxGetApp()->WriteProfileInt("Config", "Quality", m_quality);
	}
	else
	{
		AfxGetApp()->WriteProfileInt("Config", "LoadSettingsOnNextRun", 0);
	}
	
	CDialog::OnOK();
}
