/*
NRS - "Noise reduction suite" filter for VirtualDub
Copyright (C) 2003 Antonio Foranna

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation.
	
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
		
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
			
The author can be contacted at:
kreel@tiscali.it
*/

#include <windows.h>
#include <crtdbg.h>
#include <stdlib.h>
#include "Cregistry.h"
#include "Define.h"
#include "Struct.h"
#include "Crop.h"
#include "Gamma.h"
#include "DNR.h"
#include "SmartBlur.h"
#include "Run.h"

//************************************************************************************************

void DeleteArray(void **buf)
{
	if(*buf)
	{
		free(*buf);
		*buf=NULL;
	}
}
//------------------------------------------------------------------------------------------------

CreateArray(void **buf, int size)
{
    if(!(*buf=malloc(size)))
	{
		MessageBox(0,"Error allocating memory",NULL,MB_OK);
        return 1;
	}
    memset(*buf, 0, size);
	return 0;
}

//************************************************************************************************
//										MAIN INIT
//************************************************************************************************

void InitFuncs(MyFilterData *mfd)
{
	if(!mfd->Use_crop && !mfd->Use_DNR && !mfd->Use_SB && !mfd->Use_gamma)
		mfd->pRunProc=RunCopy;
	else
		if(!mfd->Use_DNR && !mfd->Use_SB && !mfd->Use_gamma)
		{
			if(mfd->dst_width==mfd->wnc)
				mfd->pRunProc=RunShiftY;
			else
				mfd->pRunProc=RunCrop;
		}
		else
		{
			if(g_MMXenabled)
			{
				mfd->pGammaLine=GammaLineAsm;
				mfd->pBlurShowEdgesLine=BlurShowEdgesLineMMX;
				if(!mfd->SharpenEdges)
					mfd->pBlurLine=BlurLineMMX;
				else
					mfd->pBlurLine=BlurSharpenLineMMX;
				if(mfd->UseDnrMultiPass)
//					pDNRline=DNRlineMP_MMX;
					mfd->pDNRline=DNRlineMP;
				else
					mfd->pDNRline=DNRlineMMX;
			}
			else
			{
				mfd->pBlurShowEdgesLine=BlurShowEdgesLine;
				mfd->pGammaLine=GammaLine;
				mfd->pBlurLine=BlurLine;
				if(mfd->UseDnrMultiPass)
					mfd->pDNRline=DNRlineMP;
				else
					mfd->pDNRline=DNRline;
			}
			if(!mfd->Use_DNR && !mfd->Use_SB)
				mfd->pRunProc=RunGamma;
			else
				if(!mfd->Use_SB || mfd->dst_width<(mfd->radius<<1)+1)
					mfd->pRunProc=RunDNR_gamma;
				else
					mfd->pRunProc=RunBlur;
		}
}

//************************************************************************************************
//									MAIN FUNCS
//************************************************************************************************

int RunCopy(DWORD *dst, DWORD *src, MyFilterData *mfd)
{
	memcpy(dst,src,mfd->sizeSrc);
	return 0;
}
//************************************************************************************************

int RunShiftY(DWORD *dst, DWORD *src, MyFilterData *mfd)
{
	memcpy(	dst+mfd->dst_shift,
			src+mfd->src_shift,
			mfd->dst_sizeSY);
	return 0;
}
//************************************************************************************************

int RunCrop(DWORD *dst, DWORD *src, MyFilterData *mfd)
{
long	yOffset=mfd->dst_heigth,
		dst_width=mfd->dst_width<<2,
		dst_heigth=mfd->dst_heigth;
WORD	ImageWidthSrc=(WORD)mfd->wnc;

	if(!dst_heigth || !dst_width)
		return 0;

	src+=mfd->src_shift;
	dst+=mfd->dst_shift;
	do
	{
		memcpy(dst,src,dst_width);
		src+=ImageWidthSrc;
		dst+=ImageWidthSrc;
	}while(--yOffset);

	return 0;
}
//************************************************************************************************

int RunGamma(DWORD *dst, DWORD *src, MyFilterData *mfd)
{
long	xOffset=mfd->dst_width,
		yOffset=mfd->dst_heigth,
		dst_width=mfd->dst_width,
		dst_heigth=mfd->dst_heigth,
		ImageWidth=mfd->wnc,
		xGap=ImageWidth+mfd->xGap;
BYTE	*pGamma=mfd->pGamma->GammaCorrection;

	if(!dst_heigth || !dst_width)
		return 0;

	src+=mfd->src_shift;
	dst+=mfd->dst_shift;

	do
	{
		GammaLine(src,dst,pGamma,dst_width);
		src+=ImageWidth;
		dst+=ImageWidth;
	}while(--yOffset);

	return 0;
}
//************************************************************************************************

int RunDNR_gamma(DWORD *pdst, DWORD *psrc, MyFilterData *mfd)
{
WORD	ImageWidthSrc=mfd->wnc;

DWORD	*src=psrc, *dst=pdst;

// DNR
DWORD	*pLogThresholdDNR=mfd->pLogThresholdDNR;
DWORD	*DiffAcc=mfd->DiffAcc;
DWORD	*old=(DWORD *)mfd->old_data,
		*sav=(DWORD *)mfd->sav_data;

DWORD	SCDaccum=0;

// Crop
long	yOffset=mfd->dst_heigth,
		dst_width=mfd->dst_width,
		dst_heigth=mfd->dst_heigth;

// pGamma correction
BYTE	*pGamma=mfd->pGamma->GammaCorrection;

BYTE	UseGamma=mfd->Use_gamma,
		UseDNR=mfd->Use_DNR;
BYTE	show_blended=UseDNR && mfd->show_blended;
BYTE	*Yold=mfd->Yold;

	if(!dst_heigth || !dst_width)
		return 0;

	src+=mfd->src_shift;
	dst+=mfd->dst_shift;
	if(UseDNR)
	{
		if(!mfd->sav_data)
			return 0;
		old+=mfd->src_shift;
		if(UseGamma)
			sav+=mfd->src_shift;
		else
			sav=src;
		if(mfd->UseDnrMultiPass)
			RGB2Y(mfd);
		Yold+=mfd->src_shift;
/*	DWORD nop=mfd->sizeSrc>>2;
		dst=fa->dst.data;
		Yold=mfd->Yold;
		while(nop--)
		{
			*dst++=*Yold|(*Yold<<8)|(*Yold<<16);
			Yold++;
		}
		return 0;*/
	}

	do
	{
		if(UseDNR)
		{
			if(UseGamma)
				mfd->pGammaLine(src,sav,pGamma,dst_width);
			SCDaccum+=mfd->pDNRline(sav,dst,old,DiffAcc,pLogThresholdDNR,dst_width,mfd,dst_heigth-yOffset,Yold);
			old+=ImageWidthSrc;
			sav+=ImageWidthSrc;
			DiffAcc+=dst_width;
			Yold+=ImageWidthSrc;
		}
		else
			mfd->pGammaLine(src,dst,pGamma,dst_width);
		src+=ImageWidthSrc;
		dst+=ImageWidthSrc;
	}while(--yOffset);

	if(UseDNR)
		if(SCDaccum>mfd->SCD_NumOfPixels)
		{
			if(UseGamma)
				src=(DWORD *)mfd->sav_data+mfd->src_shift;
			else
				src=psrc+mfd->src_shift;
			dst=pdst+mfd->dst_shift;
			yOffset=dst_heigth;
			dst_width=mfd->dst_width<<2;
			do
			{
				memcpy(dst,src,dst_width);
				src+=ImageWidthSrc;
				dst+=ImageWidthSrc;
			}while(--yOffset);
			memcpy(mfd->old_data,psrc,mfd->sizeSrc);
			memset(mfd->DiffAcc,0,mfd->DiffAccSize); 
		}
		else
			if(show_blended)
			{
			DWORD	xOffset=mfd->dst_width;
			DWORD	xGap=mfd->xGap;
			BYTE	*bEdgesMask=mfd->EdgesMask;
			BYTE	Show_DNR_edges=mfd->UseDnrMultiPass && mfd->show_DNR_edges;
				dst_width=mfd->dst_width;
				xOffset=dst_width;
				yOffset=dst_heigth;
				dst=pdst+mfd->dst_shift;
				if(Show_DNR_edges)
				{
					bEdgesMask=mfd->EdgesMask+mfd->src_shift;
					do
					{
						do
						{
							*dst++=*bEdgesMask++ ? 0 : 0x00ffffff;
						}while(--xOffset);
						bEdgesMask+=xGap;
						dst+=xGap;
						xOffset=dst_width;
					}while(--yOffset);
				}
				else
				{
					if(UseGamma)
						src=(DWORD *)mfd->sav_data+mfd->src_shift;
					else
						src=psrc+mfd->src_shift;
					do
					{
						do
						{
							*dst++=((*src&0x00ffffff)==(*dst&0x00ffffff)) ? 0x00ffffff : 0;
							src++;
						}while(--xOffset);
						src+=xGap;
						dst+=xGap;
						xOffset=dst_width;
					}while(--yOffset);
				}
			}

	return 0;
}
//************************************************************************************************

int RunBlur(DWORD *pdst, DWORD *psrc, MyFilterData *mfd)
{
BYTE	*pGamma=mfd->pGamma->GammaCorrection;

DWORD	*src=psrc, *dst=pdst;

// Crop
const WORD	dst_heigth=(WORD)mfd->dst_heigth;
DWORD	dst_width=mfd->dst_width;
DWORD	xOffset=dst_width,
		yOffset=dst_heigth;

// SB
const BYTE	show_edges=mfd->show_edges;
const BYTE	Interlaced=mfd->Interlaced;

const DWORD	*pLogThresholdSB=mfd->pLogThresholdSB;
BYTE	*pMinx=mfd->LUTminx,
		*pMaxx=mfd->LUTmaxx,
		*pMiny=mfd->LUTminy,
		*pMaxy=mfd->LUTmaxy;
BYTE	*bCenterOfWeight=mfd->pCenterOfWeight;

const BYTE	radius=mfd->radius,
			radiusx2=radius<<1,
			diameter=radiusx2+1;
const WORD	ImageWidthSrc=mfd->wnc;
const DWORD	ImageWidthx4=ImageWidthSrc<<2,
		in_width=dst_width-radiusx2,
		xGap=mfd->xGap,
		xGapNear=(((ImageWidthSrc<<Interlaced)-diameter+radius)<<2);
//		minxminyImageWidthx4=(radius+(radius<<Interlaced)*ImageWidth)<<2;
const BYTE	radiusy=radius<<Interlaced;
BYTE	show_blended=mfd->Use_DNR && mfd->show_blended;
BYTE	*Yold=mfd->Yold;

	if(!radius || !dst_heigth || !dst_width || dst_width<diameter)
		return 0;

	src+=mfd->src_shift;
	dst+=mfd->dst_shift;

	if(show_edges)
	{
		do
		{
			mfd->pBlurShowEdgesLine(src,dst,(DWORD *)bCenterOfWeight,pLogThresholdSB,
									diameter,*pMiny+*pMaxy,*pMiny*diameter,(*pMiny*ImageWidthx4)<<Interlaced,
									xGapNear,dst_width,mfd,pMiny,pMaxy);
			src+=ImageWidthSrc;
			dst+=ImageWidthSrc;
			pMiny++;
			pMaxy++;
		}while(--yOffset);
		return 0;
	}

// Init 4 DNR

	if(mfd->Use_DNR)
	{
	const DWORD	*pLogThresholdDNR=mfd->pLogThresholdDNR;
	DWORD	*DiffAcc=mfd->DiffAcc,
			*old,
			*sav;
	DWORD	SCDaccum=0;
	BYTE	UseGamma=mfd->Use_gamma;

		if(!mfd->sav_data)
			return 0;
		old=(DWORD *)mfd->old_data+mfd->src_shift;
		sav=(DWORD *)mfd->sav_data+mfd->src_shift;

		if(mfd->UseDnrMultiPass)
			RGB2Y(mfd);
		Yold+=mfd->src_shift;
/*	DWORD nop=mfd->sizeSrc>>2;
		dst=fa->dst.data;
		Yold=mfd->Yold;
		while(nop--)
		{
			*dst++=*Yold|(*Yold<<8)|(*Yold<<16);
			Yold++;
		}
		return 0;*/

		do
		{
			mfd->pBlurLine(	src,sav,(DWORD *)bCenterOfWeight,pLogThresholdSB,
							diameter,*pMiny+*pMaxy,*pMiny*diameter,(*pMiny*ImageWidthx4)<<Interlaced,
							xGapNear,in_width,mfd,yOffset,pMiny,pMaxy);
			if(mfd->Use_gamma)
				mfd->pGammaLine(sav,sav,pGamma,dst_width);
			SCDaccum+=mfd->pDNRline(sav,dst,old,DiffAcc,pLogThresholdDNR,dst_width,mfd,dst_heigth-yOffset,Yold);
			src+=ImageWidthSrc;
			dst+=ImageWidthSrc;
			sav+=ImageWidthSrc;
			old+=ImageWidthSrc;
			DiffAcc+=dst_width;
			Yold+=ImageWidthSrc;
			pMiny++;
			pMaxy++;
		}while(--yOffset);

		if(mfd->Use_DNR)
			if(SCDaccum>mfd->SCD_NumOfPixels)
			{
				src=((DWORD *)mfd->sav_data)+mfd->src_shift;
				dst=pdst+mfd->dst_shift;
				yOffset=dst_heigth;
				dst_width<<=2;
				do
				{
					memcpy(dst,src,dst_width);
					src+=ImageWidthSrc;
					dst+=ImageWidthSrc;
				}while(--yOffset);
				memcpy(mfd->old_data,mfd->sav_data,mfd->sizeSrc);
				memset(mfd->DiffAcc,0,mfd->DiffAccSize); 
			}
			else
				if(show_blended)
				{
				DWORD	xOffset=mfd->dst_width;
				DWORD	xGap=mfd->xGap;
				BYTE	*bEdgesMask=mfd->EdgesMask;
				BYTE	Show_DNR_edges=mfd->UseDnrMultiPass && mfd->show_DNR_edges;
					dst_width=mfd->dst_width;
					xOffset=dst_width;
					yOffset=dst_heigth;
					dst=pdst+mfd->dst_shift;
					if(Show_DNR_edges)
						bEdgesMask=mfd->EdgesMask+mfd->src_shift;
					else
						src=(DWORD *)mfd->sav_data+mfd->src_shift;
					do
					{
						do
						{
							if(Show_DNR_edges)
								*dst=*bEdgesMask++ ? 0 : 0x00ffffff;
							else
							{
								*dst=(*src&0x00ffffff)==(*dst&0x00ffffff) ? 0x00ffffff : 0;
								src++;
							}
							dst++;
						}while(--xOffset);
						if(Show_DNR_edges)
							bEdgesMask+=xGap;
						else
							src+=xGap;
						dst+=xGap;
						xOffset=dst_width;
					}while(--yOffset);
				}
	}
	else
		do
		{
			mfd->pBlurLine(	src,dst,(DWORD *)bCenterOfWeight,pLogThresholdSB,
							diameter,*pMiny+*pMaxy,*pMiny*diameter,(*pMiny*ImageWidthx4)<<Interlaced,
							xGapNear,in_width,mfd,yOffset,pMiny,pMaxy);
			if(mfd->Use_gamma)
				mfd->pGammaLine(dst,dst,pGamma,dst_width);
			src+=ImageWidthSrc;
			dst+=ImageWidthSrc;
			pMiny++;
			pMaxy++;
		}while(--yOffset);

	return 0;
}
