/*
    Bit Drop 0.9 beta

	Masks the LSB(s) of the R,G and B values.
	Simple to do and could be used as a simple noise filter or an
	effects one!

    Copyright (C) 2000 Simon Walters 
	
	Based on code by Avery Lee, Jim Casaburi, Gunnar Thalin and Donald Graft.
	(more like copied bit for bit really -  99.9% them 0.1% me)
	Inital impetus to writing filters given by Donald Graft.
		

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	The author can be contacted at:
	Simon Walters
	siwalters@hotmail.com

	New versions of the source code and the compiled filter can be 
	found at http://www.geocities.com/siwalters_uk/virtualdub/filters.htm
*/

#include "filter.h"
#include "resource.h"
#include "ScriptError.h"
#include "ScriptInterpreter.h"
#include "ScriptValue.h"
#include "stdio.h"

// Added to use Donald Graft's Dialog Box
#include <windows.h>
#include <commctrl.h>
#include <crtdbg.h>


///////////////////////
static int tutorialRunProc(const FilterActivation *fa, const FilterFunctions *ff);
static int tutorialInitProc(FilterActivation *fa, const FilterFunctions *ff);
static int tutorialStartProc(FilterActivation *fa, const FilterFunctions *ff);
static int tutorialEndProc(FilterActivation *fa, const FilterFunctions *ff);
static int tutorialConfigProc(FilterActivation *fa, const FilterFunctions *ff, HWND hwnd);
static void tutorialStringProc(const FilterActivation *fa, const FilterFunctions *ff, char *buf); 
static bool tutorialFssProc(FilterActivation *fa, const FilterFunctions *ff, char *buf, int buflen);
static void tutorialScriptConfig(IScriptInterpreter *isi, void *lpVoid, CScriptValue *argv, int argc); 

static void SetDialogBits(unsigned char Mask0, unsigned char Mask1, HWND hdlg);
static void ReadDialogBits(int *Mask0, int *Mask1, HWND hdlg);

typedef struct MyFilterData {
	IFilterPreview		*ifp;  // Sometting to do with preview
   int Mask0; // Zero Mask
	int Mask1;
    } MyFilterData;




//Script code????


ScriptFunctionDef tutorial_func_defs[]={
    { (ScriptFunctionPtr)tutorialScriptConfig, "Config", "0ii" },
    { NULL },
};
// the above set for 1 integer parameters



CScriptObject tutorial_obj={
    NULL, tutorial_func_defs
};



///////////////////////////////
struct FilterDefinition filterDef_tutorial = {

    NULL, NULL, NULL,			// next, prev, module
    "Bit Drop 0.9 beta",				    // name
    "Masks LSB(s) of R,G and B Values.",	// desc
    "Simon Walters",								// maker
    NULL,						// private_data
    sizeof(MyFilterData),		// inst_data_size

	tutorialInitProc,								// initProc
   NULL,												// deinitProc
   tutorialRunProc,								// runProc
   NULL,												// paramProc
	tutorialConfigProc,							// configProc
   tutorialStringProc,							// stringProc
    NULL,											// startProc
    NULL,											// endProc

    &tutorial_obj,				// script_obj
    tutorialFssProc,			// fssProc


};


///////////////////////////////////////////////////////////////


extern "C" int __declspec(dllexport) __cdecl VirtualdubFilterModuleInit2(FilterModule *fm, const FilterFunctions *ff, int& vdfd_ver, int& vdfd_compat);
extern "C" void __declspec(dllexport) __cdecl VirtualdubFilterModuleDeinit(FilterModule *fm, const FilterFunctions *ff);

static FilterDefinition *fd_tutorial;
////////////////////////////////////////////////////////////

int __declspec(dllexport) __cdecl VirtualdubFilterModuleInit2(FilterModule *fm, const FilterFunctions *ff, int& vdfd_ver, int& vdfd_compat) {
    if (!(fd_tutorial = ff->addFilter(fm, &filterDef_tutorial, sizeof(FilterDefinition))))
        return 1;

    vdfd_ver    = VIRTUALDUB_FILTERDEF_VERSION;
    vdfd_compat = VIRTUALDUB_FILTERDEF_COMPATIBLE;

    return 0;
}

void __declspec(dllexport) __cdecl VirtualdubFilterModuleDeinit(FilterModule *fm, const FilterFunctions *ff) {
    ff->removeFilter(fd_tutorial);
}

//////////////////////////////////////
static int tutorialRunProc(const FilterActivation *fa, const FilterFunctions *ff) {
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;
    PixDim w, h;
    Pixel32 *src, *dst;
	Pixel32 RGBMask0 = (mfd->Mask0 << 16) + (mfd->Mask0 << 8) + mfd->Mask0;
	Pixel32 RGBMask1 = (mfd->Mask1 << 16) + (mfd->Mask1 << 8) + mfd->Mask1;

    src = (Pixel32 *)fa->src.data;
    dst = (Pixel32 *)fa->dst.data;


    h = fa->src.h;
	do {
        w = fa->src.w;

        do {

			*dst = (*src) & RGBMask0;
			*dst = (*dst) | RGBMask1;
			*dst++;
			*src++;


        } while(--w);

        src = (Pixel32 *)((char *)src + fa->src.modulo);
        dst = (Pixel32 *)((char *)dst + fa->dst.modulo);
    } while(--h);

    return 0;
}


static int tutorialInitProc(FilterActivation *fa, const FilterFunctions *ff) {
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;

	mfd->Mask0 = 255;
	mfd->Mask1 = 0;
    

    return 0;
}

static int tutorialStartProc(FilterActivation *fa, const FilterFunctions *ff) {
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;

	  

    return 0;
}

static int tutorialEndProc(FilterActivation *fa, const FilterFunctions *ff) {
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;

    
    return 0;
}

BOOL CALLBACK tutorialConfigDlgProc(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam) {
	MyFilterData *mfd = (MyFilterData *)GetWindowLong(hdlg, DWL_USER);

	switch(msg) {
		case WM_INITDIALOG:
			SetWindowLong(hdlg, DWL_USER, lParam);
			mfd = (MyFilterData *)lParam;
//			HWND hWnd;

			SetDlgItemInt(hdlg, IDC_EDIT_MASK1, mfd->Mask1, FALSE);
			SetDlgItemInt(hdlg, IDC_EDIT_MASK0, mfd->Mask0, FALSE);
			SetDialogBits(mfd->Mask0,mfd->Mask1,hdlg);
								
			mfd->ifp->InitButton(GetDlgItem(hdlg, IDPREVIEW));

			return TRUE;
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
			case IDPREVIEW:
				mfd->ifp->Toggle(hdlg);
				break;
			case IDOK:
				EndDialog(hdlg, 0);
				return TRUE;
			/*
			case IDHELP:
				{
				char prog[256];
				char path[256];
				LPTSTR ptr;
				GetModuleFileName(NULL, prog, 255);
				GetFullPathName(prog, 255, path, &ptr);
				*ptr = 0;
				strcat(path, "plugins\\Unsharp.txt");
				OutputDebugString(path);
				OutputDebugString("\n");
				strcpy(prog, "Notepad ");
				strcat(prog, path);
				WinExec(prog, SW_SHOW);
				return TRUE;
				}
			*/
			case IDCANCEL:
				EndDialog(hdlg, 1);
				return TRUE;
			case IDC_RADIO11:
				SetDlgItemInt(hdlg, IDC_RADIO11, IDC_RADIO11, 0);
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO21:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO31:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO41:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO51:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO61:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO71:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO81:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO10:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO20:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO30:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO40:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO50:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO60:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO70:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO80:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO1:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO2:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO3:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO4:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO5:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO6:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO7:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			case IDC_RADIO8:
				ReadDialogBits(&mfd->Mask0, &mfd->Mask1, hdlg);
				mfd->ifp->RedoFrame();
				break;
			}
			break;
	}

	return FALSE;
}


static int tutorialConfigProc(FilterActivation *fa, const FilterFunctions *ff, HWND hwnd)
{
	MyFilterData *mfd = (MyFilterData *) fa->filter_data;
	MyFilterData mfd_old = *mfd;
	int ret;

	mfd->ifp = fa->ifp;
	if (DialogBoxParam(fa->filter->module->hInstModule,
			MAKEINTRESOURCE(IDD_FILTER), hwnd,
			tutorialConfigDlgProc, (LPARAM) mfd))
	{
		*mfd = mfd_old;
		ret = TRUE;
	}
	else
	{
		ret = FALSE;
	}
	return(ret);
}




static void tutorialStringProc(const FilterActivation *fa, const FilterFunctions *ff, char *str) {

    MyFilterData *mfd = (MyFilterData *)fa->filter_data;
	
	// write the parameters to a string 
	sprintf(str, "(0 Mask: %d, 1 Mask: %d )",  mfd->Mask0,mfd->Mask1);
}

//Script/Batch Handling Code


static bool tutorialFssProc(FilterActivation *fa, const FilterFunctions *ff, char *buf, int buflen) {
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;

	// Write the two parameters to a string 
    _snprintf(buf, buflen, "Config(%d %d)",
        mfd->Mask0, mfd->Mask1);

    return true;
}


static void tutorialScriptConfig(IScriptInterpreter *isi, void *lpVoid, CScriptValue *argv, int argc) {
    FilterActivation *fa = (FilterActivation *)lpVoid;
    MyFilterData *mfd = (MyFilterData *)fa->filter_data;
	// Extract the parameters from the arguments provided
    mfd->Mask0   = argv[0].asInt();
    mfd->Mask1   = argv[1].asInt();
}

static void SetDialogBits(unsigned char Mask0, unsigned char Mask1, HWND hdlg) {
	SendMessage(GetDlgItem(hdlg, IDC_RADIO1), BM_CLICK, 0, 0);
	SendMessage(GetDlgItem(hdlg, IDC_RADIO2), BM_CLICK, 0, 0);
	SendMessage(GetDlgItem(hdlg, IDC_RADIO3), BM_CLICK, 0, 0);
	SendMessage(GetDlgItem(hdlg, IDC_RADIO4), BM_CLICK, 0, 0);
	SendMessage(GetDlgItem(hdlg, IDC_RADIO5), BM_CLICK, 0, 0);
	SendMessage(GetDlgItem(hdlg, IDC_RADIO6), BM_CLICK, 0, 0);
	SendMessage(GetDlgItem(hdlg, IDC_RADIO7), BM_CLICK, 0, 0);
	SendMessage(GetDlgItem(hdlg, IDC_RADIO8), BM_CLICK, 0, 0);
	if (Mask1 & 1) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO11);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
		else if ((Mask0 & 1)==0) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO10);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
	if (Mask1 & 2) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO21);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
	else if ((Mask0 & 2)==0) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO20);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
	if (Mask1 & 4) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO31);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
	else if ((Mask0 & 4)==0) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO30);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
	if (Mask1 & 8) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO41);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
	else if ((Mask0 & 8)==0) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO40);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
	if (Mask1 & 16) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO51);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
	else if ((Mask0 & 16)==0) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO50);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
	if (Mask1 & 32) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO61);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
	else if ((Mask0 & 32)==0) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO60);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
	if (Mask1 & 64) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO71);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
	else if ((Mask0 & 64)==0) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO70);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
	if (Mask1 & 128) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO81);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
	else if ((Mask0 & 128)==0) {
		HWND hWnd = GetDlgItem(hdlg, IDC_RADIO80);
		SendMessage(hWnd, BM_CLICK, 0, 0);
	}
	//

}


static void ReadDialogBits(int *Mask0, int *Mask1, HWND hdlg)	{
	*Mask0 = 255;
	*Mask1 = 0;

	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO11), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask1 = *Mask1 + 1;

		}
	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO21), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask1 = *Mask1 + 2;

		}
	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO31), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask1 = *Mask1 + 4;

		}
	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO41), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask1 = *Mask1 + 8;

		}
	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO51), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask1 = *Mask1 + 16;

		}
	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO61), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask1 = *Mask1 + 32;

		}
	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO71), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask1 = *Mask1 + 64;

		}
	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO81), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask1 = *Mask1 + 128;

		}
	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO10), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask0 = *Mask0 - 1;

		}
	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO20), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask0 = *Mask0 - 2;

		}
	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO30), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask0 = *Mask0 - 4;

		}
	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO40), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask0 = *Mask0 - 8;

		}
	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO50), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask0 = *Mask0 - 16;

		}
	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO60), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask0 = *Mask0 - 32;

		}
	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO70), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask0 = *Mask0 - 64;

		}
	if (SendMessage(GetDlgItem(hdlg, IDC_RADIO80), BM_GETCHECK, 0,0) == BST_CHECKED) {
		*Mask0 = *Mask0 - 128;
		}
		SetDlgItemInt(hdlg, IDC_EDIT_MASK0,*Mask0,FALSE);
		SetDlgItemInt(hdlg, IDC_EDIT_MASK1,*Mask1,FALSE);
}
