/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : cliprect.c
// Description:  do rectangle clipping for bitbilt and block copy routines
// Create Date:  1997. 1. 13
// Modification(date/where): 
//
// ****************************************************************

#define _IMG_LIBBUILD_
#include "image.h"

// Do rectangle clipping 
// where (src_xsz, src_ysz) and (des_xsz, des_ysz) is size of source and destination area
//   (xsts,ysts) is the start point in source block (can be negtive)
//   (xstd, ystd) is the destination location (can be negtive)
//   (xblk, yblk) is the size of expected rectangle block
// return ITRUE if successful
//        IFALSE if no overlap

IBOOL __clip_rect(int src_xsz, int src_ysz, int des_xsz, int des_ysz, 
                 int *xsts, int *ysts, int *xstd, int *ystd, int *xblk, int *yblk)
{                 
   // do x clip 
   if(*xsts < 0) { 
      *xblk += *xsts; *xstd -= *xsts; *xsts = 0; 
      if(*xblk <= 0) return IFALSE;   // no overlay
   }

   if(*xstd < 0) { 
      *xsts -= *xstd; *xblk += *xstd; *xstd = 0; 
      if(*xblk <= 0) return IFALSE;   // no overlay
   }

   if(*xsts + *xblk > src_xsz) {
      *xblk = src_xsz - *xsts;
      if(*xblk <= 0) return IFALSE;   // no overlay
   }
   
   if(*xstd + *xblk > des_xsz) {
      *xblk = des_xsz - (*xstd);
      if(*xblk <= 0) return IFALSE;   // no overlay
   }


   // do y clip 
   if(*ysts < 0) { 
      *yblk += *ysts; *ystd -= *ysts; *ysts = 0; 
      if(*yblk <= 0) return IFALSE;   // no overlay
   }

   if(*ystd < 0) { 
      *ysts -= *ystd; *yblk += *ystd; *ystd = 0; 
      if(*yblk <= 0) return IFALSE;   // no overlay
   }

   if(*ysts + *yblk > src_ysz) {
      *yblk = src_ysz - *ysts;
      if(*yblk <= 0) return IFALSE;   // no overlay
   }
   
   if(*ystd + *yblk > des_ysz) {
      *yblk = des_ysz - (*ystd);
      if(*yblk <= 0) return IFALSE;   // no overlay
   }
   
   return ITRUE;  // done clip
}

