/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : colorpre.c
// Description:  routines do color preprocess
// Create Date:  1996. 10. 1
//
//****************************************************************
#include <stdlib.h>
#include <float.h>
#include <math.h>
#define _IMG_LIBBUILD_
#include "image.h"


void color_unify(IBYTE *cr, IBYTE *cg, IBYTE *cb, int xsize, int ysize)
{
  int i,j;
  int offset;
  int cvl;
  
  for(j=0, offset=0; j<ysize; j++) {
    for(i=0; i<xsize; i++) {
       cvl = (int)(100.0*sqrt((double)((int)cr[offset]*cr[offset]+
                                       (int)cg[offset]*cg[offset]+
                                       (int)cb[offset]*cb[offset] )));
       if(cvl < 1000) cr[offset] = cg[offset] = cb[offset] = 0;
       else {
         cr[offset] = (IBYTE)((int)cr[offset]*25500/cvl);
         cg[offset] = (IBYTE)((int)cg[offset]*25500/cvl);
         cb[offset] = (IBYTE)((int)cb[offset]*25500/cvl);
        } 
       offset++;
      }
     }
  return;
}


short diffcolor(IBYTE r1, IBYTE g1, IBYTE b1, IBYTE r2, IBYTE g2, IBYTE b2) 
{ 
/*  long kval;
  if(!r1 && !g1 && !b1) 
    if(!r2 && !g2 && !b2) return 0;
    else return ((IWORD)r2+g2+b2)/3;
  else if(!r2 && !g2 && !b2)
    if(!r1 && !g1 && !b1) return 0;
    else return ((IWORD)r1+g1+b1)/3;
    
//  kval = 255-(((long)r1*r2+(long)g1*g2+(long)b1*b2)>>8);
  kval = abs(r1-r2)+abs(g1-g2)+abs(b1-b2);
  return abs(kval);
*/
  return abs(r1-r2)+abs(g1-g2)+abs(b1-b2);
}        
