/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : convfilt.c
// Description:  routines do convolution
// Create Date:  1996. 9. 11
// Modification(date/where):   1996.  10. 1 reformatted as standard
//
// ****************************************************************

#include <stdlib.h>
#include <string.h>
#include <math.h>
#define _IMG_LIBBUILD_
#include "image.h"
#include "routines.h"



// calculate 3x3 pixel matrix address index
//  0 1 2
//  7 8 3
//  6 5 4
void store_addr3x3(int addr[9], int xsize)
{
	addr[0] = -1-xsize;         //  (x-1, y-1)
	addr[1] =  0-xsize;         //  (x,   y-1)
	addr[2] =  1-xsize;         //  (x+1, y-1)
	addr[3] =  1;               //  (x+1, y  )
	addr[4] =  1+xsize;         //  (x+1, y+1)
	addr[5] =  0+xsize;         //  (x,   y+1)
	addr[6] = -1+xsize;         //  (x-1, y+1)
	addr[7] = -1;               //  (x-1, y  )
	addr[8] =  0;               //  (x,   y  )
}

// calculate 5x5 pixel matrix address index
//  0  1  2  3  4
// 15 16 17 18  5
// 14 23 24 19  6
// 13 22 21 20  7
// 12 11 10  9  8
void store_addr5x5(int addr[25], int xsize)
{
	addr[ 0] = -2-xsize*2;         //  (x-2, y-2)
	addr[ 1] = -1-xsize*2;         //  (x-1, y-2)
	addr[ 2] =  0-xsize*2;         //  (x,   y-2)
	addr[ 3] =  1-xsize*2;         //  (x+1, y-2)
	addr[ 4] =  2-xsize*2;         //  (x+2, y-2)
	addr[ 5] =  2-xsize;           //  (x+2, y-1)
	addr[ 6] =  2;                 //  (x+2, y  )
	addr[ 7] =  2+xsize;           //  (x+2, y+1)
	addr[ 8] =  2+xsize*2;         //  (x+2, y+2)
	addr[ 9] =  1+xsize*2;         //  (x+1, y+2)
	addr[10] =  0+xsize*2;         //  (x,   y+2)
	addr[11] = -1+xsize*2;         //  (x-1, y+2)
	addr[12] = -2+xsize*2;         //  (x-2, y+2)
	addr[13] = -2+xsize;           //  (x-2, y+1)
	addr[14] = -2;                 //  (x-2, y  )
	addr[15] = -2-xsize;           //  (x-2, y-1)
	addr[16] = -1-xsize;           //  (x-1, y-1)
	addr[17] =  0-xsize;           //  (x,   y-1)
	addr[18] =  1-xsize;           //  (x+1, y-1)
	addr[19] =  1;                 //  (x+1, y  )
	addr[20] =  1+xsize;           //  (x+1, y+1)
	addr[21] =  0+xsize;           //  (x,   y+1)
	addr[22] = -1+xsize;           //  (x-1, y+1)
	addr[23] = -1;                 //  (x-1, y  )
	addr[24] =  0;                 //  (x  , y  )
}



// do 3x3 convolution
//  where src is a img matrix convolution matrix must
void convolution3x3(IBYTE  *src, short int *des, short int mtx[9], int xsize, int ysize)
{
  register short int acc;
  register int k;
  register int i,j;
  int addr[9];
  int offset;

    store_addr3x3(addr, xsize);
    offset = xsize;
    for(j=1; j<ysize-1; j++) {
      for(i=1; i<xsize-1; i++) {
	 for(k=0, acc=0; k<9; k++) acc += (short int)((IWORD)src[offset+i+addr[k]])*mtx[k];
         des[offset+i] = acc;
       }
      offset += xsize;
     }
    return;
}

void blank_frame(void *buf, int xsize, int ysize, int elmsz) 
{  register int offset, i;
   switch(elmsz) {
     case sizeof(IBYTE):
       { IBYTE *des = (IBYTE *)buf;
         offset = xsize*(ysize-1);
         for(i=0; i<xsize; i++) des[i] = des[i+xsize], des[offset+i] = des[offset+i-xsize];
         for(i=0; i<ysize; i++) des[i*xsize] = des[i*xsize+1], des[i*xsize+xsize-1] = des[i*xsize+xsize-2];
       }
       break;
     case sizeof(IWORD):
       { IWORD *des = (IWORD *)buf;
	 offset = xsize*(ysize-1);
	 for(i=0; i<xsize; i++) des[i] = des[i+xsize], des[offset+i] = des[offset+i-xsize];
	 for(i=0; i<ysize; i++) des[i*xsize] = des[i*xsize+1], des[i*xsize+xsize-1] = des[i*xsize+xsize-2];
       }
       break;
     case sizeof(IDWORD):
       { IDWORD *des = (IDWORD *)buf;
	 offset = xsize*(ysize-1);
	 for(i=0; i<xsize; i++) des[i] = des[i+xsize], des[offset+i] = des[offset+i-xsize];
         for(i=0; i<ysize; i++) des[i*xsize] = des[i*xsize+1], des[i*xsize+xsize-1] = des[i*xsize+xsize-2];
       }
       break;
   }
}

void self_convolution3x3(IBYTE  *src, short int mtx[9], short int divisor, int xsize, int ysize)
{
  register short int acc;
  register int k;
  register int i,j;
  int addr[9];
  int offset, offset1;

    if(!divisor || xsize < 3 || ysize < 3) return;
    store_addr3x3(addr, xsize);
    offset = xsize; offset1 = 0;
    for(j=1; j<ysize-1; j++) {
      for(i=1; i<xsize-1; i++) {
	 for(k=0, acc=0; k<9; k++) acc += (short int)((IWORD)src[offset+i+addr[k]])*mtx[k];
	 src[offset1+i-1] = (IBYTE)limit_it((short)(acc/divisor));
       }
      offset += xsize; offset1 += xsize;
     }
    offset = xsize*(ysize-3);
    for(j=ysize-2; j>0; j--) {
      memcpy(src+offset+xsize+1, src+offset, xsize-2);
      offset -= xsize;
     }
    blank_frame(src, xsize, ysize, 1);
    return;
}


 
#define mid_max_5(a, b, c, d, e) ((c)>=(b) && (c)>=(d) && (d) >=(e) && (b)>=(a))

#define mid_max_3(a, b, c) ((b)>(a) && (b)>=(c))

//IBOOL mid_max_5(short int bf[5])
//{
// if(bf[2]>=bf[1] && bf[2]>=bf[3] && bf[1]>=bf[0] && bf[3]>=bf[4]) return ITRUE;
////if(bf[2]>bf[1] && bf[2]>=bf[3] && bf[1]>=bf[0] && bf[3]>=bf[4]) return ITRUE;
////   this > enable it to disable double width edge
// return IFALSE;
//}

void trace_peak(IBYTE *img, short int *buf, int xsize, int ysize, int th)
{
  int i,j;
  int offset;
  int  addr[25];
    //  0  1  2  3  4
    // 15 16 17 18  5
    // 14 23 24 19  6
    // 13 22 21 20  7
    // 12 11 10  9  8
    store_addr5x5(addr, xsize);
    for(j=2,offset=2*xsize; j<ysize-2; j++, offset+=xsize)
      for(i=2; i<xsize-2; i++) {
        if(buf[offset+i] < th) {img[offset+i]= 0; continue;}
        if(mid_max_5(buf[offset+i+addr[14]], buf[offset+i+addr[23]], 
                     buf[offset+i+addr[24]],
                     buf[offset+i+addr[19]], buf[offset+i+addr[ 6]]) )
          {img[offset+i] = 255; continue;}

        if(mid_max_5(buf[offset+i+addr[ 2]], buf[offset+i+addr[17]], 
                     buf[offset+i+addr[24]],
                     buf[offset+i+addr[21]], buf[offset+i+addr[10]]) )
          {img[offset+i] = 255; continue;}

        if(mid_max_5(buf[offset+i+addr[ 0]], buf[offset+i+addr[16]], 
                     buf[offset+i+addr[24]],
                     buf[offset+i+addr[20]], buf[offset+i+addr[ 8]]) )
          {img[offset+i] = 255; continue;}

        if(mid_max_5(buf[offset+i+addr[ 4]], buf[offset+i+addr[18]], 
                     buf[offset+i+addr[24]],
                     buf[offset+i+addr[22]], buf[offset+i+addr[12]]) )
          {img[offset+i] = 255; continue;}

        img[offset+i] = 0;
       }
    for(i=0; i<xsize; i++) img[i] = img[i+xsize] = img[i+(ysize-2)*xsize] = img[i+(ysize-1)*xsize] = 0;
    for(i=0; i<ysize; i++) img[i*xsize] = img[i*xsize+1] = img[i*xsize+xsize-2] = img[i*xsize+xsize-1] = 0;
    return;
}

/*
void convolution(IBYTE *src, IBYTE *des, int xsize, int ysize, int *conv, int convx, int convy)
{
	int convcx = convx/2, convcy = convy/2;
	int i,j,k;

	if(convx < 0 || convy < 0 || xsize < 0 || ysize < 0) return;

*/
