/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : fileload.c
// Description: load image files
// Create Date: 1997. 4. 11
// Modification(date/where):
//
// ****************************************************************

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#define _IMG_LIBBUILD_
#include "image.h"
#include "imgfile.h"
#include "..\util\utility.h"

// working only on DOS/Windows systems

IBOOL Loadfile_on_extension(const char * fname, ImageDes *img, int xsz, int ysz, IBOOL ping, char sepr)
{
  char ext[6], *pext;

  pext = get_file_extension(fname, sepr);
  if(!pext) // just try to load them
  {
#ifdef IJG_JPEG_READY
	  if(LoadJPEG(fname, img, ping)) return ITRUE;
#endif
#ifdef LIBPNG_READY
	  if(LoadPNG(fname, img, ping)) return ITRUE;
#endif
#ifdef GIF_READY
	  if(LoadGIF(fname, img, IFALSE, ping)) return ITRUE;
#endif
	  if(LoadBMP(fname, img, ping)) return ITRUE;
	  if(LoadTIFF24b(fname, img, ping)) return ITRUE;
	  if(LoadTGA24b(fname, img, ping)) return ITRUE;
	  if(LoadPCX8b(fname, img, ping)) return ITRUE;
	  if(LoadPSD32b(fname, img, ping)) return ITRUE;
	  return IFALSE; // no ext, just try to load or fail
  }
  strncpyupr(ext, pext, 5);
  
#ifdef IJG_JPEG_READY
  if(!strcmp(ext, "JPG"))  return LoadJPEG(fname, img, ping);
  if(!strcmp(ext, "JIF"))  return LoadJPEG(fname, img, ping);
  if(!strcmp(ext, "JPEG")) return LoadJPEG(fname, img, ping);
  if(!strcmp(ext, "JFIF")) return LoadJPEG(fname, img, ping);
#endif
#ifdef LIBPNG_READY
  if(!strcmp(ext, "PNG")) return LoadPNG(fname, img, ping);
#endif
#ifdef GIF_READY
  if(!strcmp(ext, "GIF")) return LoadGIF(fname, img, IFALSE, ping);
#endif
  if(!strcmp(ext, "BMP")) return LoadBMP(fname, img, ping);
  if(!strcmp(ext, "TIF")) return LoadTIFF24b(fname, img, ping);
  if(!strcmp(ext, "TGA")) return LoadTGA24b(fname, img, ping);
  if(!strcmp(ext, "PCX")) return LoadPCX8b(fname, img, ping);
  if(!strcmp(ext, "PSD")) return LoadPSD32b(fname, img, ping);

  // ping raw is not supported now
  if(ping) return IFALSE;
  if(LoadRawColor(fname, img, xsz, ysz)) return ITRUE;
  else return LoadRawGray(fname, img, xsz, ysz);
}

IBOOL Savefile_on_extension(const char * fname, ImageDes img, char sepr, int quality)
{
  char ext[6], *pext;

  pext = get_file_extension(fname, sepr);
  if(!pext) // just try to load them
  {
	  return IFALSE;
  }
  
  strncpyupr(ext, pext, 5);

  if(!strcmp(ext, "BMP")) 
     if(img.imagetype == ITrueColor) return SaveBMP24b(fname, img);
     else  return SaveBMP8b(fname, img);
  if(!strcmp(ext, "PCX")) return SavePCX8b(fname, img);
  if(!strcmp(ext, "TIF")) return SaveTIFF24b(fname, img);
  if(!strcmp(ext, "TGA")) return SaveTGA24b(fname, img);
#ifdef IJG_JPEG_READY
  if(!strcmp(ext, "JPG")) return SaveJPEG(fname, img, quality);
  if(!strcmp(ext, "JIF")) return SaveJPEG(fname, img, quality);
  if(!strcmp(ext, "JPEG")) return SaveJPEG(fname, img, quality);
  if(!strcmp(ext, "JFIF")) return SaveJPEG(fname, img, quality);
#endif
#ifdef LIBPNG_READY
  if(!strcmp(ext, "PNG")) return SavePNG(fname, img, IFALSE);
#endif
  if(img.imagetype == IGray) return SaveRawGrey(fname, img);
  else return SaveRawColor(fname, img);
}
