/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
/******************************************************************/
/*  Image process tool box*/
/*     by Yang Yudong*/
/**/
/* File : filetga.c*/
/* Description:  Targar 24 bits image file I/O*/
/* Create Date:  1996. 9. 25*/
/* Modification(date/where):*/
// Modification(date/where): 1996.11.23 Make the integer byte order system independent
/**/
/******************************************************************/

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#define _IMG_LIBBUILD_
#include "image.h"
#include "imgfile.h"


/*  Tagar file header*/
typedef struct TRGHDR {
        IBYTE        bIDFieldSize;           /* Characters in ID field */
        IBYTE        bClrMapType;            /* Color map type */
        IBYTE        bImageType;             /* Image type */
        IBYTE        lClrMapSpec[5];         /* Color map specification */
        IWORD        wXOrigin;               /* X origin */
        IWORD        wYOrigin;               /* Y origin */
        IWORD        wWidth;                 /* Bitmap width */
        IWORD        wHeight;                /* Bitmap height */
        IBYTE        bBitsPixel;             /* Bits per pixel */
        IBYTE        bImageDescriptor;       /* Image descriptor */
        } TRGHDR;
typedef TRGHDR *LPTRGHDR;



/* save image as a Targar 24 bits image*/
/*  conversion will be added if needed.*/
/* return ITRUE if successful*/

IBOOL SaveTGA24b(const char * fname, ImageDes img)
 {
  IBYTE * cr;
  IBYTE * cg;
  IBYTE * cb;
  int  offset;
  IBYTE *buf;
  int i, j, k;
  FILE *fd;
  TRGHDR thead;

  if(!img.load ) return IFALSE;
  if ((buf = (IBYTE *)malloc(img.xsize*3)) == NULL)
    return IFALSE;
  fd=fopen(fname, "wb");
  if(fd == NULL) { free(buf); return IFALSE; }

  thead.bIDFieldSize=0;                              /* Characters in ID field */
  thead.bClrMapType=0;;                              /* Color map type */
  thead.bImageType=2;                                /* Image type */
  for(i=0; i<5; i++) thead.lClrMapSpec[i]=0;            /* Color map specification */
  thead.wXOrigin=0;                                  /* X origin */
  thead.wYOrigin=0;                                  /* Y origin */
  thead.wWidth=(IWORD)img.xsize;                            /* Bitmap width */
  thead.wHeight=(IWORD)img.ysize;                           /* Bitmap height */
  thead.bBitsPixel=24;                               /* Bits per pixel */
  thead.bImageDescriptor=0x20;                       /* Image descriptor */

  /* write filehead */
  fputc(thead.bIDFieldSize, fd);
  fputc(thead.bClrMapType, fd);
  fputc(thead.bImageType, fd);
  fwrite(thead.lClrMapSpec, 5, 1, fd); 
  fputWord(thead.wXOrigin, fd, ITRUE);
  fputWord(thead.wYOrigin, fd, ITRUE);
  fputWord(thead.wWidth, fd, ITRUE);
  fputWord(thead.wHeight, fd, ITRUE);
  fputc(thead.bBitsPixel, fd);
  fputc(thead.bImageDescriptor, fd);

  cr = img.r;
  if(img.imagetype == ITrueColor) {
        cg = img.g;
        cb = img.b;
        offset = 0;
        for(i = 0; i < img.ysize;  i++ ){
           __Img_Busy(i*100/img.ysize);
           for(j=0, k=0; j<img.xsize; j++, k+=3) {
                buf[k  ] = *(cb+offset); 
                buf[k+1] = *(cg+offset); 
                buf[k+2] = *(cr+offset);
                offset++;
           }
           fwrite(buf, img.xsize*3, 1, fd);
        }
  }
  else if(img.imagetype == IGrey) {
    offset = 0;
    for(i = 0; i < img.ysize;  i++ ) {
        __Img_Busy(i*100/img.ysize);
        for(j=0, k=0; j<img.xsize; j++, k+=3) {
                buf[k  ] = buf[k+1] = buf[k+2] = *(cr+offset);
                offset ++;
        }      
        fwrite(buf, img.xsize*3, 1, fd);
    }
  }
  else {
    offset = 0;
    for(i = 0; i < img.ysize;  i++ ) {
        __Img_Busy(i*100/img.ysize);
        for(j=0, k=0; j<img.xsize; j++, k+=3) {
              buf[k  ] = img.pal[*(cr+offset+j)].b;
              buf[k+1] = img.pal[*(cr+offset+j)].g;
              buf[k+2] = img.pal[*(cr+offset+j)].r;
              offset ++;
        }      
        fwrite(buf, img.xsize*3, 1, fd);
    }
  }  
  fclose(fd);
  free(buf);
  __Img_Busy(0);
  return ITRUE;
 }



/* load Targar 24 bits image*/
/* return ITRUE if successful*/
IBOOL LoadTGA24b(const char * fname, ImageDes *img, IBOOL ping)
 {
  IBYTE * cr;
  IBYTE * cg;
  IBYTE * cb;
  int  offset;
  IBYTE *buf;
  int  i, j, k;
  FILE *fd;
  TRGHDR thead;

  fd=fopen(fname, "rb");
  if(fd == NULL)
    return IFALSE; 

  /* read filehead */
  thead.bIDFieldSize = (IBYTE)fgetc(fd);
  thead.bClrMapType = (IBYTE)fgetc(fd);
  thead.bImageType = (IBYTE)fgetc(fd);
  fread(thead.lClrMapSpec, 5, 1, fd); 
  thead.wXOrigin = fgetWord(fd, ITRUE);
  thead.wYOrigin = fgetWord(fd, ITRUE);
  thead.wWidth = fgetWord(fd, ITRUE);
  thead.wHeight = fgetWord(fd, ITRUE);
  thead.bBitsPixel = (IBYTE)fgetc(fd);
  thead.bImageDescriptor = (IBYTE)fgetc(fd);

  if ((thead.bImageType!=2) || (thead.bBitsPixel!=24))
           {fclose(fd); return IFALSE;}    /* not an TGA 24 bits file*/

   if(ping) 
   {
		fclose(fd);
		return InitPicture(img, thead.wWidth, thead.wHeight, ITrueColor, IFALSE, 0);
   }

  if(!AllocPicture(img, thead.wWidth, thead.wHeight, ITrueColor, IFALSE, 0)){
       fclose(fd); return IFALSE;  /* can not allocate enough memory*/
     }

  if ((buf=(IBYTE *)malloc(thead.wWidth*3)) == NULL) {
        fclose(fd);
        FreePicture(img);
        return IFALSE;
  }   /* can not allocate buffer*/

  cr = img->r;
  cg = img->g;
  cb = img->b;
  offset = 0;
  for(i = 0; i <thead.wHeight;   i++ ) {
     __Img_Busy(i*100/thead.wHeight);
     fread(buf, thead.wWidth*3, 1, fd);
     for(j=0, k=0; j<thead.wWidth; j++, k+=3)  { 
        *(cb+offset) = buf[k  ]; 
        *(cg+offset) = buf[k+1]; 
        *(cr+offset) = buf[k+2];
        offset++;
     }
  }
  fclose(fd);
  free(buf);
  img->load = ITRUE;
  __Img_Busy(0);
  return ITRUE;
 }

