/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : ibinary.c
// Description:  binarilize an image
// Create Date:  1996. 10. 7
// Modification(date/where): 
//
//****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"
#include "routines.h"


// Kodalith Brighten Image
// binary-code the image at level 'threshold'

IBOOL  image_threshold(ImageDes img, IBYTE threshold)
{
  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
//  if(threshold > 255 || threshold < 1)  return IFALSE;
  __Img_Busy(1);
  threshold_(img.r, threshold, 0, 255, img.xsize, img.ysize);
  __Img_Busy(img.imagetype == IGrey ? 95 : 33);
  if(img.imagetype == IGrey) {__Img_Busy(0); return ITRUE;}
  threshold_(img.g, threshold, 0, 255, img.xsize, img.ysize);
  __Img_Busy(66);
  threshold_(img.b, threshold, 0, 255, img.xsize, img.ysize);
  __Img_Busy(0);
  return ITRUE;
}

IBOOL  image_kodalithprocess(ImageDes img, IBYTE threshold)
{
  return image_threshold(img, threshold);
}

