/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : ibitpack.c
// Description:  do pack/unpack of image pixels
// Create Date: 02/02/2000
// Modification(date/where): 
//
// ****************************************************************
#include <malloc.h>
#include <string.h>
#include <stdio.h>


#define _IMG_LIBBUILD_
#include "image.h"
#include "routines.h"

//   pack R,G,B image to packed RGB image
//   Tricks:
//      packed_line_inc can be negtive to pack to bottom2up format
//      and des should be real des + packed_line_inc*ysize
IBOOL img_rgb_2_packed_noalpha(ImageDes *src,  IBYTE *des, int packed_line_inc, IDWORD rPos, IDWORD gPos, IDWORD bPos, IDWORD packed_pixel_size)
{
   register IBYTE *r, *g, *b;
   register IDWORD xcnt, ycnt;
   int tailer = packed_line_inc - (int)src->xsize*(int)packed_pixel_size;
   
   if(!src || !des || !src->load || src->imagetype != ITrueColor) return IFALSE;
   r = src->r;    g = src->g;    b = src->b;
   for(ycnt=src->ysize; ycnt; ycnt--)
   {
	   for(xcnt=src->xsize; xcnt; xcnt--)
	   {
		   *(des+rPos) = *(r++);
		   *(des+gPos) = *(g++);
		   *(des+bPos) = *(b++);
		   des += packed_pixel_size;
	   }
	   des += tailer;
   }
   return ITRUE;       
}

IBOOL img_r_g_b_2_packed_noalpha(IDWORD xsize, IDWORD ysize, IBYTE *sr, IBYTE *sg, IBYTE *sb, int src_line_inc, IBYTE *des, int packed_line_inc, IDWORD rPos, IDWORD gPos, IDWORD bPos, IDWORD packed_pixel_size)
{
   register IBYTE *r, *g, *b;
   register IDWORD xcnt, ycnt;
   int tailer = packed_line_inc - (int)xsize*(int)packed_pixel_size;

   int tailersrc = (int)xsize - src_line_inc;
   
   if(!sr || !sg || !sb || !des) return IFALSE;
   r = sr;    g = sg;    b = sb;
   for(ycnt=ysize; ycnt; ycnt--)
   {
	   for(xcnt=xsize; xcnt; xcnt--)
	   {
		   *(des+rPos) = *(r++);
		   *(des+gPos) = *(g++);
		   *(des+bPos) = *(b++);
		   des += packed_pixel_size;
	   }
	   des += tailer;
	   r += tailersrc;
	   g += tailersrc;
	   b += tailersrc;
   }
   return ITRUE;       
}

//   pack R,G,B, A image to packed RGBA image
//   Tricks:
//      packed_line_inc can be negtive to pack to bottom2up format
//      and des should be real des + packed_line_inc*ysize
IBOOL img_rgb_2_packed_alpha(ImageDes *src,  IBYTE *des, IDWORD packed_line_inc, IDWORD rPos, IDWORD gPos, IDWORD bPos, IDWORD aPos, IDWORD packed_pixel_size)
{
   register IBYTE *r, *g, *b;
   register IDWORD xcnt, ycnt;
   int tailer = packed_line_inc - (int)src->xsize*(int)packed_pixel_size;
   
   if(!src || !des || !src->load || src->imagetype != ITrueColor) return IFALSE;
   r = src->r;    g = src->g;    b = src->b;
   if(src->alpha)
   {
	   register IBYTE *a = src->a;
	   for(ycnt=src->ysize; ycnt; ycnt--)
	   {
		   for(xcnt=src->xsize; xcnt; xcnt--)
		   {
			   *(des+rPos) = *(r++);
			   *(des+gPos) = *(g++);
			   *(des+bPos) = *(b++);
			   *(des+aPos) = *(a++);
			   des += packed_pixel_size;
		   }
		   des += tailer;
	   }
   }
   else
   {
	   for(ycnt=src->ysize; ycnt; ycnt--)
	   {
		   for(xcnt=src->xsize; xcnt; xcnt--)
		   {
			   *(des+rPos) = *(r++);
			   *(des+gPos) = *(g++);
			   *(des+bPos) = *(b++);
			   *(des+aPos) = 0;
			   des += packed_pixel_size;
		   }
		   des += tailer;
	   }
   }
   return ITRUE;       
}


// unpack RGB image to R,G,B ImageDes
//   Tricks:
//      packed_line_inc can be negtive to unpack from bottom2up format
//      and src should be real src + packed_line_inc*ysize
IBOOL img_packed_2_img_noalpha(IBYTE *src, IDWORD xsize, IDWORD ysize, int packed_line_inc, IDWORD rPos, IDWORD gPos, IDWORD bPos, IDWORD packed_pixel_size, ImageDes *des)
{
   register IBYTE *r, *g, *b;
   register IDWORD xcnt, ycnt;
   int tailer = packed_line_inc - (int)xsize*(int)packed_pixel_size;
   
   if(!src || !des || xsize == 0 || ysize == 0) return IFALSE;
   if(!AllocPicture(des, xsize, ysize, ITrueColor, IFALSE, 256)) return IFALSE;
   r = des->r;    g = des->g;    b = des->b;
   for(ycnt=ysize; ycnt; ycnt--)
   {
	   for(xcnt=xsize; xcnt; xcnt--)
	   {
		   *(r++) = *(src+rPos);
		   *(g++) = *(src+gPos);
		   *(b++) = *(src+bPos);
		   src += packed_pixel_size;
	   }
	   src += tailer;
   }
   des->load = ITRUE;
   return ITRUE;       
}


// unpack RGBA image to R,G,B,A ImageDes
//   Tricks:
//      packed_line_inc can be negtive to unpack from bottom2up format
//      and src should be real src + packed_line_inc*ysize
IBOOL img_packed_2_img_alpha(IBYTE *src, IDWORD xsize, IDWORD ysize, int packed_line_inc, IDWORD rPos, IDWORD gPos, IDWORD bPos, IDWORD aPos, IDWORD packed_pixel_size, ImageDes *des)
{
   register IBYTE *r, *g, *b, *a;
   register IDWORD xcnt, ycnt;
   int tailer = packed_line_inc - (int)xsize*(int)packed_pixel_size;
   
   if(!src || !des || xsize == 0 || ysize == 0) return IFALSE;
   if(!AllocPicture(des, xsize, ysize, ITrueColor, ITRUE, 256)) return IFALSE;
   r = des->r;    g = des->g;    b = des->b;  a = des->a;
   for(ycnt=ysize; ycnt; ycnt--)
   {
	   for(xcnt=xsize; xcnt; xcnt--)
	   {
		   *(r++) = *(src+rPos);
		   *(g++) = *(src+gPos);
		   *(b++) = *(src+bPos);
		   *(a++) = *(src+aPos);
		   src += packed_pixel_size;
	   }
	   src += tailer;
   }
   des->load = ITRUE;
   return ITRUE;       
}
